/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.LazyStream;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LazyStreamElementInstruction
extends Instruction
implements ISpecialForm,
IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction,
IBinding {
    protected Instruction m_source;
    protected Instruction m_index;
    protected Instruction m_body;
    protected Instruction m_otherwise;
    protected Object m_var;
    protected Type m_elementType = new TypeVariable();
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;

    public LazyStreamElementInstruction() {
        assert (this.initBogusStackframePos());
    }

    public LazyStreamElementInstruction(Instruction source, Instruction index2, Object var, Instruction body, Instruction otherwise) {
        this.m_source = source;
        this.m_index = index2;
        this.m_var = var;
        this.m_body = body;
        this.m_otherwise = otherwise;
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    public Instruction getIndex() {
        return this.m_index;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        this.m_index = rh.reduceToBasicInstruction(state, this.m_index, benv);
        if (this.m_otherwise != null) {
            ReductionHelper rh3 = (ReductionHelper)rh.clone();
            this.m_otherwise = rh3.reduce(this.m_otherwise, benv);
        }
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        rh2.upgradeBinding(this);
        benv.setVariableBinding(this);
        this.m_body = rh2.reduce(this.m_body, benv);
        state[0] = this;
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        benv.setVariableBinding(this);
        super.typeCheckReduced(tenv, benv, functionStack);
        try {
            tenv.unify(this.m_source.getType(tenv, benv), new LazyStreamType(this.m_elementType), this);
        }
        catch (TypeCheckException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        LazyStreamElementInstruction i = new LazyStreamElementInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_index.cloneWithoutTypeInformation(), this.m_var, this.m_body.cloneWithoutTypeInformation(), this.m_otherwise.cloneWithoutTypeInformation());
        LazyStreamElementInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_source.typeCheck(tenv, benv, functionStack), new LazyStreamType(this.m_elementType), this);
        tenv.unify(this.m_index.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        benv2.setVariableBinding(this);
        Type bodyType = this.m_body.typeCheck(tenv, benv2, functionStack);
        if (this.m_otherwise != null) {
            tenv.unify(bodyType, this.m_otherwise.typeCheck(tenv, new BindingEnvironment(benv), functionStack), this);
        }
        return this.setCachedType(bodyType);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object element2;
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object result2 = null;
        LazyStream source = (LazyStream)this.m_source.evaluate(e, f2, di, false);
        Integer index2 = (Integer)this.m_index.evaluate(e, f2, di, false);
        int i = index2;
        try {
            element2 = source.get(i);
            element2 = XCIConstruction.evalForkIfNeeded(element2, e);
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (this.m_otherwise != null) {
                result2 = this.m_otherwise.evaluate(e, f2, di, tailPosition);
                return Debugger.leave(di, this, e, f2, result2);
            }
            throw new XylemError("ERR_SYSTEM", "index out of bounds on lazy stream");
        }
        e.bindInCurrentFrame(this, element2);
        result2 = this.m_body.evaluate(e, f2, di, tailPosition);
        return Debugger.leave(di, this, e, f2, result2);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("lazy-stream-element", indent);
        this.m_source.toString(pw, indent + 1);
        this.m_index.toString(pw, indent + 1);
        pw.printIdentifier(this.m_var, indent + 1);
        this.m_body.toString(pw, indent + 1);
        if (this.m_otherwise != null) {
            this.m_otherwise.toString(pw, indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        set2.remove(this);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        set2.remove(this);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeInstruction(this.m_index);
        wofh.writeBindingName(this.m_var);
        wofh.writeInstruction(this.m_body);
        wofh.writeBoolean(this.m_otherwise != null);
        if (this.m_otherwise != null) {
            wofh.writeInstruction(this.m_otherwise);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_index = rofh.readInstruction(benv);
        this.m_var = rofh.readBindingName();
        this.m_body = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_otherwise = rofh.readInstruction(benv);
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 2 || i == 3;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (i != 2) {
            return null;
        }
        return new IBinding[]{this};
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return this.isChildInstructionBody(i);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object s = ing.getNewName();
        names.put(this.m_var, new IdentifierInstruction(s));
        return new LazyStreamElementInstruction(this.m_source.assignNewNames(names, ing), this.m_index.assignNewNames(names, ing), s, this.m_body.assignNewNames(names, ing), this.m_otherwise == null ? null : this.m_otherwise.assignNewNames(names, ing));
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            if (!this.m_body.supportsCodeGenerationOptimization(cgos, tenv, benv)) {
                return false;
            }
            return this.m_otherwise == null || this.m_otherwise.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        if (cgos instanceof StreamInADTOptimizationStyle) {
            if (!this.m_body.supportsCodeGenerationOptimization(cgos, tenv, benv)) {
                return false;
            }
            return this.m_otherwise == null || this.m_otherwise.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        Instruction h = this.m_body;
        if (!((IStreamInADTOptimizationInstruction)((Object)h)).canGenerateObjectless(tenv)) {
            return false;
        }
        return this.m_otherwise == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_otherwise)).canGenerateObjectless(tenv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        throw new XylemError("ERR_SYSTEM", "LazyStreamElement:generateCode not yet implemented");
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        throw new XylemError("ERR_SYSTEM", "not implemented yet");
    }

    @Override
    public Type getBindingType() {
        return this.m_elementType;
    }

    @Override
    public Type getBindingType(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_elementType;
    }

    @Override
    public Object getName() {
        return this.m_var;
    }

    @Override
    public void setName(Object name2) {
        this.m_var = name2;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_elementType : null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_index;
            }
            case 2: {
                return this.m_body;
            }
            case 3: {
                return this.m_otherwise;
            }
        }
        return null;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_otherwise == null ? 3 : 4;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_index = n2;
                break;
            }
            case 2: {
                this.m_body = n2;
                break;
            }
            case 3: {
                this.m_otherwise = n2;
            }
        }
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_elementType = n2;
        }
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public ISpecialForm getOrigin() {
        return null;
    }

    @Override
    public int compareTo(Object arg0) {
        return Binding.compare(this, arg0);
    }

    @Override
    public Instruction cloneShallow() {
        LazyStreamElementInstruction i = new LazyStreamElementInstruction(this.m_source, this.m_index, this.m_var, this.m_body, this.m_otherwise);
        LazyStreamElementInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void clearVariableUse() {
        this.m_useCount = 0;
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int pos) {
        this.m_stackFramePos = pos;
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }
}

