/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetOnceInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public abstract class LetBaseInstruction
extends Instruction
implements IBinding,
ISpecialForm {
    static final boolean DEBUG_RELEASE = false;
    protected Instruction m_value;
    protected Instruction m_body;
    protected Object m_variable;
    protected Type m_cachedValueType = null;
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;
    public Set m_partialInformation = null;

    public LetBaseInstruction() {
        assert (this.initBogusStackframePos());
    }

    public LetBaseInstruction(Object variable2, Instruction value2, Instruction body) {
        this.m_value = value2;
        this.m_body = body;
        this.m_variable = variable2;
        if (variable2 == null || variable2 instanceof Instruction || variable2 instanceof Binding) {
            throw new InternalError("A let variable must not be " + variable2);
        }
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    @Override
    public int compareTo(Object other2) {
        return Binding.compare(this, other2);
    }

    public Object getVariable() {
        return this.m_variable;
    }

    public void setVariable(Object n2) {
        this.m_variable = n2;
    }

    public IBinding getBinding() {
        return this;
    }

    public Instruction getValue() {
        return this.m_value;
    }

    public void setValue(Instruction n2) {
        this.m_value = n2;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    public abstract Instruction cloneWithoutTypeInformation(Object var1, Instruction var2, Instruction var3);

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        LetBaseInstruction leti = this;
        while (leti.m_body instanceof LetBaseInstruction) {
            leti = (LetBaseInstruction)leti.m_body;
        }
        return leti.m_body.getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        LetBaseInstruction leti = this;
        while (leti.m_body instanceof LetBaseInstruction) {
            leti = (LetBaseInstruction)leti.m_body;
        }
        if (leti.m_body instanceof IdentifierInstruction) {
            return this.getPreTypecheckType(msig, (IdentifierInstruction)leti.m_body);
        }
        return leti.m_body.getPreTypecheckType(msig);
    }

    public Type getPreTypecheckType(ModuleSignature msig, IdentifierInstruction identifier) {
        LetBaseInstruction leti = this;
        Object varWeAreLookingFor = identifier.getVariable();
        while (true) {
            if (leti.m_variable != null && leti.m_variable.equals(varWeAreLookingFor)) {
                return leti.getValue().getPreTypecheckType(msig);
            }
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        return null;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        if (this.m_value != null) {
            Type t;
            this.m_cachedValueType = this.m_value.typeCheck(tenv, benv, functionStack);
            assert (this.m_value.getCachedType() != null);
            BindingEnvironment benv2 = new BindingEnvironment(benv, this);
            if (this.m_body instanceof LetBaseInstruction) {
                t = LetBaseInstruction.typeCheck2((LetBaseInstruction)this.m_body, tenv, benv2, functionStack);
            } else {
                t = this.m_body.typeCheck(tenv, benv2, functionStack);
                assert (this.m_body.getCachedType() != null);
            }
            return this.setCachedType(t);
        }
        return null;
    }

    public static Type typeCheck2(LetBaseInstruction outerLeti, TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        LetBaseInstruction leti = outerLeti;
        Type bodyType = null;
        while (true) {
            leti.doDefaultTypeCheck(tenv, benv, functionStack);
            leti.m_cachedValueType = leti.m_value.typeCheck(tenv, benv, functionStack);
            benv = new BindingEnvironment(benv, leti);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        bodyType = leti.m_body.typeCheck(tenv, benv, functionStack);
        leti = outerLeti;
        while (true) {
            leti.setCachedType(bodyType);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        return bodyType;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_value;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public int getChildInstructionCount() {
        return 2;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_value = n2;
                break;
            }
            case 1: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        LetBaseInstruction leti;
        Instruction x = this;
        while (x instanceof LetBaseInstruction) {
            leti = x;
            leti.getValue().accumulateNonLiteralFreeBindings(set2, benv);
            x = leti.getBody();
        }
        ((Instruction)x).accumulateNonLiteralFreeBindings(set2, benv);
        x = this;
        while (x instanceof LetBaseInstruction) {
            leti = x;
            set2.remove(leti);
            x = leti.getBody();
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        LetBaseInstruction leti;
        Instruction x = this;
        while (x instanceof LetBaseInstruction) {
            leti = x;
            leti.getValue().accumulateFreeBindings(set2, benv);
            x = leti.getBody();
        }
        ((Instruction)x).accumulateFreeBindings(set2, benv);
        x = this;
        while (x instanceof LetBaseInstruction) {
            leti = x;
            set2.remove(leti);
            x = leti.getBody();
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        LetBaseInstruction leti = this;
        while (true) {
            benv.setVariableBinding(leti);
            leti.m_value.typeCheckReduced(tenv, benv, functionStack);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti.clearLocalForTypecheckReduced();
            leti = (LetBaseInstruction)leti.m_body;
        }
        leti.m_body.typeCheckReduced(tenv, benv, functionStack);
        leti.clearLocalForTypecheckReduced();
    }

    @Override
    public void clearTypeInformation() {
        LetBaseInstruction leti = this;
        while (true) {
            leti.m_bindingEnvironment = null;
            leti.m_hasBeenTypechecked = false;
            leti.m_value.clearTypeInformation();
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        leti.m_body.clearTypeInformation();
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        Instruction x = this;
        while (x instanceof LetBaseInstruction) {
            LetBaseInstruction leti = x;
            if (null != di) {
                di.enter(leti.toStringShort(), x, e, f2);
            }
            Object val = leti.m_value.evaluate(e, f2, di, false);
            e.bindInCurrentFrame(leti, val);
            if (null != di) {
                Debugger.leave(di, leti.toStringShort(), e, f2, val);
            }
            x = leti.getBody();
        }
        ans = ((Instruction)x).evaluate(e, f2, di, tailPosition);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Instruction x = this;
        while (x instanceof LetBaseInstruction) {
            LetBaseInstruction leti = x;
            if (null != di) {
                di.enter(leti.toStringShort(), x, e, f2);
            }
            Object val = leti.m_value.evaluate(e, f2, di, false);
            e.bindInCurrentFrame(leti, val);
            if (null != di) {
                Debugger.leave(di, leti.toStringShort(), e, f2, val);
            }
            x = leti.getBody();
        }
        ((Instruction)x).evaluate(as, e, f2, di);
        Debugger.leave(di, this, e, f2, null);
    }

    @Override
    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings, Instruction parent2, int index2, BindingEnvironment benv) {
        LetBaseInstruction leti = this;
        while (true) {
            leti.m_value.determineDataDependencies(specificBindings, collectedBindings, leti, 0, benv);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            parent2 = leti;
            index2 = 0;
            leti = (LetBaseInstruction)leti.m_body;
        }
        leti.m_body.determineDataDependencies(specificBindings, collectedBindings, leti, 1, benv);
    }

    @Override
    public void determineDataDependencies(Set collectedBindings) {
        LetBaseInstruction leti = this;
        while (true) {
            leti.m_value.determineDataDependencies(collectedBindings);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        leti.m_body.determineDataDependencies(collectedBindings);
    }

    @Override
    public void accumulateFunctionsCalled(Set<String> set2) {
        LetBaseInstruction leti = this;
        while (true) {
            leti.m_value.accumulateFunctionsCalled(set2);
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        leti.m_body.accumulateFunctionsCalled(set2);
    }

    @Override
    public Instruction removeAliases(HashMap aliases) {
        LetBaseInstruction leti = this;
        LetBaseInstruction outer = null;
        LetBaseInstruction inner2 = null;
        while (true) {
            leti.m_partialInformation = null;
            if (leti.m_value instanceof IdentifierInstruction) {
                Object y;
                IdentifierInstruction ii = (IdentifierInstruction)leti.m_value;
                Object x = ii.getVariable();
                while ((y = aliases.get(x)) != null) {
                    x = y;
                }
                aliases.put(leti.getName(), x);
            } else {
                Instruction newValue = leti.m_value.removeAliases(aliases);
                leti.setValue(newValue);
                LetBaseInstruction newInner = leti;
                if (inner2 == null) {
                    outer = inner2 = newInner;
                } else {
                    inner2.setBody(newInner);
                    inner2 = newInner;
                }
            }
            if (!(leti.m_body instanceof LetBaseInstruction)) break;
            leti = (LetBaseInstruction)leti.m_body;
        }
        Instruction newBody = leti.m_body.removeAliases(aliases);
        if (inner2 != null) {
            inner2.setBody(newBody);
            return outer;
        }
        return newBody;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        Instruction body;
        LetBaseInstruction leti = this;
        while (true) {
            wofh.writeBindingName(leti.getVariable());
            wofh.writeInstruction(leti.getValue());
            body = leti.getBody();
            if (!(body instanceof LetBaseInstruction)) break;
            wofh.writeBoolean(true);
            leti = (LetBaseInstruction)body;
            wofh.writeBoolean(leti instanceof LetOnceInstruction);
        }
        wofh.writeBoolean(false);
        wofh.writeInstruction(body);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        LetBaseInstruction leti = this;
        while (true) {
            leti.m_variable = rofh.readBindingName();
            leti.m_value = rofh.readInstruction(benv);
            boolean b = rofh.readBoolean();
            if (!b) break;
            boolean isLetOnce = rofh.readBoolean();
            LetBaseInstruction leti2 = isLetOnce ? new LetOnceInstruction() : new LetInstruction();
            leti.setBody(leti2);
            leti = leti2;
        }
        leti.setBody(rofh.readInstruction(benv));
    }

    @Override
    public Type getBindingType() {
        return this.m_cachedValueType;
    }

    @Override
    public Type getBindingType(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.getValue().getType(tenv, benv);
        if (t == null) {
            throw new RuntimeException();
        }
        return t;
    }

    @Override
    public Object getName() {
        return this.m_variable;
    }

    @Override
    public void setName(Object name2) {
        this.m_variable = name2;
    }

    public void resetCachedValueType() {
        this.m_cachedValueType = null;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        IBinding[] iBindingArray;
        if (i == 1) {
            IBinding[] iBindingArray2 = new IBinding[1];
            iBindingArray = iBindingArray2;
            iBindingArray2[0] = this;
        } else {
            iBindingArray = null;
        }
        return iBindingArray;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return i == 1;
    }

    @Override
    public void doPropagateInfo(Instruction from2) {
        try {
            Instruction x = this;
            Instruction y = from2;
            while (x instanceof LetBaseInstruction && y instanceof LetBaseInstruction) {
                LetBaseInstruction let = x;
                LetBaseInstruction letfrom = (LetBaseInstruction)y;
                x = let.getBody();
                y = letfrom.getBody();
                if (null != let.getSourceFilename() || null != let.getSourceLocation()) continue;
                let.setSourceFilename(letfrom.getSourceFilename());
                let.setSourceLineNumber(letfrom.getSourceLineNumber());
                let.setSourceLocation(letfrom.getSourceLocation());
                if (let.getValue() == null || letfrom.getValue() == null) continue;
                let.getValue().doPropagateInfo(letfrom.getValue());
            }
            if (x != null && y != null) {
                ((Instruction)x).doPropagateInfo(y);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    @Override
    public void doPropagateLocInfo(URL url, int line) {
        Instruction x = this;
        while (x instanceof LetBaseInstruction) {
            x.setSourceFilename(url);
            x.setSourceLineNumber(line);
            LetBaseInstruction let = x;
            let.getValue().doPropagateLocInfo(url, line);
            x = let.getBody();
        }
        ((Instruction)x).doPropagateLocInfo(url, line);
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public void clearVariableUse() {
        this.m_useCount = 0;
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int pos) {
        this.m_stackFramePos = pos;
    }

    public String toStringShort() {
        PrettyPrinter pw = new PrettyPrinter();
        this.toStringShort(pw, 0);
        return pw.toString();
    }

    public void toStringShort(PrettyPrinter pw, int indent) {
        String com = this.getLocationComment();
        if (com != null) {
            pw.comment(com, indent);
        }
        pw.printFormOpen(this.innerToString(), indent);
        if (this.getChildInstructionCount() > 0) {
            Instruction n2 = this.getChildInstruction(0);
            if (n2 != null) {
                n2.toString(pw, indent + 1);
            } else {
                pw.printToken("null", indent + 1);
            }
        }
        pw.printFormClose(indent);
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }

    private static class CheckRefToVarFromValueAnalyzer
    extends Optimizer {
        private Object m_variableToCheck;
        private boolean foundBad;
        private static CheckRefToVarFromValueAnalyzer checker = new CheckRefToVarFromValueAnalyzer();

        private CheckRefToVarFromValueAnalyzer() {
        }

        public void setVariableToCheck(Object variableToCheck) {
            this.m_variableToCheck = variableToCheck;
            this.foundBad = false;
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            if (n2 instanceof IdentifierInstruction && ((IdentifierInstruction)n2).getVariable().equals(this.m_variableToCheck)) {
                this.foundBad = true;
            }
            return super.optimizeStep(n2);
        }

        static boolean CheckRefToVarFromValue(Object variableToCheck, Instruction valueInstruction) {
            checker.setVariableToCheck(variableToCheck);
            checker.optimize(valueInstruction);
            return !CheckRefToVarFromValueAnalyzer.checker.foundBad;
        }
    }
}

