/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalBasedOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.ForkStack;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class LetInstruction
extends LetBaseInstruction
implements IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction {
    public boolean m_inUse = false;
    public LetInstruction m_parent = null;
    public LetChainManager m_lcm = null;
    private static final boolean _shouldBracketWithForkStackFrame = false;

    public LetInstruction() {
    }

    public LetInstruction(Object variable2, Instruction value2, Instruction body) {
        super(variable2, value2, body);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction i = LetInstruction.cloneWithoutTypeInformation2(this);
        LetInstruction.propagateInfo(this, i);
        return i;
    }

    public static Instruction cloneWithoutTypeInformation2(LetInstruction li) {
        LetInstruction original = li;
        LetInstruction root2 = li = (LetInstruction)li.cloneShallow();
        assert (li != original);
        Instruction originalValue = li.m_value;
        li.m_value = li.m_value.cloneWithoutTypeInformation();
        assert (originalValue == original.m_value);
        while (li.getBody() instanceof LetInstruction) {
            Instruction oldBody = li.getBody();
            li.setBody(li.getBody().cloneShallow());
            li.getBody().m_creationTraceException = oldBody.m_creationTraceException;
            li = (LetInstruction)li.getBody();
            li.setValue(li.getValue().cloneWithoutTypeInformation());
        }
        li.setBody(li.getBody().cloneWithoutTypeInformation());
        return root2;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Object name2, Instruction value2, Instruction body) {
        LetInstruction li = new LetInstruction(name2, value2, body);
        li.m_creationTraceException = this.m_creationTraceException;
        return li;
    }

    @Override
    public Instruction cloneShallow() {
        LetInstruction i = new LetInstruction(this.getName(), this.m_value, this.m_body);
        LetInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "let";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.getName().toString();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        boolean shouldBracketWithForkStackFrame = false;
        if (shouldBracketWithForkStackFrame) {
            FcgClassReferenceType thisClass = cgt.generateRefToForkStack(cgh, il);
            if (thisClass != null) {
                FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                il.invokeInstanceMethodStmt(forkType, "pushForkScope", (FcgType)FcgType.VOID, 0);
            } else {
                shouldBracketWithForkStackFrame = false;
            }
        }
        Instruction body = this.skipLetCodegen(cgt, null);
        FcgType resultType = body.generateCode(cgh, cgt, null, tailPosition, il, valueStyleRequest);
        boolean resultForkable = this.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
        if (shouldBracketWithForkStackFrame) {
            FcgVariable escapingValue = resultForkable ? il.defineVar(resultType, cgh.generateNewLocalVariableName(), true) : null;
            FcgClassReferenceType thisClass = cgt.generateRefToForkStack(cgh, il);
            if (thisClass != null) {
                if (resultForkable && escapingValue != null) {
                    il.loadVar(escapingValue);
                    FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                    FcgType[] argTypes = new FcgType[]{cgh.getClassReferenceType(Object.class.getName())};
                    il.invokeInstanceMethodStmt(forkType, "popForkScope", (FcgType)FcgType.VOID, argTypes);
                    il.loadVar(escapingValue);
                } else {
                    FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                    il.invokeInstanceMethodStmt(forkType, "popForkScope", (FcgType)FcgType.VOID, 0);
                }
            }
        }
        return resultType;
    }

    public Object[] generateReleaseHandles(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il) {
        LetInstruction li;
        Object[] releaseVars = null;
        ArrayList<FcgVariable> buffer = new ArrayList<FcgVariable>();
        Instruction i = this;
        boolean releaseNeeded = false;
        do {
            Type t;
            if ((t = (li = i).getValue().evaluateType(cgt.m_function)).isForkReleaseManaged(cgt)) {
                FcgType ft = t.getFCGType(cgh);
                String varName = cgh.generateNewLocalVariableName();
                FcgVariable fv = il.defineVar(ft, varName, false);
                buffer.add(fv);
                releaseNeeded = true;
                continue;
            }
            buffer.add(null);
        } while ((i = li.getBody()) instanceof LetInstruction);
        if (releaseNeeded) {
            releaseVars = buffer.toArray();
        }
        return releaseVars;
    }

    void generateReleaseFromHandles(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, Object[] releaseVars, FcgType resultType, boolean resultForkable) {
        il.comment("Begin release let chain");
        if (releaseVars == null) {
            return;
        }
        String varName = cgh.generateNewLocalVariableName();
        FcgVariable topLevelResult = resultType == null || resultType == FcgType.VOID ? null : il.defineVar(resultType, varName, true);
        Instruction inst = this;
        int whichmax = releaseVars.length - 1;
        int which = 0;
        do {
            FcgVariable result2 = which == whichmax ? topLevelResult : (FcgVariable)releaseVars[which + 1];
            resultType = result2 == null ? FcgType.VOID : result2.getType();
            LetInstruction li = inst;
            Type t = li.getValue().evaluateType(cgt.m_function);
            inst = li.getBody();
        } while (++which <= whichmax);
        il.comment("End release let chain");
        if (topLevelResult != null) {
            il.loadVar(topLevelResult);
        }
    }

    public Instruction skipLetCodegen(CodeGenerationTracker cgt, Object[] reservedFcgVariables) {
        Instruction n2 = this;
        int i = 0;
        do {
            LetInstruction li = n2;
            cgt.registerBinding((IBinding)li, li.m_value);
            n2 = li.m_body;
            ++i;
        } while (n2 instanceof LetInstruction);
        return n2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        boolean shouldBracketWithForkStackFrame = false;
        if (shouldBracketWithForkStackFrame) {
            shouldBracketWithForkStackFrame = ConventionalFunctionGenerationStyle.startForkScope(cgh, il, shouldBracketWithForkStackFrame);
        }
        Instruction body = this.skipLetCodegen(cgt, null);
        FcgType t = ((IStreamInADTOptimizationInstruction)((Object)body)).generateCode(cgh, il, streamName, memberInADT, cgt, objectless, tailPosition);
        if (shouldBracketWithForkStackFrame) {
            ConventionalFunctionGenerationStyle.popForkScope(cgh, cgt, t, il, this.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment));
        }
        return t;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        boolean shouldBracketWithForkStackFrame = false;
        if (shouldBracketWithForkStackFrame) {
            shouldBracketWithForkStackFrame = ConventionalFunctionGenerationStyle.startForkScope(cgh, il, shouldBracketWithForkStackFrame);
        }
        Instruction body = this.skipLetCodegen(cgt, null);
        ((IStreamOptimizationInstruction)((Object)body)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt, tailPosition, valueStyleRequest);
        if (shouldBracketWithForkStackFrame) {
            ConventionalFunctionGenerationStyle.popForkScope(cgh, il);
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        LetInstruction let = this;
        while (true) {
            IBinding b = null;
            IBinding b0 = rh.lookupSubexpression(let.m_value);
            if (b0 != null) {
                b = b0;
            }
            Instruction body = let.m_body;
            LetInstruction letBinding = let;
            if (b == null) {
                b = rh.reduceToIdentifier(state, let.m_value, let.getName(), benv, let);
            }
            rh.registerConvertedBinding(letBinding, b);
            if (!(body instanceof LetInstruction)) {
                body.generateReducedForm(rh, state, benv);
                return;
            }
            let = (LetInstruction)body;
        }
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        Instruction x = this;
        if (cgos instanceof StreamOptimizationStyle || cgos instanceof StreamInADTOptimizationStyle || cgos instanceof ConventionalBasedOptimizationStyle) {
            while (x instanceof LetInstruction) {
                x = x.m_body;
            }
            return x.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        Instruction body = this.m_body;
        while (body instanceof LetInstruction) {
            body = ((LetInstruction)body).m_body;
        }
        if (body instanceof IStreamInADTOptimizationInstruction) {
            return ((IStreamInADTOptimizationInstruction)((Object)body)).canGenerateObjectless(tenv);
        }
        return false;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        Instruction body = this.m_body;
        if (body != null && body.getClass() == LetInstruction.class) {
            pw.printFormOpen("let*", indent);
            pw.print(" (");
            Instruction x = this;
            while (x != null && x.getClass() == LetInstruction.class) {
                LetInstruction leti = x;
                pw.printFormOpenIdentifier(leti, indent + 2);
                if (leti.m_value != null) {
                    leti.m_value.toString(pw, indent + 3);
                } else {
                    pw.printToken("!!null-value!!", indent + 3);
                }
                x = leti.getBody();
                pw.printFormClose(indent + 2);
            }
            pw.printFormClose(indent);
            body = x;
        } else {
            pw.printFormOpen("let", indent);
            pw.printIdentifier(this, indent);
            if (this.m_value != null) {
                this.m_value.toString(pw, indent + 1);
            } else {
                pw.printToken("!!null-value!!", indent + 1);
            }
        }
        if (body != null) {
            body.toString(pw, indent + 1);
        } else {
            pw.printToken("!!null-body!!", indent + 1);
        }
        pw.printFormClose(indent);
    }

    public Instruction optimizeOut() {
        this.m_value = null;
        Instruction body = this.m_body;
        this.m_body = null;
        return body;
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        LetInstruction leti = this;
        while (leti.m_body instanceof LetInstruction) {
            leti = (LetInstruction)leti.m_body;
        }
        return leti.m_body.isStatic(benv);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        LetInstruction outer;
        LetInstruction leti = this;
        LetInstruction inner2 = outer = new LetInstruction("", null, null);
        while (true) {
            Instruction newValue = leti.m_value.assignNewNames(names, ing);
            inner2.setValue(newValue);
            Object s = ing.getNewName();
            names.put(leti.getName(), new IdentifierInstruction(s));
            inner2.setName(s);
            if (!(leti.m_body instanceof LetInstruction)) break;
            leti = (LetInstruction)leti.m_body;
            LetInstruction newInner = new LetInstruction("", null, null);
            inner2.setBody(newInner);
            inner2 = newInner;
        }
        Instruction newBody = leti.m_body.assignNewNames(names, ing);
        inner2.setBody(newBody);
        return outer;
    }

    @Override
    public Instruction cloneReduced() {
        LetInstruction outer;
        LetInstruction leti = this;
        LetInstruction inner2 = outer = new LetInstruction("", null, null);
        while (true) {
            Instruction newValue = leti.m_value.cloneReduced();
            inner2.setValue(newValue);
            inner2.setVariable(leti.getVariable());
            if (!(leti.m_body instanceof LetInstruction)) break;
            leti = (LetInstruction)leti.m_body;
            LetInstruction newInner = new LetInstruction("", null, null);
            inner2.setBody(newInner);
            inner2 = newInner;
        }
        Instruction newBody = leti.m_body.cloneReduced();
        inner2.setBody(newBody);
        LetInstruction.propagateInfo(this, outer);
        return outer;
    }

    @Override
    public LetInstruction getLet() {
        return this;
    }

    @Override
    public void instantiateReducedPolymorphicFunctions(Set newFunctions, TypeEnvironment tenv, BindingEnvironment benv, Set stack, Set done) {
        LetInstruction base2 = this;
        while (true) {
            base2.getValue().instantiateReducedPolymorphicFunctions(newFunctions, tenv, benv, stack, done);
            if (!(base2.getBody() instanceof LetInstruction)) break;
            base2 = (LetInstruction)base2.getBody();
        }
        base2.getBody().instantiateReducedPolymorphicFunctions(newFunctions, tenv, benv, stack, done);
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 1;
    }
}

