/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NullableType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public final class LiteralInstruction
extends Instruction
implements IMatchDestructable {
    protected Object m_value;
    protected Type m_type;

    public LiteralInstruction() {
    }

    @Override
    public int hashCode() {
        return this.m_value == null ? 0 : this.m_value.hashCode();
    }

    public LiteralInstruction(Type type2, Object value2) {
        this.setCachedType(type2);
        this.m_value = value2;
        this.m_type = type2;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_type;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.m_bindingEnvironment = null;
        this.m_hasBeenTypechecked = true;
        return this.setCachedType(this.m_type);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        LiteralInstruction li = (LiteralInstruction)arg0;
        if (!li.m_type.equals(this.m_type)) {
            return false;
        }
        if (this.m_value == null) {
            return li.m_value == null;
        }
        return this.m_value.equals(li.m_value);
    }

    @Override
    public Type getTypeParameter(int i) {
        if (i == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_type = n2;
        }
    }

    public static final LiteralInstruction numberLiteral(String x) {
        if (x.endsWith("f")) {
            return LiteralInstruction.floatLiteral(Float.parseFloat(x.substring(0, x.length() - 1)));
        }
        if (x.endsWith("d")) {
            return LiteralInstruction.doubleLiteral(Double.parseDouble(x.substring(0, x.length() - 1)));
        }
        if (x.endsWith("l")) {
            return LiteralInstruction.longLiteral(Long.parseLong(x.substring(0, x.length() - 1)));
        }
        if (x.startsWith("f")) {
            if (x.equals("floatNaN")) {
                return LiteralInstruction.floatLiteral(Float.NaN);
            }
            if (x.equals("floatPosINF")) {
                return LiteralInstruction.floatLiteral(Float.POSITIVE_INFINITY);
            }
            if (x.equals("floatNegINF")) {
                return LiteralInstruction.floatLiteral(Float.NEGATIVE_INFINITY);
            }
            return null;
        }
        if (x.startsWith("d")) {
            if (x.equals("doubleNaN")) {
                return LiteralInstruction.doubleLiteral(Double.NaN);
            }
            if (x.equals("doublePosINF")) {
                return LiteralInstruction.doubleLiteral(Double.POSITIVE_INFINITY);
            }
            if (x.equals("doubleNegINF")) {
                return LiteralInstruction.doubleLiteral(Double.NEGATIVE_INFINITY);
            }
            return null;
        }
        if (x.indexOf(46) == -1) {
            return LiteralInstruction.integerLiteral(Integer.parseInt(x));
        }
        return LiteralInstruction.doubleLiteral(Double.parseDouble(x));
    }

    public static final LiteralInstruction integerLiteral(int i) {
        return new LiteralInstruction(IntType.s_intType, new Integer(i));
    }

    public static final LiteralInstruction longLiteral(long i) {
        return new LiteralInstruction(LongType.s_longType, new Long(i));
    }

    public static final LiteralInstruction shortLiteral(long i) {
        return new LiteralInstruction(ShortType.s_shortType, new Long(i));
    }

    public static final LiteralInstruction doubleLiteral(double d) {
        return new LiteralInstruction(DoubleType.s_doubleType, new Double(d));
    }

    public static final LiteralInstruction floatLiteral(float f2) {
        return new LiteralInstruction(FloatType.s_floatType, new Float(f2));
    }

    public static final LiteralInstruction charLiteral(char ch) {
        return new LiteralInstruction(CharType.s_charType, new Character(ch));
    }

    public static final LiteralInstruction booleanTrueLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.TRUE);
    }

    public static final LiteralInstruction unitLiteral() {
        return new LiteralInstruction(UnitType.s_unitType, new Integer(0));
    }

    public static final LiteralInstruction booleanLiteral(boolean b) {
        return b ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral();
    }

    public static final LiteralInstruction booleanFalseLiteral() {
        return new LiteralInstruction(BooleanType.s_booleanType, Boolean.FALSE);
    }

    public static final LiteralInstruction decimalLiteral(BigDecimal dec) {
        return new LiteralInstruction(DecimalType.s_decimalType, dec);
    }

    public static final LiteralInstruction bigIntegerLiteral(BigInteger val) {
        return new LiteralInstruction(BigIntegerType.s_bigIntegerType, val);
    }

    public static final LiteralInstruction nullLiteral(Type t) {
        if (t == null || !t.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + t);
        }
        return new LiteralInstruction(t, null);
    }

    public static final LiteralInstruction nullableLiteral(Type t) {
        if (t == null || !t.isFullySpecified()) {
            throw new Error("Dead literal must be fully typed, but got " + t);
        }
        return new LiteralInstruction(new NullableType(t), null);
    }

    public void generateBeginSwitchCase(FcgInstructionList il) {
        Object value2 = this.getValue();
        if (value2 instanceof Number) {
            il.beginSwitchCaseBlock(((Number)value2).intValue());
        } else if (value2 instanceof Character) {
            il.beginSwitchCaseBlock(((Character)value2).charValue());
        } else {
            throw new XylemError("ERR_SYSTEM", "Invalid switch type");
        }
    }

    public static final Integer getInteger(Instruction instr) {
        if (!(instr instanceof LiteralInstruction)) {
            return null;
        }
        Object value2 = ((LiteralInstruction)instr).getValue();
        if (!(value2 instanceof Integer)) {
            return null;
        }
        return (Integer)value2;
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        return true;
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        block8: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    if (ch >= '\u0080') {
                        sb.append("\\u");
                        String hex2 = Integer.toHexString(ch);
                        sb.append("000".substring(hex2.length() - 1));
                        sb.append(hex2);
                        continue block8;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        LiteralInstruction i = new LiteralInstruction(this.m_type, this.m_value);
        LiteralInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        return this.cloneWithoutTypeInformation();
    }

    public boolean isReducedExpression() {
        return true;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        state[0] = this;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        String val = this.m_value == null ? (this.m_type instanceof INumericalType ? "((" + this.m_type + ") 0)" : (this.m_type instanceof BooleanType ? "false" : "(java-null " + this.m_type.prettyPrint() + ")")) : (this.m_value.equals(new Double(Double.NaN)) ? "doubleNaN" : (this.m_value.equals(new Float(Float.NaN)) ? "floatNaN" : (this.m_value.equals(new Float(Float.NEGATIVE_INFINITY)) ? "floatNegINF" : (this.m_value.equals(new Float(Float.POSITIVE_INFINITY)) ? "floatPosINF" : (this.m_value.equals(new Double(Double.NEGATIVE_INFINITY)) ? "doubleNegINF" : (this.m_value.equals(new Double(Double.POSITIVE_INFINITY)) ? "doublePosINF" : (this.m_type instanceof UnitType ? "unit" : (this.m_value instanceof Character ? "'" + LiteralInstruction.escape(this.m_value.toString()) + "'" : (this.m_type.equals(DecimalType.s_decimalType) ? "new java.math.BigDecimal(\"" + this.m_value.toString() + "\")" : (this.m_type.equals(LongType.s_longType) ? this.m_value.toString() + "l" : this.m_value.toString()))))))))));
        pw.printToken(val, indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di && di.getVerbosityLevel() == 0) {
            di.quietEnter(this, e, f2);
        }
        Object ans = this.m_value;
        if (null != di && di.getVerbosityLevel() == 0) {
            return Debugger.quietLeave(di, this, e, f2, ans);
        }
        return ans;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_type = rofh.readType();
        this.m_value = rofh.readObject();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_type);
        wofh.writeObject(this.m_value);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment tenv, BindingEnvironment benv) throws TypeCheckException {
        return this.m_type;
    }

    @Override
    public Instruction desugarDestruction(Instruction toMatch, ReductionHelper rh, IMatchDestructable.Generator trueCode, IMatchDestructable.Generator falseCode, BindingEnvironment benv) {
        Object x = rh.generateReducedIdentifier("");
        LetInstruction leti = new LetInstruction(x, new PrimitiveEqualityInstruction(toMatch, this), new ChooseInstruction(new IdentifierInstruction(x), trueCode.generate(), falseCode.generate()));
        return leti;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType typeLoaded = this.loadConstant(cgh, il, this.m_value);
        return typeLoaded;
    }

    public FcgType loadConstant(FcgCodeGenHelper cgh, FcgInstructionList il, Object x) {
        FcgType typeLoaded;
        if (x == null) {
            typeLoaded = this.m_type.getFCGType(cgh);
            il.loadNull();
            il.convertExpr(FcgType.OBJECT, typeLoaded);
        } else if (x instanceof BigDecimal) {
            String val = ((BigDecimal)x).toString();
            il.loadLiteral(val);
            typeLoaded = cgh.getClassReferenceType(BigDecimal.class.getName());
            il.createObjectExpr(typeLoaded, 1);
        } else if (x instanceof Integer) {
            Integer i = (Integer)x;
            typeLoaded = il.loadLiteral(i);
        } else if (x instanceof Long) {
            Long l = (Long)x;
            typeLoaded = il.loadLiteral(l);
        } else if (x instanceof Double) {
            Double d = (Double)x;
            typeLoaded = il.loadLiteral(d);
        } else if (x instanceof Float) {
            Float f2 = (Float)x;
            typeLoaded = il.loadLiteral(f2.floatValue());
        } else if (x instanceof String) {
            typeLoaded = il.loadLiteral((String)x);
        } else if (x instanceof Character) {
            typeLoaded = il.loadLiteral(((Character)x).charValue());
        } else if (x instanceof Boolean) {
            typeLoaded = il.loadLiteral((Boolean)x);
        } else if (x instanceof BigInteger) {
            typeLoaded = il.loadLiteral((BigInteger)x);
        } else {
            throw new UnsupportedOperationException();
        }
        return typeLoaded;
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }

    public static class KnownValue {
        Object m_literalValue = null;
        Object[] m_literalArray = null;

        public KnownValue(Object literalValue) {
            this.m_literalValue = literalValue;
        }

        public KnownValue(LiteralInstruction literal) {
            this.m_literalValue = literal.getValue();
        }

        public KnownValue(Object[] literalValues) {
            this.m_literalArray = literalValues;
        }

        public KnownValue(LiteralInstruction[] literals) {
            this.m_literalArray = new Object[literals.length];
            for (int i = 0; i < literals.length; ++i) {
                this.m_literalArray[i] = literals[i].getValue();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KnownValue)) {
                return false;
            }
            KnownValue other2 = (KnownValue)obj;
            if (null == this.m_literalValue) {
                if (null != other2.m_literalValue) {
                    return false;
                }
                if (this.m_literalArray.length != other2.m_literalArray.length) {
                    return false;
                }
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    if (this.m_literalArray[i].equals(other2.m_literalArray[i])) continue;
                    return false;
                }
                return true;
            }
            if (null == other2.m_literalValue) {
                return false;
            }
            return this.m_literalValue.equals(other2.m_literalValue);
        }

        public String getStringValue() {
            if (this.m_literalArray != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.m_literalArray.length; ++i) {
                    Object x = this.m_literalArray[i];
                    if (!(x instanceof Character)) {
                        return null;
                    }
                    sb.append(((Character)x).charValue());
                }
                return sb.toString();
            }
            return null;
        }
    }
}

