/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class LocalizeMessageInstruction
extends NaryPrimopInstruction {
    Instruction m_messageFile;
    Instruction m_messageID;

    public LocalizeMessageInstruction() {
    }

    public LocalizeMessageInstruction(Instruction messageFile, Instruction messageID, Instruction[] parameters) {
        super(parameters);
        this.m_messageFile = messageFile;
        this.m_messageID = messageID;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        super.generateReducedForm(rh, state, benv);
        this.m_messageFile = rh.reduceToBasicInstruction(state, this.m_messageFile, benv);
        this.m_messageID = rh.reduceToBasicInstruction(state, this.m_messageID, benv);
        state[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_messageFile.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        tenv.unify(this.m_messageID.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            tenv.unify(this.m_parameters[i].typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        }
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_messageFile;
            }
            case 1: {
                return this.m_messageID;
            }
        }
        return this.m_parameters[i - 2];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 2;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_messageFile = n2;
                break;
            }
            case 1: {
                this.m_messageID = n2;
                break;
            }
            default: {
                this.m_parameters[i - 2] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        LocalizeMessageInstruction i = new LocalizeMessageInstruction(this.m_messageFile.cloneWithoutTypeInformation(), this.m_messageID.cloneWithoutTypeInformation(), parameters);
        LocalizeMessageInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        LocalizeMessageInstruction i = new LocalizeMessageInstruction(this.m_messageFile, this.m_messageID, parameters);
        LocalizeMessageInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "localize-message";
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgClassReferenceType bundleType = cg.getClassReferenceType("java.util.ResourceBundle");
        FcgClassReferenceType formatType = cg.getClassReferenceType("java.text.MessageFormat");
        CharStreamToJavaStringInstruction.generateJavaString(cg, cgt, this.m_messageFile, null, il);
        il.invokeClassMethod(bundleType, "getBundle", (FcgType)bundleType, 1);
        CharStreamToJavaStringInstruction.generateJavaString(cg, cgt, this.m_messageID, null, il);
        il.invokeInstanceMethod(bundleType, "getString", (FcgType)FcgType.STRING, 1);
        if (this.m_parameters.length != 0) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                CharStreamToJavaStringInstruction.generateJavaString(cg, cgt, this.m_parameters[i], varNameSuggestion, il);
            }
            il.loadLiteral(this.m_parameters.length);
            il.createArrayExpr(FcgType.OBJECT, true);
            il.invokeClassMethod(formatType, "format", (FcgType)FcgType.STRING, 2);
        }
        il.convertExpr(FcgType.STRING, FcgType.CHAR_ARRAY);
        return FcgType.CHAR_ARRAY;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        IStream msgFile0 = (IStream)this.m_messageFile.evaluate(e, f2, di, false);
        IStream msgID0 = (IStream)this.m_messageID.evaluate(e, f2, di, false);
        String msgFile = new String(msgFile0.toCharArray());
        String msgID = new String(msgID0.toCharArray());
        String[] params = new String[this.m_parameters.length];
        for (int i = 0; i < params.length; ++i) {
            String s;
            IStream s0 = (IStream)this.m_parameters[i].evaluate(e, f2, di, false);
            params[i] = s = new String(s0.toCharArray());
        }
        ResourceBundle rb = ResourceBundle.getBundle(msgFile);
        StringStream ans = params.length == 0 ? new StringStream(rb.getString(msgID)) : new StringStream(MessageFormat.format(rb.getString(msgID), params));
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_messageFile = rofh.readInstruction(benv);
        this.m_messageID = rofh.readInstruction(benv);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInstruction(this.m_messageFile);
        wofh.writeInstruction(this.m_messageID);
    }
}

