/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoopInstruction
extends Instruction
implements ISpecialForm,
IBinding {
    private static final Logger s_logger = LoggerUtil.getLogger(LoopInstruction.class);
    private static final String s_className = LoopInstruction.class.getName();
    protected Binding[] m_parameters;
    protected Instruction[] m_initialValues;
    protected Instruction m_body;
    protected Object m_name;
    protected LambdaType m_bindingType;
    protected boolean m_isPure = true;
    private int m_stackFramePos;
    private int m_useCount;
    private ForkInformation _forkInformation;
    protected IBinding[] closureExternalBindings;
    protected IBinding[] closureInternalBindings;
    protected int stackFrameSize;

    public LoopInstruction() {
        assert (this.initBogusStackframePos());
    }

    public LoopInstruction(Object name2, Instruction op1, Binding[] parameters, Instruction[] initialValues, boolean isPure) {
        this.init(name2, op1, parameters, initialValues, new TypeVariable(), isPure);
    }

    public LoopInstruction(Object name2, Instruction op1, Binding[] parameters, Instruction[] initialValues, Type returnType, boolean isPure) {
        this.init(name2, op1, parameters, initialValues, returnType, isPure);
    }

    private void init(Object name2, Instruction op1, Binding[] parameters, Instruction[] initialValues, Type returnType, boolean isPure) {
        this.m_name = name2;
        this.m_body = op1;
        this.m_initialValues = initialValues;
        this.m_parameters = parameters;
        this.m_isPure = isPure;
        if (parameters != null) {
            this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(parameters), returnType, isPure);
        }
        assert (this.initBogusStackframePos());
    }

    protected boolean initBogusStackframePos() {
        this.m_stackFramePos = -3333333;
        return true;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    public LambdaType getLambdaType(TypeEnvironment tenv, BindingEnvironment benv) {
        Type[] paramTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = this.m_initialValues[i].getType(tenv, benv);
        }
        return new LambdaType(paramTypes, this.m_body.getType(tenv, benv), this.m_isPure);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        return this.evaluate(null, e, f2, di, tailPosition);
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        this.evaluate(as, e, f2, di, false);
    }

    private Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Closure c = new Closure(this.closureInternalBindings, null, f2, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber, this.stackFrameSize);
        e.bindInCurrentFrame(this, c);
        int nFreeBindings = this.closureExternalBindings.length;
        Object[] closureValues = new Object[nFreeBindings];
        boolean mustRelease = false;
        for (int i = 0; i < nFreeBindings; ++i) {
            IBinding b = this.closureExternalBindings[i];
            Object val = e.lookupBoundValue(b);
            Type t = b.getBindingType();
            if (t == null) {
                t = this.closureInternalBindings[i].getBindingType();
            }
            closureValues[i] = val = t.evaluateVariableFork(val);
        }
        c.setClosureValues(closureValues);
        Object ans = null;
        if (as != null) {
            c.evaluate(as, e, f2, this.m_initialValues, di);
        } else {
            ans = c.evaluate(e, f2, this.m_initialValues, di);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    protected boolean markApplies(final Object marker) {
        final boolean[] foundProblem = new boolean[]{false};
        new Optimizer(){
            Set m_isTailPosition = new HashSet();
            Set m_skip = new HashSet();

            @Override
            protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
                if (this.m_skip.contains(n2)) {
                    return null;
                }
                if (this.m_isTailPosition.contains(parent2) && parent2 instanceof ISpecialForm && ((ISpecialForm)((Object)parent2)).isChildInstructionInTailPosition(parentIndex)) {
                    this.m_isTailPosition.add(n2);
                }
                if (n2 instanceof ApplyInstruction) {
                    Instruction called = ((ApplyInstruction)n2).m_lambda;
                    if (!(called instanceof IdentifierInstruction)) {
                        foundProblem[0] = true;
                        return n2;
                    }
                    if (!((IdentifierInstruction)called).getVariable().equals(LoopInstruction.this.m_name)) {
                        return n2;
                    }
                    if (this.m_isTailPosition.contains(n2)) {
                        ((ApplyInstruction)n2).setTailLoopApply(marker, LoopInstruction.this.m_parameters);
                        this.m_skip.add(((ApplyInstruction)n2).m_lambda);
                        return n2;
                    }
                    ((ApplyInstruction)n2).setTailLoopApply(null, null);
                    foundProblem[0] = true;
                    return null;
                }
                if (n2 instanceof IdentifierInstruction && ((IdentifierInstruction)n2).getVariable().equals(LoopInstruction.this.m_name)) {
                    foundProblem[0] = true;
                }
                return n2;
            }

            @Override
            public Instruction optimize(Instruction n2) {
                this.m_isTailPosition.add(n2);
                return super.optimize(n2);
            }
        }.optimize(this.m_body);
        return foundProblem[0];
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        cgt.generateFreeBindings(this, cgh, il, null, tailPosition, false, ValueGenStyle.DEFAULT);
        boolean foundProblem = this.markApplies(this.m_name);
        if (foundProblem) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Found problem during code generation for LoopInstruction (" + this + ")"});
            FFDCUtil.log(new XylemError(message), this);
            s_logger.logp(Level.WARNING, s_className, "generateCode", message);
        }
        Type myType = this.getType(tenv, cgt.m_bindingEnvironment);
        FcgType retType = myType.getFCGType(cgh);
        if (!foundProblem) {
            il.comment("generating LoopInstruction as just loop\n");
            cgt.registerExtantBinding(this, "__should_never_be_used__");
            String[] paramNames = new String[this.m_parameters.length];
            FcgType[] paramTypes = new FcgType[this.m_parameters.length];
            FcgVariable[] params = new FcgVariable[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                paramNames[i] = cgh.generateNewLocalVariableName();
                paramTypes[i] = this.m_initialValues[i].generateCode(cgh, cgt, varNameSuggestion, tailPosition, il, valueStyleRequest);
                params[i] = il.defineVar(paramTypes[i], paramNames[i], true);
                cgt.registerExtantBinding(this.m_parameters[i], paramNames[i]);
            }
            String retVarName = "__tailrecurse_loop_" + this.m_name + "_result__";
            FcgVariable retVar = il.defineVar(retType, retVarName, false);
            il.beginConditionalLoop("__tailrecurse_loop_" + this.m_name + "__", 0);
            this.m_body.generateCode(cgh, cgt, null, false, il, valueStyleRequest);
            il.storeVar(retVar);
            il.breakFromLoop();
            il.comment("don't actually loop, unless explicitly 'continue'");
            il.endConditionalLoop();
            il.comment("end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__");
            il.loadVar(retVar);
            return retType;
        }
        String lambdaName = cgh.generateNewLocalVariableName(varNameSuggestion);
        LambdaType lambdaType = this.getLambdaType(tenv, cgt.m_bindingEnvironment);
        FcgType lambdaFcgType = lambdaType.getFCGType(cgh);
        Type lambdaRetType = lambdaType.getReturnType().resolveType(tenv);
        String className = lambdaType.getImplementationName(cgh);
        StringBuffer sb = new StringBuffer();
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        il.comment("generating LoopInstruction normally as lambda");
        il.createObjectExpr(lambdaFcgType, 0);
        FcgVariable lambdaVar = il.defineVar(lambdaFcgType, lambdaName, true);
        cgt.registerExtantBinding(this, lambdaName);
        il.beginConditionalLoop("__tailrecurse_loop_" + this.m_name + "__", 0);
        this.m_body.generateCode(cgh, cgt, null, false, il, valueStyleRequest);
        il.returnInstruction(retType);
        il.endConditionalLoop();
        il.comment("end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            cgt.generateConventionally(this.m_initialValues[i], cgh, false, il, ValueGenStyle.DEFAULT);
        }
        FcgClassReferenceType lambdaClass = cgh.getClassReferenceType(lambdaName);
        return il.invokeClassMethod(lambdaClass, "invoke", retType, this.m_parameters.length);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Binding[] newParameters = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object s = ing.getNewName();
            names.put(this.m_parameters[i].getName(), new IdentifierInstruction(s));
            newParameters[i] = new Binding(s, this.m_parameters[i].getBindingType(), this);
        }
        Instruction[] clonedValues = new Instruction[this.m_parameters.length];
        for (int i = 0; i < clonedValues.length; ++i) {
            clonedValues[i] = this.m_initialValues[i].assignNewNames(names, ing);
        }
        Object newName = ing.getNewName();
        names.put(this.m_name, new IdentifierInstruction(newName));
        return new LoopInstruction(newName, this.m_body.assignNewNames(names, ing), newParameters, clonedValues, this.m_bindingType.getReturnType(), this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] clonedValues = new Instruction[this.m_parameters.length];
        for (int i = 0; i < clonedValues.length; ++i) {
            clonedValues[i] = this.m_initialValues[i].cloneWithoutTypeInformation();
        }
        LoopInstruction cnlfi = new LoopInstruction(this.m_name, this.m_body.cloneWithoutTypeInformation(), null, clonedValues, this.m_bindingType.getReturnType(), this.m_isPure);
        Binding[] clonedParams = new Binding[this.m_parameters.length];
        for (int i = 0; i < clonedParams.length; ++i) {
            clonedParams[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), cnlfi);
        }
        cnlfi.setParameters(clonedParams, this.m_bindingType.getReturnType(), this.m_isPure);
        LoopInstruction.propagateInfo(this, cnlfi);
        return cnlfi;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] clonedParams = new Binding[this.m_parameters.length];
        for (int i = 0; i < clonedParams.length; ++i) {
            clonedParams[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LoopInstruction i = new LoopInstruction(this.m_name, this.m_body, clonedParams, (Instruction[])this.m_initialValues.clone(), this.m_bindingType.getReturnType(), this.m_isPure);
        LoopInstruction.propagateInfo(this, i);
        return i;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction x) {
        this.m_body = x;
    }

    private void setParameters(Binding[] params, Type returnType, boolean isPure) {
        this.m_parameters = params;
        this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(params), returnType, isPure);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("loop", indent);
        pw.printIdentifier(this.m_name, indent);
        pw.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Binding b = this.m_parameters[i];
            Instruction value2 = this.m_initialValues[i];
            pw.printFormOpenIdentifier(b.getName(), indent + 2);
            value2.toString(pw, indent + 3);
            pw.printFormClose(indent + 2);
        }
        pw.printFormClose(indent);
        this.m_body.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] paramTypes = new Type[this.m_parameters.length];
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            tenv.unify(this.m_bindingType.getElementTypes()[i], this.m_initialValues[i].typeCheck(tenv, benv, functionStack), this);
            benv2.setVariableBinding(this.m_parameters[i]);
        }
        benv2.setVariableBinding(this);
        Type bodyType = this.m_body.typeCheck(tenv, benv2, functionStack);
        tenv.unify(this.m_bindingType.getReturnType(), bodyType, this);
        if (this.closureExternalBindings != null) {
            Type[] freeBindingTypes = new Type[this.closureExternalBindings.length];
            for (int i = 0; i < this.closureExternalBindings.length; ++i) {
                Type t = this.closureExternalBindings[i].getBindingType(tenv, benv2);
                assert (t != null);
                assert (this.closureExternalBindings[i].getBindingType() != null);
            }
        }
        return this.setCachedType(bodyType);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        int i;
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        rh2.upgradeBinding(this);
        benv.setVariableBinding(this);
        this.m_bindingEnvironment = null;
        for (i = 0; i < this.m_parameters.length; ++i) {
            rh2.upgradeBinding(this.m_parameters[i]);
            benv.setVariableBinding(this.m_parameters[i]);
        }
        for (i = 0; i < this.m_initialValues.length; ++i) {
            this.m_initialValues[i] = rh.reduceToBasicInstruction(state, this.m_initialValues[i], benv);
        }
        this.m_body = rh2.reduce(this.m_body, benv);
        state[0] = this;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialValues.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        return i == 0 ? this.m_body : this.m_initialValues[i - 1];
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (i == 0) {
            this.m_body = n2;
        } else {
            this.m_initialValues[i - 1] = n2;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        set2.remove(this);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        set2.remove(this);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_name = rofh.readBindingName();
        this.m_body = rofh.readInstruction(benv);
        this.m_parameters = rofh.readTypeSpecificBindingSet(this);
        this.m_bindingType = (LambdaType)rofh.readType();
        this.m_isPure = rofh.readBoolean();
        int c = this.m_parameters.length;
        this.m_initialValues = new Instruction[c];
        for (int i = 0; i < c; ++i) {
            this.m_initialValues[i] = rofh.readInstruction(benv);
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeBindingName(this.m_name);
        wofh.writeInstruction(this.m_body);
        wofh.writeTypeSpecificBindingSet(this.m_parameters);
        wofh.writeType(this.m_bindingType);
        wofh.writeBoolean(this.m_isPure);
        int c = this.m_initialValues.length;
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.m_initialValues[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        Type[] paramTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = this.m_parameters[i].getBindingType();
            benv.setVariableBinding(this.m_parameters[i]);
        }
        benv.setVariableBinding(this);
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public Type getTypeParameter(int i) {
        if (0 == i) {
            return this.m_bindingType.getReturnType();
        }
        return this.m_parameters[--i].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (0 == i) {
            this.m_bindingType.setReturnType(n2);
            return;
        }
        this.m_parameters[--i].setType(n2);
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (this.m_parameters == null) {
            return null;
        }
        IBinding[] bindings = new IBinding[this.m_parameters.length + 1];
        System.arraycopy(this.m_parameters, 0, bindings, 1, this.m_parameters.length);
        bindings[0] = this;
        return bindings;
    }

    public List getBindings() {
        ArrayList<IBinding> list = new ArrayList<IBinding>();
        list.addAll(Arrays.asList(this.m_parameters));
        list.add(this);
        return list;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        LoopInstruction li = (LoopInstruction)arg0;
        int c = this.m_parameters.length;
        if (li.m_parameters.length != c) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (li.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public Type getBindingType() {
        return this.m_bindingType;
    }

    @Override
    public Type getBindingType(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_bindingType;
    }

    @Override
    public int compareTo(Object arg0) {
        return Binding.compare(this, arg0);
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public Object getName() {
        return this.m_name;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this;
    }

    @Override
    public void setName(Object name2) {
        this.m_name = name2;
    }

    @Override
    public int getVariableUse() {
        return this.m_useCount;
    }

    @Override
    public void incrementVariableUse() {
        if (this.m_useCount == 0) {
            this.m_useCount = 1;
        } else if (this.m_useCount == 1 || this.m_useCount == 2) {
            this.m_useCount = 3;
        }
    }

    @Override
    public void passingIterator() {
        if (this.m_useCount == 0) {
            this.m_useCount = 2;
        }
    }

    @Override
    public void clearVariableUse() {
        this.m_useCount = 0;
    }

    @Override
    public int getStackFramePos() {
        return this.m_stackFramePos;
    }

    @Override
    public void setStackFramePos(int pos) {
        this.m_stackFramePos = pos;
    }

    @Override
    public ForkInformation getForkInformation() {
        return this._forkInformation;
    }

    @Override
    public void setForkInformation(ForkInformation forkInformation) {
        this._forkInformation = forkInformation;
    }

    public IBinding[] getFreeBindings() {
        return this.closureExternalBindings;
    }

    public void setFreeBindings(Set<IBinding> freeBindings, Function f2) {
        this.closureExternalBindings = new IBinding[freeBindings.size()];
        this.closureInternalBindings = new IBinding[freeBindings.size()];
        int i = 0;
        Iterator<IBinding> i$ = freeBindings.iterator();
        while (i$.hasNext()) {
            IBinding b;
            this.closureExternalBindings[i] = b = i$.next();
            Type btype = b.getBindingType();
            if (btype == null) {
                btype = this.extractType(b, f2);
            }
            assert (btype != null);
            Binding internalBinding = new Binding(b.getName(), btype);
            internalBinding.setStackFramePos(i + this.m_parameters.length);
            this.closureInternalBindings[i] = internalBinding;
            ++i;
        }
    }

    private Type extractType(IBinding b, Function f2) {
        BindingEnvironment be = this.getBindingEnvironment();
        if (be == null) {
            be = f2.getBindingEnvironment();
        }
        assert (be != null);
        TypeEnvironment te = f2.getTypeEnvironment();
        assert (te != null);
        Type type2 = b.getBindingType(te, be);
        return type2;
    }

    public IBinding[] getClosureInternalBindings() {
        return this.closureInternalBindings;
    }

    public int getStackFrameSize() {
        return this.stackFrameSize;
    }

    public void setStackFrameSize(int stackFrameSize) {
        this.stackFrameSize = stackFrameSize;
    }
}

