/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.DelayInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Match2Instruction
extends Instruction
implements ISpecialForm {
    protected Instruction m_toMatch;
    protected Match[] m_matches;
    protected Instruction m_default;

    public Match2Instruction(Instruction toMatch, Match[] matches2, Instruction defHandler) {
        this.m_toMatch = toMatch;
        this.m_matches = matches2;
        this.m_default = defHandler;
    }

    public Match2Instruction(Instruction toMatch, List matchesList, Instruction defHandler) {
        this(toMatch, matchesList.toArray(new Match[matchesList.size()]), defHandler);
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Instruction getDefault() {
        return this.m_default;
    }

    public Match[] getMatches() {
        return this.m_matches;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_matches.length + (this.m_default == null ? 1 : 2);
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_default != null) {
            if (i == 0) {
                return this.m_default;
            }
            --i;
        }
        if (i == 0) {
            return this.m_toMatch;
        }
        return this.m_matches[i - 1].getHandler();
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_default != null) {
            if (i == 0) {
                this.m_default = n2;
                return;
            }
            --i;
        }
        if (i == 0) {
            this.m_toMatch = n2;
        }
        this.m_matches[i - 1].m_handler = n2;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        Type toMatch = this.m_toMatch.typeCheck(tenv, benv, functionStack);
        Type out = null;
        if (this.m_default != null) {
            out = this.m_default.typeCheck(tenv, benv, functionStack);
        }
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            IMatchDestructable md = (IMatchDestructable)((Object)m.m_pattern);
            BindingEnvironment benv2 = new BindingEnvironment(benv);
            tenv.unify(toMatch, md.typeCheckDestruction(tenv, benv2), m.m_pattern);
            Type t = m.m_handler.typeCheck(tenv, benv2, functionStack);
            if (out == null) {
                out = t;
                continue;
            }
            tenv.unify(out, t, m.m_pattern);
        }
        return this.setCachedType(out);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        throw new UnsupportedOperationException("match2 not supported past reduction");
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException("match2 not supported past reduction");
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            Match m = this.m_matches[i];
            matches2[i] = new Match(m.m_pattern.cloneWithoutTypeInformation(), m.m_handler.cloneWithoutTypeInformation());
        }
        Match2Instruction i = new Match2Instruction(this.m_toMatch.cloneWithoutTypeInformation(), matches2, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation());
        Match2Instruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Match[] matches2 = (Match[])this.m_matches.clone();
        Match2Instruction i = new Match2Instruction(this.m_toMatch, matches2, this.m_default);
        Match2Instruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh0, Instruction[] state, final BindingEnvironment benv) {
        IMatchDestructable.Generator falseCode;
        Instruction toMatch = rh0.reduceToBasicInstruction(state, this.m_toMatch, benv);
        if (this.m_default != null) {
            ReductionHelper rh = (ReductionHelper)rh0.clone();
            final Object x = rh.generateReducedIdentifier("");
            LetInstruction li = new LetInstruction(x, new DelayInstruction(rh.reduce(this.m_default, benv)), null);
            if (state[2] != null) {
                ((LetInstruction)state[2]).setBody(li);
            } else {
                state[1] = li;
            }
            state[2] = li;
            falseCode = new IMatchDestructable.Generator(){

                @Override
                public Instruction generate() {
                    return new ForceInstruction(new IdentifierInstruction(x));
                }
            };
        } else {
            falseCode = new IMatchDestructable.FixedGenerator(null);
        }
        for (int i = this.m_matches.length - 1; i >= 0; --i) {
            final Match m = this.m_matches[i];
            final ReductionHelper rh = (ReductionHelper)rh0.clone();
            falseCode = new IMatchDestructable.FixedGenerator(((IMatchDestructable)((Object)m.m_pattern)).desugarDestruction(toMatch, rh, new IMatchDestructable.Generator(){

                @Override
                public Instruction generate() {
                    return rh.reduce(m.m_handler, benv);
                }
            }, falseCode, benv));
        }
        state[0] = ((IMatchDestructable.Generator)falseCode).generate();
        this.m_bindingEnvironment = null;
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        if (this.m_default != null) {
            if (i == 0) {
                return true;
            }
            --i;
        }
        return i != 0;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return this.isChildInstructionBody(i);
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        throw new UnsupportedOperationException("match2 not supported past reduction");
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("match2", indent);
        this.m_toMatch.toString(pw, indent + 1);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match c = this.m_matches[i];
            pw.printFormOpen("case", indent + 1);
            c.m_pattern.toString(pw, indent + 2);
            c.m_handler.toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        if (this.m_default != null) {
            pw.printFormOpen("otherwise", indent + 1);
            this.m_default.toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        return super.assignNewNames(names, ing);
    }

    public static class Match {
        Instruction m_pattern;
        Instruction m_handler;
        IBinding[] m_bindings;

        public Match() {
        }

        public Match(Instruction pattern2, Instruction handler) {
            this.m_pattern = pattern2;
            this.m_handler = handler;
        }

        public Instruction getPattern() {
            return this.m_pattern;
        }

        public void setPattern(Instruction p) {
            this.m_pattern = p;
        }

        public Instruction getHandler() {
            return this.m_handler;
        }
    }
}

