/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalBasedOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.GenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatchInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction,
ISpecialForm {
    protected Match[] m_matches;
    protected Instruction m_toMatch;
    protected Instruction m_default;
    private static final Logger s_logger = LoggerUtil.getLogger(MatchInstruction.class);
    private static final String s_className = MatchInstruction.class.getName();
    private static boolean doStaticForkMgmt = false;
    protected boolean m_assumeComplete;

    public MatchInstruction() {
    }

    public MatchInstruction(Instruction toMatch, Match[] matches2, Instruction defaultClause) {
        this(toMatch, matches2, defaultClause, false);
    }

    public MatchInstruction(Instruction toMatch, List matchesList, Instruction defHandler) {
        this(toMatch, matchesList.toArray(new Match[matchesList.size()]), defHandler);
    }

    public MatchInstruction(Instruction toMatch, List matchesList, Instruction defHandler, boolean assumeComplete) {
        this(toMatch, matchesList.toArray(new Match[matchesList.size()]), defHandler, assumeComplete);
    }

    public MatchInstruction(Instruction toMatch, Match[] matches2, Instruction defaultClause, boolean assumeComplete) {
        this.m_toMatch = toMatch;
        this.m_matches = matches2;
        this.m_default = defaultClause;
        this.m_assumeComplete = defaultClause != null || assumeComplete;
    }

    public MatchInstruction(Instruction toMatch, String moduleName, String constructorName, int fields, int fieldToExtract) {
        this.m_toMatch = toMatch;
        String prefix2 = OptimizerUtilities.generateIntermediateIdentifier();
        this.m_matches = new Match[]{new DeconstructionMatch(constructorName, MatchInstruction.makeFields(prefix2, fields), (Instruction)new IdentifierInstruction(prefix2 + fieldToExtract))};
    }

    public MatchInstruction(Instruction toMatch, AbstractDataType.Constructor constructor, int fieldToExtract) {
        this(toMatch, constructor, fieldToExtract, null);
    }

    public MatchInstruction(Instruction toMatch, AbstractDataType.Constructor constructor, int fieldToExtract, Instruction defaultClause) {
        this.m_toMatch = toMatch;
        String prefix2 = OptimizerUtilities.generateIntermediateIdentifier();
        this.m_matches = new Match[]{new DeconstructionMatch(constructor, MatchInstruction.makeFields(prefix2, constructor.m_parameters.length), (Instruction)new IdentifierInstruction(prefix2 + fieldToExtract))};
        this.m_default = defaultClause;
    }

    public MatchInstruction(Instruction toMatch, String moduleName, String constructorName, int fields, int fieldToExtract, Instruction defaultClause) {
        this.m_toMatch = toMatch;
        String prefix2 = OptimizerUtilities.generateIntermediateIdentifier();
        this.m_matches = new Match[]{new DeconstructionMatch(constructorName, MatchInstruction.makeFields(prefix2, fields), (Instruction)new IdentifierInstruction(prefix2 + fieldToExtract))};
        this.m_default = defaultClause;
    }

    public boolean canAssumeComplete() {
        return this.m_assumeComplete;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_default != null ? this.m_default.getType(tenv, benv) : this.m_matches[0].getHandler().getType(tenv, benv);
    }

    static Object[] makeFields(String prefix2, int fields) {
        Object[] x = new Object[fields];
        for (int i = 0; i < fields; ++i) {
            x[i] = prefix2 + i;
        }
        return x;
    }

    @Override
    public int getChildInstructionCount() {
        return (this.m_default == null ? 1 : 2) + this.m_matches.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_default != null) {
            if (i == 0) {
                return this.m_default;
            }
            --i;
        }
        switch (i) {
            case 0: {
                return this.m_toMatch;
            }
        }
        return this.m_matches[i - 1].m_handler;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_default != null) {
            if (i == 0) {
                this.m_default = n2;
                return;
            }
            --i;
        }
        switch (i) {
            case 0: {
                this.m_toMatch = n2;
                break;
            }
            default: {
                this.m_matches[i - 1].m_handler = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneWithoutTypeInformation();
        }
        MatchInstruction i = new MatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), matches2, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation());
        MatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneShallow();
        }
        MatchInstruction i = new MatchInstruction(this.m_toMatch, matches2, this.m_default);
        MatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type inputType = null;
        Type outputType = null;
        TypeVariable tvar = new TypeVariable();
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            Type t = m.doTypeCheck(tenv, benv, functionStack);
            tenv.unify(tvar, t, this);
            Type type2 = outputType = outputType == null ? t : outputType.buildUnion(tenv, t, this);
            if (inputType == null) {
                inputType = m.getPatternType();
                continue;
            }
            tenv.unify(inputType, m.getPatternType(), this);
        }
        if (inputType == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "match needs at least one clause"), this);
        }
        if (this.m_default != null) {
            Type t = this.m_default.typeCheck(tenv, benv, functionStack);
            tenv.unify(tvar, t, this);
            outputType = outputType == null ? t : outputType.buildUnion(tenv, t, this);
        }
        tenv.unify(this.m_toMatch.typeCheck(tenv, benv, functionStack), inputType, this);
        return this.setCachedType(outputType);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        AbstractDataType adt;
        HashMap typeMap = null;
        Type inputType = null;
        if (this.m_matches[0] instanceof DeconstructionMatch && (adt = tenv.getModule().getConstructor(((DeconstructionMatch)this.m_matches[0]).m_constructorName).getAbstractDataType()) instanceof AbstractDataTypeLambda) {
            typeMap = new HashMap();
            inputType = adt.getNamedType().duplicateType(typeMap);
        }
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (null == m) continue;
            m.doTypeCheckReduced(tenv, benv, typeMap);
        }
        super.typeCheckReduced(tenv, benv, functionStack);
        if (inputType != null) {
            try {
                tenv.unify(inputType, this.m_toMatch.getType(tenv, benv), this);
            }
            catch (TypeCheckException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "generateCode", "MatchInstruction=" + this);
        }
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        Type thisType = cgt.resolveType(this);
        String retVar = cgh.generateNewLocalVariableName() + "_matchResult";
        FcgType retVarType = thisType.getFCGType(cgh);
        if (this.m_matches[0] instanceof DeconstructionMatch) {
            AbstractDataType adt = ((DeconstructionMatch)this.m_matches[0]).m_constructor.getAbstractDataType();
            boolean onlyOne = adt.m_constructors.length == 1;
            GenerationState gs = cgt.getGenerationState(((IdentifierInstruction)this.m_toMatch).getBinding(benv));
            boolean toMatchIsObjectless = gs instanceof StreamInADTOptimizedGenerationState ? ((StreamInADTOptimizedGenerationState)gs).isObjectless() : false;
            Binding toMatchMember = gs instanceof StreamInADTOptimizedGenerationState ? ((StreamInADTOptimizedGenerationState)gs).getMember() : null;
            String toMatchVar = cgh.generateNewLocalVariableName();
            Type toMatchType = cgt.resolveType(this.m_toMatch);
            cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            toMatchType.appendHolderVariableDeclaration(cgh, toMatchVar, toMatchIsObjectless, toMatchMember, cgt, il);
            toMatchType.appendHolderVariableAssignment(cgh, toMatchVar, toMatchIsObjectless, toMatchMember, cgt, il);
            if (onlyOne) {
                DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[0];
                CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, toMatchVar, cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, memberInADT, il);
                ((IStreamInADTOptimizationInstruction)((Object)dm.m_handler)).generateCode(cgh, il, streamName, memberInADT, cgt2, objectless, tailPosition);
                boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
            } else {
                thisType.appendHolderVariableDeclaration(cgh, retVar, objectless, memberInADT, cgt, il);
                adt.generateConstructorTypeDeconstructionCode(cgh, toMatchVar, il);
                il.beginSwitch();
                for (int i = 0; i < this.m_matches.length; ++i) {
                    DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                    int caseValue = dm.m_constructor.getIndex();
                    il.beginSwitchCaseBlock(caseValue);
                    il.comment(" match case " + dm.m_constructor.getName());
                    CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, toMatchVar, cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, memberInADT, il);
                    ((IStreamInADTOptimizationInstruction)((Object)dm.m_handler)).generateCode(cgh, il, streamName, memberInADT, cgt2, objectless, tailPosition);
                    boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
                    thisType.appendHolderVariableAssignment(cgh, retVar, objectless, memberInADT, cgt, il);
                    il.endSwitchCaseBlock();
                }
                il.beginSwitchDefaultBlock();
                il.comment(" match adt " + adt.getName());
                if (this.m_default != null) {
                    ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(cgh, il, streamName, memberInADT, cgt.cloneBranch(), objectless, tailPosition);
                    thisType.appendHolderVariableAssignment(cgh, retVar, objectless, memberInADT, cgt, il);
                    il.endSwitchDefaultBlock();
                } else {
                    il.loadLiteral("Use of default: in switch() is unexpected:1.");
                    il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                    il.throwObject();
                    il.endSwitchDefaultBlockFallThru();
                }
                il.endSwitch();
                thisType.appendHolderVariableLoad(cgh, retVar, objectless, memberInADT, cgt, il);
            }
            return retVarType;
        }
        if (this.m_matches[0] instanceof LiteralMatch) {
            thisType.appendHolderVariableDeclaration(cgh, retVar, objectless, memberInADT, cgt, il);
            cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            Type matchType = this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment);
            if (matchType.equals(BooleanType.s_booleanType)) {
                il.convertExpr(FcgType.BOOLEAN, FcgType.INT);
            }
            il.comment(" matching " + matchType.toString());
            il.beginSwitch();
            for (int i = 0; i < this.m_matches.length; ++i) {
                LiteralMatch lm = (LiteralMatch)this.m_matches[i];
                Type lmType = lm.getPatternType();
                if (lmType.equals(IntType.s_intType)) {
                    il.beginSwitchCaseBlock(LiteralInstruction.getInteger(lm.m_literal));
                } else if (lmType.equals(CharType.s_charType)) {
                    il.beginSwitchCaseBlock(((Character)lm.getLiteral().getValue()).charValue());
                } else if (lmType.equals(ShortType.s_shortType)) {
                    il.beginSwitchCaseBlock(((Short)lm.getLiteral().getValue()).shortValue());
                } else if (lmType.equals(BooleanType.s_booleanType)) {
                    il.beginSwitchCaseBlock((Boolean)lm.getLiteral().getValue() != false ? 1 : 0);
                }
                il.comment(" literal match " + lm.m_literal.toString());
                ((IStreamInADTOptimizationInstruction)((Object)lm.m_handler)).generateCode(cgh, il, streamName, memberInADT, cgt.cloneBranch(), objectless, tailPosition);
                thisType.appendHolderVariableAssignment(cgh, retVar, objectless, memberInADT, cgt, il);
                il.endSwitchCaseBlock();
            }
            il.beginSwitchDefaultBlock();
            il.comment(" match any " + this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment).toString());
            if (this.m_default != null) {
                ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(cgh, il, streamName, memberInADT, cgt.cloneBranch(), objectless, tailPosition);
                thisType.appendHolderVariableAssignment(cgh, retVar, objectless, memberInADT, cgt, il);
                il.endSwitchDefaultBlock();
            } else {
                il.loadLiteral("Use of default: in switch() is unexpected:2.");
                il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                il.throwObject();
                il.endSwitchDefaultBlockFallThru();
            }
            il.endSwitch();
            thisType.appendHolderVariableLoad(cgh, retVar, objectless, memberInADT, cgt, il);
            return retVarType;
        }
        throw new XylemError("ERR_SYSTEM", "Can only match literals and ADTs");
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        if (this.m_matches[0] instanceof DeconstructionMatch) {
            boolean onlyOne;
            AbstractDataType adt;
            block15: {
                adt = ((DeconstructionMatch)this.m_matches[0]).m_constructor.getAbstractDataType();
                onlyOne = adt.m_constructors.length == 1;
                Binding b = this.getMemberToExtract(benv);
                if (b != null && b.getBindingType().resolveType(b.getTypeEnvironment()) instanceof StreamType) {
                    try {
                        cgt.generateAddToStreamInADT(this.m_toMatch, streamName, b, cgh, il, tailPosition);
                        return;
                    }
                    catch (ClassCastException cce) {
                        if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) break block15;
                        String errString = "Tried to do ADT optimization but couldn't\n";
                        LetInstruction leti = ((IdentifierInstruction)this.m_toMatch).getBinding(benv).getLet();
                        if (leti != null) {
                            errString = errString + "value " + leti.getValue().toString();
                        }
                        errString = errString + this.toString() + "\n";
                        s_logger.logp(Level.FINE, s_className, "generateCodeWithStreamOptimization", errString);
                    }
                }
            }
            FcgType varType = cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            FcgVariable var = il.defineVar(varType, cgh.generateNewLocalVariableName(), true);
            FcgBasicType retVarType = FcgType.VOID;
            if (onlyOne) {
                DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[0];
                CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, var.getName(), cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, null, il);
                ((IStreamOptimizationInstruction)((Object)dm.m_handler)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt2, tailPosition, valueStyleRequest);
                boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
            } else {
                il.comment("match " + adt.getName());
                adt.generateConstructorTypeDeconstructionCode(cgh, var.getName(), il);
                il.beginSwitch();
                for (int i = 0; i < this.m_matches.length; ++i) {
                    DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                    il.comment("match case " + dm.m_constructor.getName());
                    il.beginSwitchCaseBlock(dm.m_constructor.getIndex());
                    CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, var.getName(), cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, null, il);
                    ((IStreamOptimizationInstruction)((Object)dm.m_handler)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt2, tailPosition, valueStyleRequest);
                    boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
                    il.endSwitchCaseBlock();
                }
                il.comment("match " + adt.getName());
                il.beginSwitchDefaultBlock();
                if (this.m_default != null) {
                    ((IStreamOptimizationInstruction)((Object)this.m_default)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
                    il.endSwitchDefaultBlock();
                } else {
                    String msg = "Use of default: in switch() is unexpected:3.";
                    il.loadLiteral(msg);
                    il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                    il.throwObject();
                    il.endSwitchDefaultBlockFallThru();
                }
                il.endSwitch();
            }
        } else if (this.m_matches[0] instanceof LiteralMatch) {
            cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            il.comment("match " + this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment).toString());
            il.beginSwitch();
            for (int i = 0; i < this.m_matches.length; ++i) {
                LiteralMatch lm = (LiteralMatch)this.m_matches[i];
                il.comment("3 match " + lm.m_literal.toString());
                lm.m_literal.generateBeginSwitchCase(il);
                ((IStreamOptimizationInstruction)((Object)lm.m_handler)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
                il.endSwitchCaseBlock();
            }
            il.comment("match " + this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment).toString());
            il.beginSwitchDefaultBlock();
            if (this.m_default != null) {
                ((IStreamOptimizationInstruction)((Object)this.m_default)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
                il.endSwitchDefaultBlock();
            } else {
                String msg = "Use of default: in switch() is unexpected:4.";
                il.loadLiteral(msg);
                il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                il.throwObject();
                il.endSwitchDefaultBlockFallThru();
            }
            il.endSwitch();
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (!(m instanceof DeconstructionMatch)) continue;
            DeconstructionMatch dm = (DeconstructionMatch)m;
            for (int j = 0; j < dm.m_bindings.length; ++j) {
                set2.remove(dm.m_bindings[j]);
            }
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (!(m instanceof DeconstructionMatch)) continue;
            DeconstructionMatch dm = (DeconstructionMatch)m;
            for (int j = 0; j < dm.m_bindings.length; ++j) {
                set2.remove(dm.m_bindings[j]);
            }
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh0, Instruction[] state, BindingEnvironment benv) {
        this.m_toMatch = rh0.reduceToBasicInstruction(state, this.m_toMatch, benv);
        for (Match m : this.m_matches) {
            ReductionHelper rh = (ReductionHelper)rh0.clone();
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                int c2 = dm.m_bindings.length;
                for (int i2 = 0; i2 < c2; ++i2) {
                    rh.upgradeBinding(dm.m_bindings[i2]);
                    benv.setVariableBinding(dm.m_bindings[i2]);
                }
                dm.m_handler = rh.reduce(dm.m_handler, benv);
                continue;
            }
            LiteralMatch lm = (LiteralMatch)m;
            lm.m_handler = rh.reduce(lm.m_handler, benv);
        }
        ReductionHelper rh = (ReductionHelper)rh0.clone();
        if (this.m_default != null) {
            this.m_default = rh.reduce(this.m_default, benv);
        }
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            Binding b = this.getMemberToExtract(benv);
            if (b != null && b.getBindingType().resolveType(b.getTypeEnvironment()) instanceof StreamType) {
                return true;
            }
            for (int i = 0; i < this.m_matches.length; ++i) {
                if (this.m_matches[i].m_handler.supportsCodeGenerationOptimization(cgos, tenv, benv)) continue;
                return false;
            }
            return this.m_default == null || this.m_default.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        if (cgos instanceof StreamInADTOptimizationStyle || cgos instanceof ConventionalBasedOptimizationStyle) {
            for (int i = 0; i < this.m_matches.length; ++i) {
                if (this.m_matches[i].m_handler.supportsCodeGenerationOptimization(cgos, tenv, benv)) continue;
                return false;
            }
            return this.m_default == null || this.m_default.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    public Binding getMemberToExtract(BindingEnvironment benv) {
        if (this.m_matches.length != 1) {
            return null;
        }
        if (this.m_matches[0] instanceof DeconstructionMatch) {
            DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[0];
            if (dm.m_constructor == null) {
                throw new XylemError("ERR_SYSTEM", "!" + this);
            }
            if (dm.m_constructor.getAbstractDataType().m_constructors.length != 1) {
                return null;
            }
            if (dm.m_handler instanceof IdentifierInstruction) {
                IBinding b = ((IdentifierInstruction)dm.m_handler).getBinding(benv);
                for (int i = 0; i < dm.m_bindings.length; ++i) {
                    if (dm.m_bindings[i] != b) continue;
                    return dm.m_constructor.m_parameters[i];
                }
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof MatchInstruction)) {
            return false;
        }
        MatchInstruction mi = (MatchInstruction)arg0;
        if (this.m_matches.length != mi.m_matches.length) {
            return false;
        }
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match dm2;
            Match dm;
            if (this.m_matches[i] instanceof DeconstructionMatch) {
                dm = (DeconstructionMatch)this.m_matches[i];
                if (mi.m_matches[i] instanceof DeconstructionMatch) {
                    dm2 = (DeconstructionMatch)mi.m_matches[i];
                    if (dm.m_bindings.length != dm2.m_bindings.length) {
                        return false;
                    }
                    if (!dm.m_constructorName.equals(dm2.m_constructorName)) {
                        return false;
                    }
                    if (i != 0 || this.m_matches.length != 1 || !(dm.m_handler instanceof IdentifierInstruction) || !(dm2.m_handler instanceof IdentifierInstruction) || this.m_default != null || mi.m_default != null || !this.m_toMatch.equals(mi.m_toMatch)) continue;
                    IdentifierInstruction x = (IdentifierInstruction)dm.m_handler;
                    IdentifierInstruction y = (IdentifierInstruction)dm2.m_handler;
                    for (int j = 0; j < dm.m_bindings.length; ++j) {
                        if (!dm.m_bindings[j].equals(x.getVariable()) || !dm2.m_bindings[j].equals(y.getVariable())) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            if (!(this.m_matches[i] instanceof LiteralMatch)) continue;
            dm = (LiteralMatch)this.m_matches[i];
            if (!(mi.m_matches[i] instanceof LiteralMatch)) continue;
            dm2 = (LiteralMatch)mi.m_matches[i];
            if (((LiteralMatch)dm).m_literal.equals(((LiteralMatch)dm2).m_literal)) continue;
            return false;
        }
        return super.equals(arg0);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        for (int i = 0; i < this.m_matches.length; ++i) {
            if (((IStreamInADTOptimizationInstruction)((Object)this.m_matches[i].m_handler)).canGenerateObjectless(tenv)) continue;
            return false;
        }
        return this.m_default == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).canGenerateObjectless(tenv);
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public void setToMatch(Instruction toMatch) {
        this.m_toMatch = toMatch;
    }

    public Match[] getMatches() {
        return this.m_matches;
    }

    public void setMatches(Match[] m) {
        this.m_matches = m;
    }

    public Instruction getDefault() {
        return this.m_default;
    }

    public void setDefault(Instruction d) {
        this.m_default = d;
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object o = this.m_toMatch.evaluate(e, f2, di, false);
        for (int j = 0; j < this.m_matches.length; ++j) {
            Match m = this.m_matches[j];
            if (m instanceof LiteralMatch) {
                LiteralMatch lm = (LiteralMatch)m;
                Object value2 = lm.m_literal.evaluate(e, f2, di, false);
                if (!value2.equals(o)) continue;
                lm.m_handler.evaluate(as, e, f2, di);
                Debugger.leave(di, this, e, f2, null);
                return;
            }
            if (!(m instanceof DeconstructionMatch)) continue;
            DeconstructionMatch dm = (DeconstructionMatch)m;
            AbstractDataObject ado = (AbstractDataObject)o;
            if (dm.m_constructor != ado.getConstructor()) continue;
            AbstractDataType.Constructor c = dm.m_constructor;
            int nBindings = c.m_parameters.length;
            Object[] values2 = ado.getValues();
            for (int k = 0; k < nBindings; ++k) {
                Binding binding = dm.m_bindings[k];
                e.bindInCurrentFrame(binding, values2[k]);
            }
            dm.m_handler.evaluate(as, e, f2, di);
            Debugger.leave(di, this, e, f2, null);
            return;
        }
        if (this.m_default == null) {
            throw new XylemError("ERR_SYSTEM", "Use of default: in switch() is unexpected:5.");
        }
        this.m_default.evaluate(as, e, f2, di);
        Debugger.leave(di, this, e, f2, null);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        Object o = this.m_toMatch.evaluate(e, f2, di, false);
        for (int j = 0; j < this.m_matches.length; ++j) {
            Match m = this.m_matches[j];
            if (m instanceof LiteralMatch) {
                LiteralMatch lm = (LiteralMatch)m;
                Object value2 = lm.m_literal.evaluate(e, f2, di, false);
                if (!value2.equals(o)) continue;
                ans = lm.m_handler.evaluate(e, f2, di, false);
                return Debugger.leave(di, this, e, f2, ans);
            }
            if (!(m instanceof DeconstructionMatch)) continue;
            DeconstructionMatch dm = (DeconstructionMatch)m;
            AbstractDataObject ado = (AbstractDataObject)o;
            if (dm.m_constructor != ado.getConstructor()) continue;
            AbstractDataType.Constructor c = dm.m_constructor;
            Object[] values2 = ado.getValues();
            int nBindings = c.m_parameters.length;
            for (int k = 0; k < nBindings; ++k) {
                Object value3 = XCIConstruction.evalForkIfNeeded(values2[k], e);
                e.bindInCurrentFrame(dm.m_bindings[k], value3);
            }
            try {
                ans = dm.m_handler.evaluate(e, f2, di, tailPosition);
            }
            catch (FunctionCallInstruction.TailCallEvent tc) {
                throw tc;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            return Debugger.leave(di, this, e, f2, ans);
        }
        if (this.m_default == null) {
            throw new XylemError("ERR_SYSTEM", "Use of default: in switch() is unexpected:6.");
        }
        ans = this.m_default.evaluate(e, f2, di, tailPosition);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        String com = this.m_toMatch.getLocationComment();
        if (com != null) {
            pw.comment(com, indent);
        }
        pw.printFormOpen("match", indent);
        this.m_toMatch.toString(pw, indent + 1);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match c = this.m_matches[i];
            if (null == c) continue;
            c.toString(pw, indent + 1);
        }
        if (this.m_default != null) {
            pw.printFormOpen("otherwise", indent + 1);
            this.m_default.toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < this.m_matches.length; ++i) {
            matches2[i] = this.m_matches[i].cloneShallow();
            Match m = matches2[i];
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                for (int j = 0; j < dm.m_bindings.length; ++j) {
                    Object s = ing.getNewName();
                    names.put(dm.m_bindings[j].getName(), new IdentifierInstruction(s));
                    dm.m_bindings[j].setName(s);
                }
            }
            m.m_handler = m.m_handler.assignNewNames(names, ing);
        }
        return new MatchInstruction(this.m_toMatch.assignNewNames(names, ing), matches2, this.m_default == null ? null : this.m_default.assignNewNames(names, ing));
    }

    public IdentifierInstruction doSpecialADTExtraction(TypeEnvironment tenv, BindingEnvironment benv) {
        if (!(this.m_toMatch instanceof IdentifierInstruction)) {
            return null;
        }
        IdentifierInstruction matchedInstr = (IdentifierInstruction)this.m_toMatch;
        if (!(this.m_toMatch.getCachedType() instanceof NamedType)) {
            return null;
        }
        ConstructorDataType matchedType = (ConstructorDataType)((NamedType)this.m_toMatch.getType(tenv, benv)).resolveNameToADT(tenv);
        if (1 != matchedType.m_constructors.length) {
            return null;
        }
        if (2 != matchedType.m_constructors[0].m_parameters.length) {
            return null;
        }
        if (1 != this.m_matches.length) {
            return null;
        }
        if (!(this.m_matches[0] instanceof DeconstructionMatch)) {
            return null;
        }
        DeconstructionMatch match = (DeconstructionMatch)this.m_matches[0];
        if (!(match.m_handler instanceof IdentifierInstruction)) {
            return null;
        }
        if (!match.m_bindings[0].getName().equals(((IdentifierInstruction)match.m_handler).getVariable())) {
            return null;
        }
        return matchedInstr;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_toMatch);
        wofh.writeBoolean(this.m_default != null);
        if (this.m_default != null) {
            wofh.writeInstruction(this.m_default);
        }
        int c = this.m_matches.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeInt(this.m_matches[i] instanceof LiteralMatch ? 0 : 1);
            this.m_matches[i].write(wofh);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_toMatch = rofh.readInstruction(benv);
        boolean b = rofh.readBoolean();
        if (b) {
            this.m_default = rofh.readInstruction(benv);
        }
        int c = rofh.readInt();
        this.m_matches = new Match[c];
        for (int i = 0; i < c; ++i) {
            switch (rofh.readInt()) {
                case 0: {
                    this.m_matches[i] = new LiteralMatch();
                    break;
                }
                case 1: {
                    this.m_matches[i] = new DeconstructionMatch();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.m_matches[i].read(rofh, benv);
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (this.m_default != null) {
            --i;
        }
        if (this.m_matches == null) {
            return null;
        }
        switch (i) {
            case -1: {
                return NO_BINDINGS;
            }
            case 0: {
                return null;
            }
        }
        return this.m_matches[i - 1].getBindings();
    }

    public void sortMatches() {
        Arrays.sort(this.m_matches, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                LiteralMatch lm0 = (LiteralMatch)arg0;
                LiteralMatch lm1 = (LiteralMatch)arg1;
                return ((Comparable)lm0.getLiteral().getValue()).compareTo(lm1.getLiteral().getValue());
            }
        });
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    public void desugarADTLambdas(TypeEnvironment tenv, BindingEnvironment benv, PolymorphicADTDesugarer td) {
        if (this.m_matches[0] instanceof DeconstructionMatch) {
            DeconstructionMatch dm0 = (DeconstructionMatch)this.m_matches[0];
            AbstractDataType adt = dm0.m_constructor.getAbstractDataType();
            if (adt instanceof AbstractDataTypeLambda) {
                AbstractDataTypeLambda adtl = (AbstractDataTypeLambda)adt;
                NamedType nt = (NamedType)this.m_toMatch.getType(tenv, benv).resolveType(tenv);
                AbstractDataType adt2 = nt.getTypeParameters() == null ? nt.resolveNameToADT(tenv) : adtl.applyADT(tenv.getModule(), nt.getTypeParameters());
                for (int i = 0; i < this.m_matches.length; ++i) {
                    DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                    dm.m_constructor = adt2.m_constructors[dm.m_constructor.getIndex()];
                    dm.m_constructorName = dm.m_constructor.getName();
                }
            }
            for (int i = 0; i < this.m_matches.length; ++i) {
                DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                for (int j = 0; j < dm.m_bindings.length; ++j) {
                    dm.m_bindings[j].setType(td.convertType(dm.m_bindings[j].getBindingType()));
                }
            }
        }
    }

    public int getExtractedField() {
        if (!(this.m_matches[0] instanceof DeconstructionMatch)) {
            return -1;
        }
        DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[0];
        if (this.m_matches.length != 1) {
            return -1;
        }
        if (!(dm.getHandler() instanceof IdentifierInstruction)) {
            return -1;
        }
        AbstractDataType.Constructor c = dm.getConstructor();
        if (!c.getName().equals(c.getAbstractDataType().getName())) {
            return -1;
        }
        AbstractDataType adt = c.getAbstractDataType();
        if (adt.m_constructors.length > 2) {
            return -1;
        }
        if (adt.m_constructors.length > 1 && c.getAbstractDataType().m_constructors[(c.getIndex() + 1) % 2].m_parameters.length != 0) {
            return -1;
        }
        Object field = ((IdentifierInstruction)this.m_matches[0].getHandler()).getVariable();
        Binding[] bb = this.m_matches[0].getBindings();
        for (int i = 0; i < bb.length; ++i) {
            if (!bb[i].getName().equals(field)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "generateCode", "MatchInstruction=" + this);
        }
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        Type thisType = cgt.resolveType(this);
        String retVar = cgh.generateNewLocalVariableName(varNameSuggestion) + "_matchResult";
        FcgType retVarType = thisType.getFCGType(cgh);
        if (this.m_matches[0] instanceof DeconstructionMatch) {
            AbstractDataType adt = ((DeconstructionMatch)this.m_matches[0]).m_constructor.getAbstractDataType();
            boolean onlyOne = adt.m_constructors.length == 1;
            GenerationState gs = cgt.getGenerationState(((IdentifierInstruction)this.m_toMatch).getBinding(benv));
            boolean isObjectless = gs instanceof StreamInADTOptimizedGenerationState ? ((StreamInADTOptimizedGenerationState)gs).isObjectless() : false;
            Binding memberInADT = gs instanceof StreamInADTOptimizedGenerationState ? ((StreamInADTOptimizedGenerationState)gs).getMember() : null;
            String toMatchVar = cgh.generateNewLocalVariableName();
            Type toMatchType = cgt.resolveType(this.m_toMatch);
            cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            toMatchType.appendHolderVariableDeclaration(cgh, toMatchVar, isObjectless, memberInADT, cgt, il);
            toMatchType.appendHolderVariableAssignment(cgh, toMatchVar, isObjectless, memberInADT, cgt, il);
            if (onlyOne) {
                DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[0];
                CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, toMatchVar, cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, memberInADT, il);
                dm.m_handler.generateCode(cgh, cgt2, null, tailPosition, il, valueStyleRequest);
                boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
            } else {
                FcgVariable ret = il.defineVar(retVarType, retVar, false);
                il.comment(" match " + adt.getName());
                adt.generateConstructorTypeDeconstructionCode(cgh, toMatchVar, il);
                il.beginSwitch();
                for (int i = 0; i < this.m_matches.length; ++i) {
                    DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                    int caseValue = dm.m_constructor.getIndex();
                    il.beginSwitchCaseBlock(caseValue);
                    il.comment(" match case " + dm.m_constructor.getName());
                    CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCode(cgh, toMatchVar, cgt, dm.m_bindings, dm.m_constructor, this.m_toMatch, memberInADT, il);
                    dm.m_handler.generateCode(cgh, cgt2, null, tailPosition, il, valueStyleRequest);
                    boolean resultForkable = dm.m_handler.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
                    il.storeVar(ret);
                    il.endSwitchCaseBlock();
                }
                il.beginSwitchDefaultBlock();
                il.comment(" match adt " + adt.getName());
                if (this.m_default != null) {
                    this.m_default.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
                    il.storeVar(ret);
                    il.endSwitchDefaultBlock();
                } else {
                    il.loadLiteral("Use of default: in switch() is unexpected:7.");
                    il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                    il.throwObject();
                    il.endSwitchDefaultBlockFallThru();
                }
                il.endSwitch();
                il.loadVar(ret);
            }
            return retVarType;
        }
        if (this.m_matches[0] instanceof LiteralMatch) {
            FcgVariable ret = il.defineVar(retVarType, retVar, false);
            cgt.generateConventionally(this.m_toMatch, cgh, false, il, ValueGenStyle.DEFAULT);
            Type matchType = this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment);
            if (matchType.equals(BooleanType.s_booleanType)) {
                il.convertExpr(FcgType.BOOLEAN, FcgType.INT);
            }
            il.comment(" matching " + matchType.toString());
            il.beginSwitch();
            for (int i = 0; i < this.m_matches.length; ++i) {
                LiteralMatch lm = (LiteralMatch)this.m_matches[i];
                Type lmType = lm.getPatternType();
                if (lmType.equals(IntType.s_intType)) {
                    il.beginSwitchCaseBlock(LiteralInstruction.getInteger(lm.m_literal));
                } else if (lmType.equals(CharType.s_charType)) {
                    il.beginSwitchCaseBlock(((Character)lm.getLiteral().getValue()).charValue());
                } else if (lmType.equals(ShortType.s_shortType)) {
                    il.beginSwitchCaseBlock(((Short)lm.getLiteral().getValue()).shortValue());
                } else if (lmType.equals(BooleanType.s_booleanType)) {
                    il.beginSwitchCaseBlock((Boolean)lm.getLiteral().getValue() != false ? 1 : 0);
                }
                il.comment(" literal match " + lm.m_literal.toString());
                lm.m_handler.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
                il.storeVar(ret);
                il.endSwitchCaseBlock();
            }
            il.beginSwitchDefaultBlock();
            il.comment(" match any " + this.m_toMatch.getType(tenv, cgt.m_bindingEnvironment).toString());
            if (this.m_default != null) {
                this.m_default.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
                il.storeVar(ret);
                il.endSwitchDefaultBlock();
            } else {
                il.loadLiteral("Use of default: in switch() is unexpected:8.");
                il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                il.throwObject();
                il.endSwitchDefaultBlockFallThru();
            }
            il.endSwitch();
            return il.loadVar(ret);
        }
        throw new XylemError("ERR_SYSTEM", "Can only match literals and ADTs");
    }

    public static Object[] generateReleaseHandlesForBindings(Binding[] bindings, Binding dontReleaseThisOne, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il) {
        boolean DISABLE = true;
        if (!doStaticForkMgmt) {
            return null;
        }
        Object[] releaseVars = null;
        ArrayList buffer = new ArrayList(bindings.length);
        boolean releaseNeeded = false;
        for (int i = 0; i < bindings.length; ++i) {
            Binding b = bindings[i];
            Type t = b.getBindingType();
            buffer.add(null);
        }
        if (releaseNeeded) {
            releaseVars = buffer.toArray();
        }
        return releaseVars;
    }

    public static void generateReleaseFromHandles(Binding[] bindings, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, Object[] releaseHandles, FcgType resultType, String caller, boolean resultForkable) {
        if (!doStaticForkMgmt) {
            return;
        }
        if (releaseHandles == null) {
            return;
        }
        String varName = cgh.generateNewLocalVariableName();
        FcgVariable result2 = resultType == null || resultType == FcgType.VOID ? null : il.defineVar(resultType, varName, true);
        il.comment("Begin release handles for " + caller);
        for (int which = 0; which < releaseHandles.length; ++which) {
            Type t = bindings[which].getBindingType();
            if (t.isForkReleaseManaged(cgt)) {
                FcgType ft = il.loadVar((FcgVariable)releaseHandles[which]);
                if (!resultForkable || resultType == null || resultType == FcgType.VOID) {
                    t.generateObjectRelease(cgh, il, cgt);
                } else if (!MatchInstruction.bothTypesAreObjects(ft, resultType)) {
                    t.generateObjectRelease(cgh, il, cgt);
                } else {
                    il.convertExpr(ft, FcgType.OBJECT);
                    il.loadVar(result2);
                    il.convertExpr(resultType, FcgType.OBJECT);
                    il.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                    il.beginIf();
                    ft = il.loadVar((FcgVariable)releaseHandles[which]);
                    t.generateObjectRelease(cgh, il, cgt);
                    il.endIf();
                }
            }
            ++which;
        }
        il.comment("End release handles for " + caller);
        if (result2 != null) {
            il.loadVar(result2);
        }
    }

    public static boolean typesMayCollide(FcgType t1, FcgType t2) {
        Class<?> c1 = null;
        Class<?> c2 = null;
        if (t1 instanceof FcgClassReferenceType || t1 instanceof FcgInterfaceType) {
            try {
                c1 = Class.forName(t1.getTypeName());
            }
            catch (ClassNotFoundException e) {
                c1 = null;
            }
        }
        if (t2 instanceof FcgClassReferenceType || t2 instanceof FcgInterfaceType) {
            try {
                c2 = Class.forName(t2.getTypeName());
            }
            catch (ClassNotFoundException e) {
                c2 = null;
            }
        }
        if (c1 != null && c2 != null) {
            return c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1);
        }
        return false;
    }

    public static boolean bothTypesAreObjects(FcgType t1, FcgType t2) {
        return t1 instanceof FcgReferenceType && t2 instanceof FcgReferenceType;
    }

    public static final class DeconstructionMatch
    extends Match {
        protected AbstractDataType.Constructor m_constructor;
        public String m_constructorName;
        protected Binding[] m_bindings;
        protected NamedType m_patternType;

        public DeconstructionMatch(String constructorName, Object[] bindings, Instruction handler) {
            this.m_constructorName = constructorName;
            this.m_handler = handler;
            this.m_bindings = Binding.getBindings(bindings);
        }

        public DeconstructionMatch(AbstractDataType.Constructor constructor, Object[] bindings, Instruction handler) {
            this.m_constructorName = constructor.getName();
            this.m_handler = handler;
            this.m_bindings = Binding.getBindings(bindings);
        }

        protected DeconstructionMatch() {
        }

        public DeconstructionMatch(String constructorName, int fields, int fieldToExtract) {
            this(constructorName, MatchInstruction.makeFields(OptimizerUtilities.generateIntermediateIdentifier(), fields), null);
            this.m_handler = new IdentifierInstruction(this.m_bindings[fieldToExtract].getName());
        }

        public DeconstructionMatch(AbstractDataType.Constructor constructor, int fieldToExtract) {
            this(constructor, MatchInstruction.makeFields(OptimizerUtilities.generateIntermediateIdentifier(), constructor.m_parameters.length), null);
            this.m_handler = new IdentifierInstruction(this.m_bindings[fieldToExtract].getName());
        }

        @Override
        public Binding[] getBindings() {
            return this.m_bindings;
        }

        public AbstractDataType.Constructor getConstructor() {
            return this.m_constructor;
        }

        @Override
        Type getPatternType() {
            return this.m_patternType;
        }

        @Override
        Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
            if (this.m_constructor == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this.m_handler);
            }
            if (this.m_constructor.m_parameters.length != this.m_bindings.length) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Expected " + this.m_constructor.m_parameters.length + " but got " + this.m_bindings.length + " in Deconstruction match " + this), this.m_handler);
            }
            BindingEnvironment benv2 = new BindingEnvironment(benv);
            this.m_patternType = this.m_constructor.getAbstractDataType().getNamedType();
            if (this.m_constructor.getAbstractDataType() instanceof AbstractDataTypeLambda) {
                HashMap typeMap = new HashMap();
                this.m_patternType = (NamedType)this.m_patternType.duplicateType(typeMap);
                for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                    this.m_bindings[i].setType(this.m_constructor.m_parameters[i].getBindingType().duplicateType(typeMap));
                    benv2.setVariableBinding(this.m_bindings[i]);
                }
            } else {
                for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                    this.m_bindings[i].setType(this.m_constructor.m_parameters[i].getBindingType());
                    benv2.setVariableBinding(this.m_bindings[i]);
                }
            }
            return this.m_handler.typeCheck(tenv, benv2, functionStack);
        }

        @Override
        void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, HashMap typeMap) {
            this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
            if (this.m_constructor == null) {
                throw new XylemError("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName);
            }
            if (this.m_constructor.m_parameters.length != this.m_bindings.length) {
                throw new XylemError("ERR_SYSTEM", "Expected " + this.m_constructor.m_parameters.length + " but got " + this.m_bindings.length + " in Deconstruction match " + this);
            }
            if (this.m_constructor.getAbstractDataType() instanceof AbstractDataTypeLambda) {
                for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                    this.m_bindings[i].setType(this.m_constructor.m_parameters[i].getBindingType().duplicateType(typeMap));
                    benv.setVariableBinding(this.m_bindings[i]);
                }
            } else {
                for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                    this.m_bindings[i].setType(this.m_constructor.m_parameters[i].getBindingType());
                    benv.setVariableBinding(this.m_bindings[i]);
                }
            }
        }

        @Override
        Match cloneWithoutTypeInformation() {
            Object[] newBindingNames = new Object[this.m_bindings.length];
            for (int i = 0; i < this.m_bindings.length; ++i) {
                newBindingNames[i] = this.m_bindings[i].getName();
            }
            DeconstructionMatch dm = new DeconstructionMatch(this.m_constructorName, newBindingNames, this.m_handler.cloneWithoutTypeInformation());
            dm.m_constructor = this.m_constructor;
            return dm;
        }

        @Override
        Match cloneShallow() {
            Object[] newBindingNames = new Object[this.m_bindings.length];
            for (int i = 0; i < this.m_bindings.length; ++i) {
                newBindingNames[i] = this.m_bindings[i].getName();
            }
            DeconstructionMatch dm = new DeconstructionMatch(this.m_constructorName, newBindingNames, this.m_handler);
            dm.m_constructor = this.m_constructor;
            return dm;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(" + this.m_constructorName);
            for (int i = 0; i < this.m_bindings.length; ++i) {
                sb.append(" ");
                sb.append(this.m_bindings[i].getName());
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        void toString(PrettyPrinter pw, int indent) {
            String com = this.m_handler.getLocationComment();
            if (com != null) {
                pw.comment(com, indent);
            }
            pw.printFormOpen("case", indent);
            pw.printFormOpen(this.m_constructorName, indent + 1);
            for (int i = 0; i < this.m_bindings.length; ++i) {
                pw.printIdentifier(this.m_bindings[i], indent + 2);
            }
            pw.printFormClose(indent + 1);
            this.m_handler.toString(pw, indent + 1);
            pw.printFormClose(indent);
        }

        @Override
        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_constructorName = rofh.readString();
            this.m_bindings = Binding.getBindings(rofh.readBindingNames());
            this.m_handler = rofh.readInstruction(benv);
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeString(this.m_constructorName);
            wofh.writeBindingNames(this.m_bindings);
            wofh.writeInstruction(this.m_handler);
        }
    }

    public static final class LiteralMatch
    extends Match {
        protected LiteralInstruction m_literal;

        protected LiteralMatch() {
        }

        public LiteralMatch(LiteralInstruction literal, Instruction handler) {
            this.m_literal = literal;
            this.m_handler = handler;
        }

        public String toString() {
            return "(case " + this.m_literal + " " + this.m_handler + ")";
        }

        public void setLiteral(LiteralInstruction li) {
            this.m_literal = li;
        }

        @Override
        Type getPatternType() {
            return this.m_literal.getType();
        }

        @Override
        Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            return this.m_handler.typeCheck(tenv, benv, functionStack);
        }

        @Override
        Match cloneWithoutTypeInformation() {
            return new LiteralMatch(this.m_literal, this.m_handler.cloneWithoutTypeInformation());
        }

        @Override
        Match cloneShallow() {
            return new LiteralMatch(this.m_literal, this.m_handler);
        }

        public LiteralInstruction getLiteral() {
            return this.m_literal;
        }

        @Override
        void toString(PrettyPrinter pw, int indent) {
            String com = this.m_handler.getLocationComment();
            if (com != null) {
                pw.comment(com, indent);
            }
            pw.printFormOpen("case", indent);
            if (null != this.m_literal) {
                this.m_literal.toString(pw, indent + 1);
            }
            if (null != this.m_handler) {
                this.m_handler.toString(pw, indent + 1);
            }
            pw.printFormClose(indent);
        }

        @Override
        void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, HashMap typeMap) {
        }

        @Override
        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_literal = new LiteralInstruction();
            this.m_literal.read(rofh, benv);
            this.m_handler = rofh.readInstruction(benv);
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            this.m_literal.write(wofh);
            wofh.writeInstruction(this.m_handler);
        }

        @Override
        Binding[] getBindings() {
            return ISpecialForm.NO_BINDINGS;
        }
    }

    public static abstract class Match {
        Instruction m_handler;

        abstract Type getPatternType();

        abstract Type doTypeCheck(TypeEnvironment var1, BindingEnvironment var2, LinkedList var3) throws TypeCheckException;

        abstract void doTypeCheckReduced(TypeEnvironment var1, BindingEnvironment var2, HashMap var3);

        abstract Match cloneWithoutTypeInformation();

        abstract Match cloneShallow();

        public Instruction getHandler() {
            return this.m_handler;
        }

        public void setHandler(Instruction h) {
            this.m_handler = h;
        }

        public abstract void read(ReadObjectFileHelper var1, BindingEnvironment var2) throws Exception;

        public abstract void write(WriteObjectFileHelper var1) throws IOException;

        abstract void toString(PrettyPrinter var1, int var2);

        abstract Binding[] getBindings();
    }
}

