/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class MethodInvocationInstruction
extends NaryPrimopInstruction {
    protected String m_function;
    public Instruction m_object;

    public MethodInvocationInstruction() {
    }

    public MethodInvocationInstruction(String function2, Instruction object2, Instruction[] parameters) {
        super(parameters);
        this.m_function = function2;
        this.m_object = object2;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String n2) {
        this.m_function = n2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_object.typeCheck(tenv, benv, functionStack);
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
        }
        if (!(t instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not an object"), this);
        }
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        if (jot == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Xylem object"), this);
        }
        ClassType.Method m = jot.resolveMethod(this.m_function, tenv);
        if (m == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] types2 = m.m_parameters;
        if (types2.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + jot.getName() + " takes " + m.m_parameters.length + " parameters"), this);
        }
        for (int j = 0; j < types2.length; ++j) {
            tenv.unify(types2[j].getBindingType(), this.m_parameters[j].typeCheck(tenv, benv, functionStack), this);
        }
        return this.setCachedType(m.getReturnType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_object.getType(tenv, benv);
        t = t.resolveType(tenv);
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Method m = jot.resolveMethod(this.m_function, tenv);
        return m.getReturnType();
    }

    @Override
    public Instruction getChildInstruction(int i) {
        return i > 0 ? this.m_parameters[i - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (i == 0) {
            this.m_object = n2;
        } else {
            this.m_parameters[i - 1] = n2;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        MethodInvocationInstruction i = new MethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), parameters);
        MethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        MethodInvocationInstruction i = new MethodInvocationInstruction(this.m_function, this.m_object, parameters);
        MethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "method-invoke";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_function.toString();
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        MethodInvocationInstruction mii = (MethodInvocationInstruction)arg0;
        return mii.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_object = rh.reduceToBasicInstruction(state, this.m_object, benv);
        super.generateReducedForm(rh, state, benv);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_object = rofh.readInstruction(benv);
        this.m_function = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInstruction(this.m_object);
        wofh.writeString(this.m_function);
    }
}

