/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.RuntimeTerminateException;
import com.ibm.xltxe.rnm1.xylem.utils.XSLTArgumentNodeMissingTypedValueException;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.errors.XCIIllegalContextItemException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleFunctionCallInstruction
extends NaryPrimopInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(ModuleFunctionCallInstruction.class);
    private static final String s_className = ModuleFunctionCallInstruction.class.getName();
    protected String m_function;
    protected String m_module;
    public static boolean LAZYMODULETYPECHECK = false;

    public ModuleFunctionCallInstruction() {
    }

    public ModuleFunctionCallInstruction(String module, String function2, Instruction[] parameters) {
        super(parameters);
        this.m_module = module;
        this.m_function = function2;
    }

    public ModuleFunctionCallInstruction(String module, String function2, List parameters) {
        super(parameters);
        this.m_module = module;
        this.m_function = function2;
    }

    public String getModule() {
        return this.m_module;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String n2) {
        this.m_function = n2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        Function function2;
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        FunctionSignature fs = this.resolveFunctionSignature(tenv);
        if (fs == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_function + " not found in signature of " + "module " + this.m_module), this);
        }
        if (fs.getParameterTypes().length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Incorrect number of parameters to " + this.m_function + " in module " + this.m_module + "\n  expected " + fs.getParameterTypes().length + ", found " + this.m_parameters.length), this);
        }
        if (LAZYMODULETYPECHECK && !(function2 = this.resolveFunction(tenv)).hasBeenTypeChecked()) {
            function2.typeCheck(tenv.getModule().getProgram().getModule(this.m_module), this, functionStack);
        }
        TypeEnvironment tenv2 = new TypeEnvironment(tenv.getModule());
        HashSet typeVars = new HashSet();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Type t1 = this.m_parameters[i].typeCheck(tenv, benv, functionStack);
            try {
                tenv2.unify(t1.resolveTypeAsMuchAsPossible(tenv, typeVars), fs.getParameterTypes()[i], this.m_parameters[i]);
                continue;
            }
            catch (TypeCheckException tce) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Type error in parameter " + i + " for function " + this.m_function + " of module " + this.m_module + "\n" + tce.getMessage()), this);
            }
        }
        return this.setCachedType(fs.getReturnType().resolveTypeAsMuchAsPossible(tenv2, typeVars));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        try {
            FunctionSignature fs = this.resolveFunctionSignature(tenv);
            if (fs == null) {
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Function not resolved for " + this});
                XylemError error2 = new XylemError(message);
                FFDCUtil.log(error2, this);
                s_logger.logp(Level.SEVERE, s_className, "getType", message);
                throw error2;
            }
            return fs.getReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        FunctionSignature sig = msig.getFunctionSignature(this.m_function);
        if (sig != null) {
            return sig.getReturnType();
        }
        ModuleSignature msig2 = msig.getModuleSignature(this.m_module);
        if (msig2 != null && (sig = msig2.getFunctionSignature(this.m_function)) != null) {
            return sig.getReturnType();
        }
        return super.getPreTypecheckType(msig);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ModuleFunctionCallInstruction i = new ModuleFunctionCallInstruction(this.m_module, this.m_function, parameters);
        ModuleFunctionCallInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        ModuleFunctionCallInstruction i = new ModuleFunctionCallInstruction(this.m_module, this.m_function, parameters);
        ModuleFunctionCallInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!super.equals(arg0)) {
            return false;
        }
        ModuleFunctionCallInstruction fci = (ModuleFunctionCallInstruction)arg0;
        return fci.m_function.equals(this.m_function) && fci.m_module.equals(this.m_module);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object result2;
        Function f22;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((f22 = this.resolveFunction(f2.getTypeEnvironment())).getMemoizeResult() && (result2 = e.lookupMemoizedFunction(f22)) != null) {
            result2 = XCIConstruction.evalForkIfNeeded(result2, e);
            return Debugger.leave(di, this, e, f2, result2);
        }
        e.pushForkScope();
        Object ans = null;
        try {
            Binding[] b = f22.m_parameters;
            e.establishStackFrame(f22.getStackFrameSize(), f22.getName());
            for (int i = 0; i < b.length; ++i) {
                Object o = this.m_parameters[i].evaluate(e, f2, di, false);
                e.bindInEstablishedFrame(b[i], o);
            }
            e.pushStackFrame(f22.getName());
            Debugger.enterContext(di, f22);
            Object result3 = f22.getBody().evaluate(e, f22, di, false);
            Debugger.leaveContext(di, f22, result3);
            if (f22.getMemoizeResult()) {
                Object resultToMemoize = XCIConstruction.evalForkIfNeeded(result3);
                e.memoizeFunction(f22, resultToMemoize);
            }
            ans = result3;
            e.popStackFrame(f22.getName());
        }
        catch (RuntimeTerminateException ex) {
            try {
                if (ex.getSourceLocationIndex() != -1) throw ex;
                ex.setSourceLocationIndex(super.getSourceLineNumber());
                throw ex;
                catch (RuntimeException ex2) {
                    if (!SOURCELINEINFO) throw ex2;
                    throw new RuntimeTerminateException(ex2, super.getSourceLineNumber());
                }
            }
            catch (Throwable throwable) {
                e.popForkScope(ans);
                throw throwable;
            }
        }
        e.popForkScope(ans);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        boolean isValueOf = this.m_function.contains("value-of");
        Function f22 = this.resolveFunction(f2.getTypeEnvironment());
        if (f22.getMemoizeResult()) {
            super.evaluate(as, e, f2, di);
            return;
        }
        e.pushForkScope();
        try {
            e.establishStackFrame(f22.getStackFrameSize());
            Binding[] b = f22.m_parameters;
            Object[] old2 = new Object[b.length];
            for (int i = 0; i < b.length; ++i) {
                Object o = this.m_parameters[i].evaluate(e, f2, di, false);
                e.bindInEstablishedFrame(b[i], o);
            }
            e.pushStackFrame();
            Debugger.enterContext(di, f22);
            f22.getBody().evaluate(as, e, f22, di);
            Debugger.leaveContext(di, f22, null);
            e.popStackFrame();
        }
        catch (XCIIllegalContextItemException xicie) {
            if (isValueOf) {
                throw new XSLTArgumentNodeMissingTypedValueException();
            }
        }
        catch (RuntimeTerminateException ex) {
            if (ex.getSourceLocationIndex() == -1) {
                ex.setSourceLocationIndex(super.getSourceLineNumber());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (SOURCELINEINFO) {
                throw new RuntimeTerminateException(ex, super.getSourceLineNumber());
            }
            throw ex;
        }
        finally {
            e.popForkScope();
        }
        Debugger.leave(di, this, e, f2, null);
    }

    private Function resolveFunction(TypeEnvironment tenv) {
        Module m = tenv.getModule().getProgram().getModule(this.m_module);
        if (m == null) {
            return null;
        }
        return m.getPublicFunction(this.m_function);
    }

    protected FunctionSignature resolveFunctionSignature(TypeEnvironment tenv) throws TypeCheckException {
        ModuleSignature ms = tenv.getModule().getModuleSignature(this.m_module);
        if (ms == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Module " + this.m_module + " could not be resolved"), this);
        }
        FunctionSignature fs = ms.getFunctionSignature(this.m_function);
        if (fs == null) {
            throw new XylemError("ERR_SYSTEM", this + " not found in +" + ms);
        }
        return fs;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public String innerToString() {
        return "call-module-function";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_module + " " + this.m_function;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_module = rofh.readString();
        this.m_function = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_module);
        wofh.writeString(this.m_function);
    }
}

