/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import java.util.LinkedList;

public class NaNInstruction
extends UnaryPrimopInstruction {
    public NaNInstruction(Instruction parameter) {
        super(parameter);
    }

    public NaNInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        NaNInstruction i = new NaNInstruction(this.m_operand.cloneWithoutTypeInformation());
        NaNInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type operandType = this.m_operand.typeCheck(tenv, benv, functionStack);
        if (operandType != FloatType.s_floatType && operandType != DoubleType.s_doubleType) {
            tenv.unify(operandType, DoubleType.s_doubleType, this);
        }
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType retVal = null;
        cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        retVal = this.m_operand.getCachedType() == FloatType.s_floatType ? il.unaryOperationExpr(FcgUnaryOp.IS_NAN) : il.unaryOperationExpr(FcgUnaryOp.IS_NAN);
        return retVal;
    }

    @Override
    public String innerToString() {
        return "nan?";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (this.m_operand.evaluateType(f2) == FloatType.s_floatType) {
            Boolean ans = ((Float)this.m_operand.evaluate(e, f2, di, false)).isNaN() ? Boolean.TRUE : Boolean.FALSE;
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        Boolean ans = ((Double)this.m_operand.evaluate(e, f2, di, false)).isNaN() ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        NaNInstruction i = new NaNInstruction(operand2);
        NaNInstruction.propagateInfo(this, i);
        return i;
    }
}

