/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class NaryPrimopInstruction
extends Instruction {
    public Instruction[] m_parameters;

    protected static final Instruction[] convertParameters(List<Instruction> parameters) {
        Instruction[] params = new Instruction[parameters.size()];
        parameters.toArray(params);
        return params;
    }

    public NaryPrimopInstruction(Instruction[] parameters) {
        this.m_parameters = parameters;
    }

    public NaryPrimopInstruction(List<Instruction> parameters) {
        this(NaryPrimopInstruction.convertParameters(parameters));
    }

    public NaryPrimopInstruction() {
        this((Instruction[])null);
    }

    public Instruction[] getOperands() {
        return this.m_parameters;
    }

    public int getOperandCount() {
        return this.m_parameters.length;
    }

    protected void typeCheckChildren(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].typeCheck(tenv, benv, functionStack);
        }
    }

    @Override
    public Instruction getChildInstruction(int i) {
        return this.m_parameters[i];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        this.m_parameters[i] = n2;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        for (Instruction param : this.m_parameters) {
            this.m_parameters[i] = rh.reduceToBasicInstruction(state, param, benv);
        }
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        int c = rofh.readInt();
        this.m_parameters = new Instruction[c];
        for (int i = 0; i < c; ++i) {
            this.m_parameters[i] = rofh.readInstruction(benv);
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        int c = this.m_parameters.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.m_parameters[i]);
        }
    }

    @Override
    public Instruction cloneReduced() {
        if (Instruction.CLONEREDUCEDSHALLOW) {
            return this.cloneShallow();
        }
        return super.cloneReduced();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }
}

