/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class NumericalComparisonInstruction
extends BinaryPrimopInstruction {
    protected int m_operator;

    public NumericalComparisonInstruction() {
    }

    public NumericalComparisonInstruction(Instruction op1, Instruction op2, int operator2) {
        super(op1, op2);
        this.m_operator = operator2;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type type1 = this.m_operand1.typeCheck(tenv, benv, functionStack);
        Type type2 = this.m_operand2.typeCheck(tenv, benv, functionStack);
        tenv.unify(type1, type2, this);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        NumericalComparisonInstruction i = new NumericalComparisonInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_operator);
        NumericalComparisonInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_operand1, cgh, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_operand2, cgh, false, il, ValueGenStyle.DEFAULT);
        Type t = cgt.resolveType(this.m_operand1);
        if (!(t instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types and char");
        }
        INumericalType nm = (INumericalType)((Object)t);
        FcgBinOp op2 = (FcgBinOp)FcgCodeGenHelper.getFcgOperation(this.m_operator);
        FcgType retType = nm.generateCodeForOperation(cgh, il, op2);
        return retType;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(PrimitiveNumericalType.getOperatorString(this.m_operator), indent);
        this.m_operand1.toString(pw, indent + 1);
        this.m_operand2.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Type t = this.m_operand1.evaluateType(f2);
        Object x = this.m_operand1.evaluate(e, f2, di, false);
        Object y = this.m_operand2.evaluate(e, f2, di, false);
        if (!(t instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive comparison operations only supported on numerical types");
        }
        INumericalType nm = (INumericalType)((Object)t);
        Object ans = nm.evaluateOperation(e, x, y, this.m_operator);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new NumericalComparisonInstruction(op1, op2, this.m_operator);
    }

    public int getOperation() {
        return this.m_operator;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        return ((NumericalComparisonInstruction)arg0).m_operator == this.m_operator;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_operator);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_operator = rofh.readInt();
    }
}

