/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class PrimitiveArithmeticInstruction
extends BinaryPrimopInstruction {
    protected int m_operation;

    public PrimitiveArithmeticInstruction(Instruction op1, Instruction op2, int op3) {
        super(op1, op2);
        this.m_operation = op3;
    }

    public PrimitiveArithmeticInstruction() {
    }

    public int getOperation() {
        return this.m_operation;
    }

    public FcgOperation getFcgOperation() {
        return FcgCodeGenHelper.getFcgOperation(this.m_operation);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.setCachedType(this.m_operand2.typeCheck(tenv, benv, functionStack));
        tenv.unify(this.m_operand1.typeCheck(tenv, benv, functionStack), t, this);
        return t;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand1.getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_operand1.getPreTypecheckType(msig);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        PrimitiveArithmeticInstruction i = new PrimitiveArithmeticInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_operation);
        PrimitiveArithmeticInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
        Type t = cgt.resolveType(this);
        if (!(t instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive arithmetic operations only supported on numerical types");
        }
        INumericalType nm = (INumericalType)((Object)t);
        FcgOperation fcgOp = this.getFcgOperation();
        FcgType retType = nm.generateCodeForOperation(cg, il, fcgOp);
        return retType;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(PrimitiveNumericalType.getOperator(this.m_operation), indent);
        this.m_operand1.toString(pw, indent + 1);
        this.m_operand2.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Type t;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (!((t = this.evaluateType(f2)) instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Primitive arithmetic operations only supported on numerical types");
        }
        INumericalType nm = (INumericalType)((Object)t);
        Object x = this.m_operand1.evaluate(e, f2, di, false);
        Object y = this.m_operand2.evaluate(e, f2, di, false);
        Object ans = nm.evaluateOperation(e, x, y, this.m_operation);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new PrimitiveArithmeticInstruction(op1, op2, this.m_operation);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        return ((PrimitiveArithmeticInstruction)arg0).m_operation == this.m_operation;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInt(this.m_operation);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_operation = rofh.readInt();
    }
}

