/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class PrimitiveEqualityInstruction
extends BinaryPrimopInstruction {
    public PrimitiveEqualityInstruction(Instruction op1, Instruction op2) {
        super(op1, op2);
    }

    public PrimitiveEqualityInstruction() {
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_operand1.typeCheck(tenv, benv, functionStack);
        this.m_operand2.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        PrimitiveEqualityInstruction i = new PrimitiveEqualityInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        PrimitiveEqualityInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        Type t1 = cgt.resolveType(this.m_operand1);
        Type t2 = cgt.resolveType(this.m_operand2);
        if (t1 == null) {
            throw new XylemError("ERR_SYSTEM", "" + this);
        }
        if (t2 == null) {
            throw new XylemError("ERR_SYSTEM", "" + this);
        }
        cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
        FcgType retType = il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
        if (retType != FcgType.BOOLEAN) {
            throw new XylemError("ERR_SYSTEM", " PrimitiveEqualityInstruction evalutes to non-boolean" + retType);
        }
        return retType;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("eq?", indent);
        this.m_operand1.toString(pw, indent + 1);
        this.m_operand2.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Type t1 = this.m_operand1.evaluateType(f2);
        Type t2 = this.m_operand2.evaluateType(f2);
        Object x = this.m_operand1.evaluate(e, f2, di, false);
        Object y = this.m_operand2.evaluate(e, f2, di, false);
        Object ans = t1 instanceof INumericalType && t2 instanceof INumericalType ? ((INumericalType)((Object)t1)).evaluateOperation(e, x, y, 9) : (x == null || y == null ? (x == y ? Boolean.TRUE : Boolean.FALSE) : (x.equals(y) ? Boolean.TRUE : Boolean.FALSE));
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        PrimitiveEqualityInstruction i = new PrimitiveEqualityInstruction(op1, op2);
        PrimitiveEqualityInstruction.propagateInfo(this, i);
        return i;
    }
}

