/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ProcessStreamInstruction
extends TestStreamInstruction
implements IStreamOptimizationInstruction {
    protected boolean m_wrapResult;
    protected Type m_stateADTType = null;

    public ProcessStreamInstruction(boolean wrapResult, Instruction source, Instruction hint, Object elementVar, Object hintVar, Object indexVar, Instruction body, Type stateADTType) {
        super(source, hint, elementVar, hintVar, indexVar, body);
        this.m_wrapResult = wrapResult;
        this.m_stateADTType = stateADTType;
    }

    public ProcessStreamInstruction(boolean wrapResult, Instruction source, Instruction hint, Object elementVar, Object hintVar, Object indexVar, Instruction body) {
        this(wrapResult, source, hint, elementVar, hintVar, indexVar, body, null);
    }

    public ProcessStreamInstruction() {
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        StreamType outStreamType = (StreamType)cgt.resolveType(this);
        FcgType outType = outStreamType.getFCGType(cgh);
        FcgType outElemType = outStreamType.getElementType().getFCGType(cgh);
        String outName = cgh.generateNewLocalVariableName();
        FcgVariable out = il.defineVar(outType, outName, false);
        outStreamType.generateCreateStream(outName, 32, cgh, il);
        this.generateCodeWithStreamOptimization(cgh, il, outName, outStreamType, cgt, tailPosition, valueStyleRequest);
        outStreamType.generateCompactStream(outName, cgh, il);
        if (this.m_wrapResult) {
            throw new UnsupportedOperationException();
        }
        il.loadVar(out);
        return outType;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        cgt.generateFreeBindings(this, cgh, il, ((IdentifierInstruction)this.m_source).getBinding(benv), tailPosition, false, ValueGenStyle.DEFAULT);
        String sourceName = cgh.generateNewLocalVariableName();
        FcgType sourceType = cgt.generateConventionally(this.m_source, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable source = il.defineConstVar(sourceType, sourceName);
        StreamType sourceStreamType = (StreamType)cgt.resolveType(this.m_source);
        FcgType sourceElemType = sourceStreamType.getElementType().getFCGType(cgh);
        String hintName = cgh.generateNewLocalVariableName();
        FcgType hintType = cgt.generateConventionally(this.m_hint, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable hint = il.defineVar(hintType, hintName, true);
        boolean usesIndex = this.m_indexBinding != null && cgt.isBindingUsed(this.m_indexBinding);
        FcgVariable index2 = null;
        String indexName = null;
        if (usesIndex) {
            indexName = cgh.generateNewLocalVariableName();
            il.loadLiteral(0);
            index2 = il.defineVar(FcgType.INT, indexName, true);
        }
        boolean onceFalseAlwaysFalseIdiom = false;
        boolean onceTrueAlwaysTrueIdiom = false;
        if (this.m_body instanceof ChooseInstruction) {
            Instruction handler;
            TupleInstruction ti;
            Instruction tie;
            Instruction test2;
            ChooseInstruction ci = (ChooseInstruction)this.m_body;
            if (LiteralInstruction.booleanFalseLiteral().equals(ci.getDefaultHandler()) && ci.m_cases.length == 1) {
                IdentifierInstruction ii;
                test2 = ci.m_cases[0].getTest();
                if (test2 instanceof IdentifierInstruction && (ii = (IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding && ci.m_defaultHandler instanceof TupleInstruction && (tie = (ti = (TupleInstruction)ci.m_defaultHandler).getChildInstruction(0)) instanceof StreamInstruction && ((StreamInstruction)tie).getChildInstructionCount() == 0 && LiteralInstruction.booleanFalseLiteral() == ti.getChildInstruction(1)) {
                    onceFalseAlwaysFalseIdiom = true;
                    il.loadVar(hint);
                    il.beginIf();
                }
            } else if (ci.m_cases.length == 1 && (test2 = ci.m_cases[0].getTest()) instanceof IdentifierInstruction && ((IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding && (handler = ci.m_cases[0].getHandler()) instanceof TupleInstruction && (tie = (ti = (TupleInstruction)handler).getChildInstruction(0)) instanceof StreamInstruction && ((StreamInstruction)tie).getChildInstructionCount() == 0 && (LiteralInstruction.booleanTrueLiteral() == ti.getChildInstruction(1) || ti.getChildInstruction(1) instanceof IdentifierInstruction && ((IdentifierInstruction)handler).getBinding(benv) == this.m_hintBinding)) {
                onceTrueAlwaysTrueIdiom = true;
                il.loadVar(hint);
                il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
                il.beginIf();
            }
        }
        StreamType outStreamType = (StreamType)cgt.resolveType(this);
        FcgType outType = outStreamType.getFCGType(cgh);
        FcgType outElemType = outStreamType.getElementType().getFCGType(cgh);
        String iName = cgh.generateNewLocalVariableName();
        il.loadLiteral(0);
        FcgVariable i = il.defineVar(FcgType.INT, iName, true);
        il.loadVar(i);
        il.loadVar(source);
        il.unaryOperationExpr(FcgUnaryOp.LENGTH);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LT);
        il.preIncrementAndLoadLocalVariable(i);
        il.beginConditionalLoop(null, 2);
        if (onceFalseAlwaysFalseIdiom) {
            il.loadVar(hint);
            il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        } else if (onceTrueAlwaysTrueIdiom) {
            il.loadVar(hint);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        }
        String elementName = cgh.generateNewLocalVariableName();
        il.loadVar(source);
        il.loadVar(i);
        il.loadArrayElement(sourceElemType);
        FcgVariable element2 = il.defineVar(sourceElemType, elementName, true);
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        cgt2.registerExtantBinding(this.m_hintBinding, hintName);
        cgt2.registerExtantBinding(this.m_elementBinding, elementName);
        if (usesIndex) {
            cgt2.registerExtantBinding(this.m_indexBinding, indexName);
        }
        String retValName = cgh.generateNewLocalVariableName();
        FcgType retValType = this.m_body.generateCode(cgh, cgt2, null, tailPosition, il, ValueGenStyle.DEFAULT_NO_PUSH);
        FcgVariable retVal = il.defineVar(retValType, retValName, true);
        AbstractDataType adt = ((NamedType)this.m_stateADTType.resolveType(tenv)).resolveNameToADT(tenv);
        AbstractDataType.Constructor c = adt.m_constructors[0];
        il.loadVar(retVal);
        String fieldName = c.getConstructorQualifiedFieldName(1, cgh);
        il.loadInstanceField((FcgClassReferenceType)retValType, fieldName, hintType);
        il.storeVar(hint);
        if (usesIndex) {
            il.incrementVarStmt(index2);
        }
        il.loadVar(retVal);
        fieldName = c.getConstructorQualifiedFieldName(0, cgh);
        FcgType fcgTypeElement = il.loadInstanceField((FcgClassReferenceType)retValType, fieldName, outType);
        outStreamType.generateAddMultipleElementsToStream(cgh, cgt, il, streamName, outStreamType.getElementType(), fcgTypeElement);
        if (onceFalseAlwaysFalseIdiom || onceTrueAlwaysTrueIdiom) {
            il.endIf();
        }
        il.endConditionalLoop();
        if (this.m_wrapResult) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ProcessStreamInstruction i = new ProcessStreamInstruction(this.m_wrapResult, this.m_source.cloneWithoutTypeInformation(), this.m_hint.cloneWithoutTypeInformation(), this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body.cloneWithoutTypeInformation(), this.m_stateADTType);
        ProcessStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        ProcessStreamInstruction i = new ProcessStreamInstruction(this.m_wrapResult, this.m_source, this.m_hint, this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body, this.m_stateADTType);
        ProcessStreamInstruction.propagateInfo(this, i);
        return i;
    }

    public Instruction cloneAndRemoveTupleType(PolymorphicADTDesugarer td) {
        this.m_stateADTType = td.convertType(td.resolveType(this.m_body));
        return this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        benv2.setVariableBinding(this.m_elementBinding);
        Type hintType = this.m_hint.typeCheck(tenv, benv, functionStack);
        this.m_hintBinding = new Binding(this.m_hintBinding.getName(), hintType, tenv);
        benv2.setVariableBinding(this.m_hintBinding);
        if (this.m_indexBinding != null) {
            benv2.setVariableBinding(this.m_indexBinding);
        }
        tenv.unify(new StreamType(this.m_elementBinding.getBindingType()), this.m_source.typeCheck(tenv, benv, functionStack), this);
        Type bodyType = this.m_body.typeCheck(tenv, benv2, functionStack);
        TypeVariable tvar = new TypeVariable();
        StreamType resultType = new StreamType(tvar);
        if (this.m_stateADTType == null) {
            tenv.unify(bodyType, new TupleType(new Type[]{resultType, hintType}), this);
        } else {
            AbstractDataType adt = ((NamedType)this.m_stateADTType.resolveType(tenv)).resolveNameToADT(tenv);
            tenv.unify(adt.m_constructors[0].m_parameters[0].getBindingType(), resultType, this);
            tenv.unify(adt.m_constructors[0].m_parameters[1].getBindingType(), hintType, this);
            tenv.unify(bodyType, this.m_stateADTType, this);
        }
        return this.setCachedType(this.m_wrapResult ? bodyType : resultType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        AbstractDataType adt;
        AbstractDataType abstractDataType = adt = this.m_stateADTType == null ? null : ((NamedType)this.m_stateADTType.resolveType(tenv)).resolveNameToADT(tenv);
        return this.m_wrapResult ? this.m_stateADTType : (this.m_stateADTType == null ? ((TupleType)this.m_body.getType(tenv, benv).resolveType(tenv)).getElementTypes()[0] : adt.m_constructors[0].m_parameters[0].getBindingType());
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (this.m_stateADTType != null) {
            throw new UnsupportedOperationException("Cannot evaluate process-stream after tuple desugaring");
        }
        IForkReleaseManaged ans = null;
        IStream s = (IStream)this.m_source.evaluate(e, f2, di, false);
        Object hint = this.m_hint.evaluate(e, f2, di, false);
        TupleType tt = (TupleType)this.m_body.evaluateType(f2);
        Type elementType = tt.getChildType(0);
        Iterator<Object> i = s.iterator();
        ListStream result2 = new ListStream();
        e.pushIForkReleaseManagedForRelease(result2);
        int index2 = 0;
        while (i.hasNext()) {
            Object o = i.next();
            e.bindInCurrentFrame(this.m_elementBinding, o);
            e.bindInCurrentFrame(this.m_hintBinding, hint);
            if (this.m_indexBinding != null) {
                e.bindInCurrentFrame(this.m_indexBinding, index2);
                ++index2;
            }
            Tuple t = (Tuple)this.m_body.evaluate(e, f2, di, false);
            Object[] x = t.getValues();
            hint = x[1];
            result2.append(x[0], elementType);
        }
        ans = this.m_wrapResult ? new Tuple(new Object[]{result2, hint}, true) : result2;
        e.pushIForkReleaseManagedForRelease(ans);
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen("process-stream" + (this.m_indexBinding != null ? (this.m_wrapResult ? "-ic" : "-c") : (this.m_wrapResult ? "-i" : "")), indent);
        if (this.m_stateADTType != null) {
            pw.print("@" + this.m_stateADTType.prettyPrint());
        }
        this.m_source.toString(pw, indent + 1);
        this.m_hint.toString(pw, indent + 1);
        pw.printIdentifier(this.m_elementBinding, indent + 1);
        pw.printIdentifier(this.m_hintBinding, indent + 1);
        if (this.m_indexBinding != null) {
            pw.printIdentifier(this.m_indexBinding, indent + 1);
        }
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object s = ing.getNewName();
        names.put(this.m_elementBinding.getName(), new IdentifierInstruction(s));
        Object elementVar = s;
        s = ing.getNewName();
        names.put(this.m_hintBinding.getName(), new IdentifierInstruction(s));
        Object hintVar = s;
        Object indexVar = null;
        if (this.m_indexBinding != null) {
            s = ing.getNewName();
            names.put(this.m_indexBinding.getName(), new IdentifierInstruction(s));
            indexVar = s;
        }
        if (this.m_elementBinding.getName() instanceof TypeVariable) {
            return new ProcessStreamInstruction(this.m_wrapResult, this.m_source.assignNewNames(names, ing), this.m_hint.assignNewNames(names, ing), elementVar, hintVar, indexVar, this.m_body.assignNewNames(names, ing));
        }
        return new ProcessStreamInstruction(this.m_wrapResult, this.m_source.assignNewNames(names, ing), this.m_hint.assignNewNames(names, ing), elementVar, hintVar, indexVar, this.m_body.assignNewNames(names, ing), this.m_stateADTType);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_wrapResult = rofh.readBoolean();
        this.m_stateADTType = rofh.readType();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeBoolean(this.m_wrapResult);
        wofh.writeType(this.m_stateADTType);
    }

    public void setStateADTType(Type type2) {
        this.m_stateADTType = type2;
    }
}

