/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.IntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;

public class RangeInstruction
extends BinaryPrimopInstruction {
    private Type m_type;

    public RangeInstruction(Instruction op1, Instruction op2) {
        super(op1, op2);
    }

    public RangeInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        RangeInstruction i = new RangeInstruction(op1, op2);
        return i;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType streamType;
        FcgType elementType;
        if (this.m_type == IntegerType.s_integerType) {
            Type type2 = this.m_type = cgh.getSettings().getArbitraryPrecision() ? BigIntegerType.s_bigIntegerType : LongType.s_longType;
        }
        if (this.m_type == LongType.s_longType) {
            elementType = FcgType.LONG;
            streamType = FcgType.LONG_ARRAY;
        } else if (this.m_type == BigIntegerType.s_bigIntegerType) {
            elementType = FcgType.BIG_INTEGER;
            streamType = cgh.getArrayType(FcgType.BIG_INTEGER);
        } else {
            elementType = FcgType.INT;
            streamType = FcgType.INT_ARRAY;
        }
        String varName = cgh.generateNewLocalVariableName();
        String start = cgh.generateNewLocalVariableName();
        String stop = cgh.generateNewLocalVariableName();
        il.comment(" code generated from RangeInstruction, stored into " + varName);
        il.comment(" range start value, stored into " + start);
        cgt.generateConventionally(this.m_operand1, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable startVar = il.defineVar(elementType, start, true);
        il.comment(" range start value, stored into " + stop);
        cgt.generateConventionally(this.m_operand2, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable stopVar = il.defineVar(elementType, stop, true);
        FcgVariable var = il.defineVar(streamType, varName, false);
        il.loadVar(startVar);
        il.loadVar(stopVar);
        il.binaryOperationExpr(FcgBinOp.COMPARE_GT);
        il.beginIf();
        il.loadLiteral(0);
        il.createArrayExpr(elementType, false);
        il.storeVar(var);
        il.beginElse();
        il.loadVar(stopVar);
        il.loadVar(startVar);
        il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        il.loadLiteral(1);
        if (this.m_type == BigIntegerType.s_bigIntegerType) {
            il.convertExpr(FcgType.INT, FcgType.BIG_INTEGER);
        }
        il.binaryOperationExpr(FcgBinOp.PLUS);
        il.convertExpr(elementType, FcgType.INT);
        il.createArrayExpr(elementType, false);
        il.storeVar(var);
        String idxName = varName + "_index";
        il.loadVar(startVar);
        FcgVariable idx = il.defineVar(elementType, idxName, true);
        il.loadVar(idx);
        il.loadVar(stopVar);
        il.binaryOperationExpr(FcgBinOp.COMPARE_LTE);
        il.preIncrementAndLoadLocalVariable(idx);
        il.beginConditionalLoop(null, 2);
        il.loadVar(var);
        il.loadVar(idx);
        il.loadVar(startVar);
        il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        il.convertExpr(elementType, FcgType.INT);
        il.loadVar(idx);
        il.storeArrayElemStmt();
        il.endConditionalLoop();
        il.endIf();
        il.loadVar(var);
        return streamType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        RangeInstruction i = new RangeInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        RangeInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand1.getType(tenv, benv).getStreamType();
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t1 = this.m_operand1.typeCheck(tenv, benv, functionStack);
        tenv.unify(t1, this.m_operand2.typeCheck(tenv, benv, functionStack), this);
        try {
            tenv.unify(t1, IntegerType.s_integerType, this);
        }
        catch (TypeCheckException e1) {
            try {
                tenv.unify(t1, LongType.s_longType, this);
            }
            catch (TypeCheckException e2) {
                try {
                    tenv.unify(t1, BigIntegerType.s_bigIntegerType, this);
                }
                catch (TypeCheckException e3) {
                    tenv.unify(t1, IntType.s_intType, this);
                }
            }
        }
        this.m_type = t1;
        return this.setCachedType(t1.getStreamType());
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.m_type = this.m_operand1.getType(tenv, benv);
        this.clearLocalForTypecheckReduced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        e.pushForkScope();
        ListStream ans = null;
        try {
            Number start = (Number)this.m_operand1.evaluate(e, f2, di, false);
            Number stop = (Number)this.m_operand2.evaluate(e, f2, di, false);
            ListStream ls = new ListStream();
            e.pushIForkReleaseManagedForRelease(ls);
            if (this.m_type == IntegerType.s_integerType) {
                Type type2 = this.m_type = e.getArbitraryPrecision() ? BigIntegerType.s_bigIntegerType : LongType.s_longType;
            }
            if (this.m_type == LongType.s_longType) {
                for (long i = start.longValue(); i <= stop.longValue(); ++i) {
                    ls.append(new Long(i), this.m_type);
                }
            } else if (this.m_type == BigIntegerType.s_bigIntegerType) {
                BigInteger i = (BigInteger)start;
                BigInteger bStop = (BigInteger)stop;
                BigInteger increment = BigInteger.ONE;
                while (i.compareTo(bStop) <= 0) {
                    ls.append(i, this.m_type);
                    i = i.add(increment);
                }
            } else {
                for (int i = start.intValue(); i <= stop.intValue(); ++i) {
                    ls.append(new Integer(i), this.m_type);
                }
            }
            ans = ls;
            e.popForkScope((Object)ans);
        }
        catch (Throwable throwable) {
            e.popForkScope((Object)ans);
            throw throwable;
        }
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public String innerToString() {
        return "range";
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_type = rofh.readType();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_type);
    }
}

