/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class ReadFieldInstruction
extends UnaryPrimopInstruction {
    protected String m_fieldName;

    public ReadFieldInstruction() {
    }

    public ReadFieldInstruction(Instruction object2, String fieldName) {
        super(object2);
        this.m_fieldName = fieldName;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        Type t = this.getType(tenv, cgt.m_bindingEnvironment);
        FcgType fcgFieldType = cgt.getResolvedType(cg, t);
        FcgClassReferenceType objectType = (FcgClassReferenceType)cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        il.loadInstanceField(objectType, this.m_fieldName, fcgFieldType);
        return fcgFieldType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadFieldInstruction i = new ReadFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
        ReadFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1) {
        ReadFieldInstruction i = new ReadFieldInstruction(op1, this.m_fieldName);
        ReadFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand.typeCheck(tenv, benv, functionStack);
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(t instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Field b = jot.resolveField(this.m_fieldName, tenv);
        if (b == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot.getName() + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(b.getType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_operand.getType(tenv, benv);
        t = t.resolveType(tenv);
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Field b = jot.resolveField(this.m_fieldName, tenv);
        return b.getType();
    }

    @Override
    public String innerToString() {
        return "get-field!";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_fieldName.toString();
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_fieldName = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_fieldName);
    }
}

