/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class ReadJavaFieldInstruction
extends UnaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public ReadJavaFieldInstruction() {
    }

    public ReadJavaFieldInstruction(Instruction object2, String fieldName) {
        super(object2);
        this.m_fieldName = fieldName;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        Type typeIn = this.getType(tenv, cgt.m_bindingEnvironment);
        FcgType fcgType = cgt.getResolvedType(cg, typeIn);
        FcgClassReferenceType fcgType2 = (FcgClassReferenceType)cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        il.loadInstanceField(fcgType2, this.m_fieldName, fcgType);
        return fcgType;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object obj = this.m_operand.evaluate(e, f2, di, false);
        try {
            Field field = obj.getClass().getField(this.m_fieldName);
            Object ans = field.get(obj);
            return Debugger.leave(di, this, e, f2, ans);
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (IllegalArgumentException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (NoSuchFieldException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadJavaFieldInstruction i = new ReadJavaFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
        ReadJavaFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1) {
        ReadJavaFieldInstruction i = new ReadJavaFieldInstruction(op1, this.m_fieldName);
        ReadJavaFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand.typeCheck(tenv, benv, functionStack);
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(t instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        JavaObjectType jot = (JavaObjectType)t;
        JavaClassInformation.Field f2 = jot.getInformation(tenv.getModule()).getField(this.m_fieldName);
        if (f2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(f2.getType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_operand.getType(tenv, benv);
        t = t.resolveType(tenv);
        JavaObjectType jot = (JavaObjectType)t;
        JavaClassInformation.Field f2 = jot.getInformation(tenv.getModule()).getField(this.m_fieldName);
        return f2.getType();
    }

    @Override
    public String innerToString() {
        return "read-java-field!";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_fieldName;
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_fieldName);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_fieldName = rofh.readString();
    }
}

