/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.MemoryType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;

public class ReadMemoryInstruction
extends BinaryPrimopInstruction {
    protected Type m_type;
    private static Object s_unsafe;
    private static Method sm_unsafeGetUnsafeInt;
    private static Method sm_unsafeGetUnsafeShort;
    private static Method sm_unsafeGetUnsafeLong;
    private static Method sm_unsafeGetUnsafeFloat;
    private static Method sm_unsafeGetUnsafeDouble;
    private static Method sm_unsafeGetUnsafeByte;
    private static Method sm_unsafeGetUnsafeChar;

    public ReadMemoryInstruction() {
    }

    public void setType(Type t) {
        this.m_type = t;
    }

    public ReadMemoryInstruction(Instruction base2, Instruction offset, Type type2) {
        super(base2, offset);
        this.setCachedType(type2);
        this.m_type = type2;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_type;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        ReadMemoryInstruction i = new ReadMemoryInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation(), this.m_type);
        ReadMemoryInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.m_operand1.typeCheck(tenv, benv, functionStack), MemoryType.s_memoryType, this);
        tenv.unify(this.m_operand2.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        return this.m_type;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_type : null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_type = n2;
        }
    }

    @Override
    public String innerToString() {
        return "read-memory";
    }

    @Override
    protected Type getTypeForTypeAnnotationPrettyPrint() {
        Type t = this.getCachedType();
        if (t == null) {
            t = this.m_type;
        }
        return t;
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_type.prettyPrint();
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand1, Instruction operand2) {
        return new ReadMemoryInstruction(operand1, operand2, this.m_type);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Constable ans;
        block14: {
            if (null != di) {
                di.enter(this, e, f2);
            }
            Long base2 = (Long)this.m_operand1.evaluate(e, f2, di, false);
            Integer offset = (Integer)this.m_operand2.evaluate(e, f2, di, false);
            ans = null;
            try {
                if (s_unsafe == null) {
                    Class<?> unsafeclass = Class.forName("sun.misc.Unsafe");
                    Method unsafeGetUnsafe = unsafeclass.getMethod("getUnsafe", new Class[0]);
                    s_unsafe = unsafeGetUnsafe.invoke(null, new Object[0]);
                    Class<?> us = s_unsafe.getClass();
                    Class[] arg2 = new Class[]{Long.class};
                    sm_unsafeGetUnsafeInt = us.getMethod("getInt", arg2);
                    sm_unsafeGetUnsafeShort = us.getMethod("getShort", arg2);
                    sm_unsafeGetUnsafeLong = us.getMethod("getLong", arg2);
                    sm_unsafeGetUnsafeByte = us.getMethod("getByte", arg2);
                    sm_unsafeGetUnsafeChar = us.getMethod("getChar", arg2);
                    sm_unsafeGetUnsafeFloat = us.getMethod("getFloat", arg2);
                    sm_unsafeGetUnsafeDouble = us.getMethod("getDouble", arg2);
                }
                if (this.m_type.equals(IntType.s_intType)) {
                    ans = (Integer)sm_unsafeGetUnsafeInt.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(LongType.s_longType)) {
                    ans = (Long)sm_unsafeGetUnsafeLong.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(ShortType.s_shortType)) {
                    ans = (Short)sm_unsafeGetUnsafeShort.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(CharType.s_charType)) {
                    ans = (Character)sm_unsafeGetUnsafeChar.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(DoubleType.s_doubleType)) {
                    ans = (Double)sm_unsafeGetUnsafeDouble.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(FloatType.s_floatType)) {
                    ans = (Float)sm_unsafeGetUnsafeFloat.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                if (this.m_type.equals(ByteType.s_byteType)) {
                    ans = (Byte)sm_unsafeGetUnsafeByte.invoke(s_unsafe, new Long(base2 + (long)offset.intValue()));
                    break block14;
                }
                throw new UnsupportedOperationException();
            }
            catch (ClassNotFoundException exc) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + exc);
            }
            catch (NoSuchMethodException exc) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + exc);
            }
            catch (InvocationTargetException exc) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + exc);
            }
            catch (IllegalAccessException exc) {
                throw new XylemError("ERR_SYSTEM", "ReadMemoryInstruction evaluation failed, requires JVM 1.4, " + exc);
            }
        }
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public void replaceTypeVariables(Map typeMap) {
        super.replaceTypeVariables(typeMap);
        this.m_type = this.m_type.replaceType(typeMap);
        this.setCachedType(this.m_type);
    }

    @Override
    public boolean equals(Object arg0) {
        return super.equals(arg0) && ((ReadMemoryInstruction)arg0).m_type.equals(this.m_type);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        super.generateReducedForm(rh, state, benv);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_type = rofh.readType();
        this.setCachedType(this.m_type);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_type);
    }
}

