/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import java.math.BigDecimal;
import java.util.LinkedList;

public class RoundInstruction
extends UnaryPrimopInstruction {
    public RoundInstruction(Instruction parameter) {
        super(parameter);
    }

    public RoundInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        RoundInstruction i = new RoundInstruction(this.m_operand.cloneWithoutTypeInformation());
        RoundInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.m_operand.typeCheck(tenv, benv, functionStack));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand.getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_operand.getPreTypecheckType(msig);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType retType;
        FcgType opType = cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        Type t = cgt.resolveType(this);
        if (t.equals(IntType.s_intType) || t.equals(LongType.s_longType) || t.equals(BigIntegerType.s_bigIntegerType)) {
            retType = opType;
        } else if (t.equals(FloatType.s_floatType) || t.equals(DoubleType.s_doubleType) || t.equals(DecimalType.s_decimalType)) {
            retType = il.unaryOperationExpr(FcgUnaryOp.ROUND);
            retType = il.convertExpr(retType, t.getFCGType(cg));
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + t);
        }
        return retType;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen("round", indent);
        this.m_operand.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Type t = this.m_operand.evaluateType(f2);
        Object x = this.m_operand.evaluate(e, f2, di, false);
        Object ans = null;
        if (t.equals(IntType.s_intType) || t.equals(LongType.s_longType)) {
            ans = x;
        } else if (t.equals(FloatType.s_floatType)) {
            ans = new Float(Math.round(((Number)x).floatValue()));
        } else if (t.equals(DoubleType.s_doubleType)) {
            ans = new Double(Math.round(((Number)x).doubleValue()));
        } else if (t.equals(BigIntegerType.s_bigIntegerType) || t.equals(DecimalType.s_decimalType)) {
            ans = new BigDecimal(Math.round(((Number)x).doubleValue()));
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + t);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        RoundInstruction i = new RoundInstruction(operand2);
        RoundInstruction.propagateInfo(this, i);
        return i;
    }
}

