/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.Slot;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import java.io.IOException;
import java.util.LinkedList;

public class SetFieldInstruction
extends BinaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public SetFieldInstruction() {
    }

    public SetFieldInstruction(Instruction object2, String fieldName, Instruction value2) {
        super(object2, value2);
        this.m_fieldName = fieldName;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
        FcgType fieldType = cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.DEFAULT);
        il.storeInstanceFieldStmt(null, this.m_fieldName, fieldType);
        return null;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        SetFieldInstruction i = new SetFieldInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_fieldName, this.m_operand2.cloneWithoutTypeInformation());
        SetFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new SetFieldInstruction(op1, this.m_fieldName, op2);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand1.typeCheck(tenv, benv, functionStack);
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand1), this);
        }
        if (!(t instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand1 + " is not an object; it's a " + t.prettyPrint()), this);
        }
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Field b = jot.resolveField(this.m_fieldName, tenv);
        if (b == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot.getName() + " does not contain field " + this.m_fieldName), this);
        }
        if (!b.isMutable()) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Field " + this.m_fieldName + " of class " + jot.getName() + " is not mutable"), this);
        }
        t = this.m_operand2.typeCheck(tenv, benv, functionStack);
        tenv.unify(b.getType(), t, this);
        return this.setCachedType(UnitType.s_unitType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return UnitType.s_unitType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return UnitType.s_unitType;
    }

    @Override
    public String innerToString() {
        return "set-field!";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_fieldName;
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Slot slot = (Slot)this.m_operand1.evaluate(e, f2, di, false);
        Object value2 = this.m_operand2.evaluate(e, f2, di, false);
        slot.setValue(value2);
        Object ans = value2;
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_fieldName = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_fieldName);
    }
}

