/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class SetJavaFieldInstruction
extends BinaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public SetJavaFieldInstruction() {
    }

    public SetJavaFieldInstruction(Instruction object2, String fieldName, Instruction newValue) {
        super(object2, newValue);
        this.m_fieldName = fieldName;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object obj = this.m_operand1.evaluate(e, f2, di, false);
        Object newVal = this.m_operand2.evaluate(e, f2, di, false);
        try {
            Field field = obj.getClass().getField(this.m_fieldName);
            field.set(obj, newVal);
            return Debugger.leave(di, this, e, f2, newVal);
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (IllegalArgumentException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (NoSuchFieldException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        SetJavaFieldInstruction i = new SetJavaFieldInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_fieldName, this.m_operand2.cloneWithoutTypeInformation());
        SetJavaFieldInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new SetJavaFieldInstruction(op1, this.m_fieldName, op2);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand1.typeCheck(tenv, benv, functionStack);
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand1), this);
        }
        if (!(t instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand1 + " is not an object"), this);
        }
        JavaObjectType jot = (JavaObjectType)t;
        JavaClassInformation.Field f2 = jot.getInformation(tenv.getModule()).getField(this.m_fieldName);
        if (f2 == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot + " does not contain field " + this.m_fieldName), this);
        }
        tenv.unify(f2.getType(), this.m_operand2.typeCheck(tenv, benv, functionStack), this);
        return this.setCachedType(f2.getType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand2.getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_operand2.getPreTypecheckType(msig);
    }

    @Override
    public String innerToString() {
        return "set-java-field!";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_fieldName;
    }

    @Override
    public boolean equals(Object arg0) {
        return this == arg0;
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_fieldName);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_fieldName = rofh.readString();
    }
}

