/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;

public class StaticMemberInstruction
extends Instruction {
    protected String m_className;
    protected String m_fieldName;

    public StaticMemberInstruction() {
    }

    public StaticMemberInstruction(String clazz, String field) {
        this(clazz, field, null);
    }

    public StaticMemberInstruction(String clazz, String field, Type t) {
        this.m_className = clazz;
        this.m_fieldName = field;
        if (t != null) {
            this.setCachedType(t);
        }
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.computeType(tenv.getModule()));
    }

    Type computeType(Module m) {
        JavaObjectType jot = new JavaObjectType(this.m_className);
        JavaClassInformation info = jot.getInformation(m);
        JavaClassInformation.Field f2 = info.getField(this.m_fieldName);
        return f2.getType();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        super.typeCheckReduced(tenv, benv, functionStack);
        if (this.getCachedType() == null) {
            this.setCachedType(this.computeType(tenv.getModule()));
        }
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.getCachedType();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        JavaObjectType type2 = new JavaObjectType(this.m_className);
        FcgClassReferenceType classType = (FcgClassReferenceType)type2.getFCGType(cgh);
        Type typeIn = this.getCachedType();
        FcgType fcgFieldType = cgt.getResolvedType(cgh, typeIn);
        il.loadClassField(classType, this.m_fieldName, fcgFieldType);
        return fcgFieldType;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        try {
            return ObjectFactory.findProviderClass(this.m_className, ObjectFactory.findClassLoader(), true).getDeclaredField(this.m_fieldName).get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        StaticMemberInstruction i = new StaticMemberInstruction(this.m_className, this.m_fieldName);
        StaticMemberInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        StaticMemberInstruction i = new StaticMemberInstruction(this.m_className, this.m_fieldName, this.getCachedType());
        StaticMemberInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        state[0] = this;
    }

    @Override
    public String innerToString() {
        return "java-static-field-ref";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return "\"" + this.m_className + "\" \"" + this.m_fieldName + "\"";
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_className = rofh.readString();
        this.m_fieldName = rofh.readString();
        Type t = rofh.readType();
        if (t == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        this.setCachedType(t);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_className);
        wofh.writeString(this.m_fieldName);
        if (this.getCachedType() == null) {
            throw new XylemError("ERR_SYSTEM", "null type");
        }
        wofh.writeType(this.getCachedType());
    }
}

