/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgTypeUtils;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(StaticMethodInvocationInstruction.class);
    private static final String s_className = StaticMethodInvocationInstruction.class.getName();
    protected String m_function;
    protected String m_class;
    protected Type m_type;
    protected boolean m_isUserClass;

    public StaticMethodInvocationInstruction() {
    }

    public StaticMethodInvocationInstruction(String method, Instruction[] parameters, Type t) {
        this(method, parameters, t, false);
    }

    public StaticMethodInvocationInstruction(String method, Instruction[] parameters, Type t, boolean isUserClass) {
        super(parameters);
        this.m_function = method;
        if (t == null) {
            t = new TypeVariable();
        }
        this.setCachedType(t);
        this.m_type = t;
        this.m_class = null;
        this.m_isUserClass = isUserClass;
    }

    @Override
    public Type getTypeParameter(int i) {
        if (i == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_type = n2;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    public StaticMethodInvocationInstruction(String prefix2, String method, Instruction[] parameters, Type t) {
        this(prefix2, method, parameters, t, false);
    }

    public StaticMethodInvocationInstruction(String prefix2, String method, Instruction[] parameters, Type t, boolean isUserClass) {
        super(parameters);
        this.m_function = method;
        if (t == null) {
            t = new TypeVariable();
        }
        this.setCachedType(t);
        this.m_type = t;
        this.m_class = prefix2;
        if ("com.ibm.xltxe.rnm1.xylem.commandline.SparseStreamPopulator".equals(this.m_class)) {
            this.m_type = JavaObjectType.s_javaObjectType.getStreamType();
        }
        this.m_isUserClass = isUserClass;
    }

    public String getFunction() {
        return this.m_function;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_type;
    }

    public void setFunction(String n2) {
        this.m_function = n2;
    }

    public void setIsUserClass(boolean val) {
        this.m_isUserClass = val;
    }

    public boolean getIsUserClass() {
        return this.m_isUserClass;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        StaticMethodInvocationInstruction i = new StaticMethodInvocationInstruction(this.m_class, this.m_function, parameters, this.m_type, this.m_isUserClass);
        StaticMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        StaticMethodInvocationInstruction i = new StaticMethodInvocationInstruction(this.m_class, this.m_function, parameters, this.m_type, this.m_isUserClass);
        StaticMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "static-method-invoke";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return (this.m_class == null || this.m_class.length() == 0 ? "" : this.m_class + ".") + this.m_function;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        Type type2 = this.getType(tenv, cgt.m_bindingEnvironment);
        FcgType fcgType = type2.equals(UnitType.s_unitType) ? FcgType.VOID : type2.getFCGType(cgh);
        SessionContext session = cgt.getSessionContext();
        BasicDynamicContext dynamicContext = new BasicDynamicContext(session);
        Environment e = new Environment(dynamicContext);
        CodeGenerationSettings cgs = cgh.getSettings();
        e.setArbitraryPrecision(cgs.getArbitraryPrecision());
        e.setOverflowDetection(cgs.getOverflowDetection());
        Method m = this.resolveMethod(e, cgh.getCurrentFunctionAsFunction(), null, false);
        e.release(null);
        Class<?>[] types2 = m.getParameterTypes();
        FcgType[] paramTypes = new FcgType[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            FcgType fcgTypeParam = cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.DEFAULT);
            paramTypes[i] = FcgTypeUtils.getFcgType(cgh, types2[i]);
            if (fcgTypeParam.equals(paramTypes[i])) continue;
            il.convertExpr(fcgTypeParam, paramTypes[i]);
        }
        FcgClassReferenceType theClass = cgh.getClassReferenceType(m.getDeclaringClass().getName());
        il.invokeClassMethod(theClass, m.getName(), fcgType, paramTypes);
        return fcgType;
    }

    public String getClassName() {
        if (this.m_class == null) {
            int lastDot = this.m_function.lastIndexOf(46);
            if (lastDot == -1 || lastDot + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(0, lastDot);
        }
        return this.m_class;
    }

    public String getMethodName() {
        if (this.m_class == null) {
            int lastDot = this.m_function.lastIndexOf(46);
            if (lastDot == -1 || lastDot + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(lastDot + 1, this.m_function.length());
        }
        return this.m_function;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object object2;
        if (null != di) {
            di.enter(this, e, f2);
        }
        e.pushForkScope();
        Object ans = null;
        try {
            String className = this.getClassName();
            Object obj = e == null ? null : e.m_statics.get(className);
            Object[] args = new Object[this.m_parameters.length];
            Type[] argTypes = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                Instruction param = this.m_parameters[i];
                Type t = param.evaluateType(f2);
                Object arg2 = param.evaluate(e, f2, di, false);
                if (arg2 instanceof IConvertible) {
                    arg2 = ((IConvertible)arg2).convert(e, t);
                }
                args[i] = arg2;
                argTypes[i] = t;
            }
            Method m = this.resolveMethod(e, f2, di, tailPosition, argTypes);
            Object ret = m.invoke(obj, args);
            Type type2 = this.evaluateType(f2);
            ans = type2.wrapForInterpreter(ret, e);
            object2 = Debugger.leave(di, this, e, f2, ans);
        }
        catch (InvocationTargetException ee) {
            try {
                RuntimeException exception;
                Throwable target = ee.getTargetException();
                if (target instanceof RuntimeException) {
                    exception = (RuntimeException)target;
                    throw exception;
                }
                exception = new RuntimeException(target);
                throw exception;
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception ee2) {
                    throw new RuntimeException(ee2);
                }
            }
            catch (Throwable throwable) {
                e.popForkScope(ans);
                throw throwable;
            }
        }
        e.popForkScope(ans);
        return object2;
    }

    private Type[] getArgTypes(Environment e, Function f2) {
        Type[] argTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            argTypes[i] = this.m_parameters[i].evaluateType(f2);
        }
        return argTypes;
    }

    private Class[] getJavaArgTypes(Environment e, Type[] argTypes) {
        Class[] javaArgTypes = new Class[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            javaArgTypes[i] = argTypes[i].getJavaType(e);
        }
        return javaArgTypes;
    }

    private Method resolveMethod(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition, Type[] argTypes) {
        String className = this.getClassName();
        String methodName = this.getMethodName();
        Object obj = e == null ? null : e.m_statics.get(className);
        Class c = null;
        if (obj == null) {
            ClassLoader classLoader = this.m_isUserClass ? ObjectFactory.findClassLoader() : Module.class.getClassLoader();
            while (c == null) {
                try {
                    c = ObjectFactory.findProviderClass(className, classLoader, true);
                }
                catch (ClassNotFoundException ex) {
                    int index2 = className.lastIndexOf(46);
                    if (index2 != -1) {
                        className = className.substring(0, index2) + "$" + className.substring(index2 + 1, className.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
                }
            }
        } else {
            c = obj.getClass();
        }
        try {
            Method m = InterpreterUtilities.getMethod(c, this.getMethodName(), this.getJavaArgTypes(e, argTypes));
            return m;
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
    }

    private Method resolveMethod(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        return this.resolveMethod(e, f2, di, tailPosition, this.getArgTypes(e, f2));
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        StaticMethodInvocationInstruction mii = (StaticMethodInvocationInstruction)arg0;
        return mii.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        this.doDefaultTypeCheck(tenv, benv, functionStack);
        this.typeCheckChildren(tenv, benv, functionStack);
        try {
            JavaClassInformation info = JavaClassImporter.retrieveJavaClassInformation(this.getClassName(), tenv.getModule(), this.m_isUserClass);
            String funcname = this.m_function.startsWith(this.getClassName()) ? this.m_function.substring(this.getClassName().length() + 1) : this.m_function;
            Collection methods = info.getStaticMethods(funcname);
            for (JavaClassInformation.Method m : methods) {
                Type[] types2 = m.getParameterTypes();
                if (types2.length != this.m_parameters.length) continue;
                boolean unifySucceeded = this.checkParameterTypes(tenv, types2, m, null);
                if (!unifySucceeded) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                    StringBuilder problem = new StringBuilder();
                    this.checkParameterTypes(tenv, types2, m, problem);
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Method did not match.  reason: " + problem);
                    continue;
                }
                break;
            }
        }
        catch (Exception exn) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Cannot retrieve information for class " + this.getClassName() + " and method " + this.m_function});
            s_logger.logp(Level.WARNING, s_className, "typeCheck", message, exn);
        }
        return this.setCachedType(this.m_type);
    }

    private boolean checkParameterTypes(TypeEnvironment tenv, Type[] types2, JavaClassInformation.Method m, StringBuilder problem) throws TypeCheckException {
        int j;
        boolean unifySucceeded = true;
        TypeEnvironment tenv2 = tenv.copy();
        for (j = 0; unifySucceeded && j < types2.length; ++j) {
            unifySucceeded = tenv2.unifyQuietly(types2[j], this.m_parameters[j].getCachedType(), this, problem);
        }
        for (j = 0; unifySucceeded && j < types2.length; ++j) {
            tenv.unify(types2[j], this.m_parameters[j].getCachedType(), this);
        }
        tenv.unifyQuietly(m.getReturnType(), this.m_type, this, problem);
        return unifySucceeded;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_type = rofh.readType();
        this.setCachedType(this.m_type);
        this.m_function = rofh.readString();
        boolean b = rofh.readBoolean();
        if (b) {
            this.m_class = rofh.readString();
        }
        this.m_isUserClass = rofh.readBoolean();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_type);
        wofh.writeString(this.m_function);
        wofh.writeBoolean(this.m_class != null);
        if (this.m_class != null) {
            wofh.writeString(this.m_class);
        }
        wofh.writeBoolean(this.m_isUserClass);
    }
}

