/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import java.util.LinkedList;

public class StreamElementInstruction
extends BinaryPrimopInstruction {
    protected Type m_elementType;

    public StreamElementInstruction() {
    }

    public StreamElementInstruction(Instruction source, Instruction index2) {
        super(source, index2);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_elementType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_elementType;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        super.generateReducedForm(rh, state, benv);
        this.setupType(rh.m_typeEnvironment, benv);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        super.typeCheckReduced(tenv, benv, functionStack);
        this.setupType(tenv, benv);
    }

    protected void setupType(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_operand1.getType(tenv, benv);
        if (t instanceof StreamType) {
            this.m_elementType = ((StreamType)t).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
            try {
                tenv.unify(this.m_elementType.getStreamType(), this.m_operand1.getType(tenv, benv), this);
            }
            catch (TypeCheckException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        StreamElementInstruction i = new StreamElementInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
        StreamElementInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        TypeVariable tv = new TypeVariable();
        tenv.unify(this.m_operand1.typeCheck(tenv, benv, functionStack), tv.getStreamType(), this);
        tenv.unify(this.m_operand2.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        return this.setCachedType(tv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_operand1, cg, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_operand2, cg, false, il, ValueGenStyle.INT);
        Type t = cgt.resolveType(this);
        FcgType elemType = t.getFCGType(cg);
        FcgType typeRet = il.loadArrayElement(elemType);
        if (t.isForkReleaseManaged(cgt)) {
            t.generateObjectFork(cg, il, cgt, ValueGenStyle.DEFAULT_WITH_PUSH);
        }
        return typeRet;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        Object o1 = this.m_operand1.evaluate(e, f2, di, false);
        IStream source = (IStream)o1;
        Object o2 = this.m_operand2.evaluate(e, f2, di, false);
        Integer index2 = (Integer)o2;
        int i = index2;
        ans = source.get(i);
        ans = XCIConstruction.evalForkIfNeeded(ans, e);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public String innerToString() {
        return "stream-element";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new StreamElementInstruction(op1, op2);
    }
}

