/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FcgXmlType;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstantGenerator;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.TagStream;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StreamInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IMatchDestructable {
    protected Type m_elementType;
    protected Instruction[] m_elements;
    protected String m_string;
    public static final int s_runs = 2;
    private StreamType s_charStreamType = CharType.s_charType.getStreamType();

    public StreamInstruction() {
    }

    public StreamInstruction(Type type2, Instruction[] elements2) {
        if (type2 instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't stream a stream type");
        }
        this.m_elementType = type2;
        this.setElements(elements2);
        this.getStringContent();
    }

    public StreamInstruction(Type type2, List elements2) {
        if (type2 instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't stream a stream type");
        }
        this.m_elementType = type2;
        this.setElements(new Instruction[elements2.size()]);
        elements2.toArray(this.m_elements);
        this.getStringContent();
    }

    public StreamInstruction(Type type2, Instruction element2) {
        this(type2, new Instruction[]{element2});
    }

    public StreamInstruction(Type type2) {
        this(type2, new Instruction[0]);
    }

    public StreamInstruction(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        this.m_string = s;
        this.m_elementType = CharType.s_charType;
    }

    public Instruction[] getElements() {
        return this.m_elements;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    public boolean isStoredAsString() {
        return this.m_elements == null;
    }

    public boolean isString() {
        this.getStringContent();
        return this.m_elements == null;
    }

    public void setElementType(Type t) {
        this.m_elementType = t;
    }

    @Override
    public void accumulateFunctionsCalled(Set<String> set2) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFunctionsCalled(set2);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFreeBindings(set2, benv);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateNonLiteralFreeBindings(set2, benv);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        if (this.m_elements != null) {
            Type elementType = this.m_elementType.resolveTypeAsMuchAsPossible(tenv, new HashSet());
            boolean elementTypeIsVar = elementType instanceof TypeVariable;
            for (int i = 0; i < this.m_elements.length; ++i) {
                Type t2;
                Type t = this.m_elements[i].typeCheck(tenv, benv, functionStack);
                if (!elementTypeIsVar || (t2 = t.resolveTypeAsMuchAsPossible(tenv, new HashSet())) instanceof TypeVariable) continue;
                if (t2 instanceof StreamType) {
                    tenv.unify(elementType, ((StreamType)t2).getElementType(), this);
                    continue;
                }
                tenv.unify(elementType, t2, this);
            }
        }
        return this.setCachedType(this.m_elementType.getStreamType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_elementType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return null != this.m_elementType ? this.m_elementType.getStreamType() : super.getPreTypecheckType(msig);
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_elements == null ? this.m_string.length() : this.m_elements.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_elements == null) {
            LiteralInstruction li = LiteralInstruction.charLiteral(this.m_string.charAt(i));
            return li;
        }
        return this.m_elements[i];
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_elements == null) {
            this.convertStringToArray();
        }
        this.m_elements[i] = n2;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_elementType : null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_elementType = n2;
        }
    }

    protected void convertStringToArray() {
        if (this.m_elements == null) {
            this.m_elements = new Instruction[this.m_string.length()];
            for (int j = 0; j < this.m_string.length(); ++j) {
                LiteralInstruction li = LiteralInstruction.charLiteral(this.m_string.charAt(j));
                try {
                    li.typeCheck(null, this.m_bindingEnvironment, new LinkedList());
                }
                catch (TypeCheckException e) {
                    throw new RuntimeException(e);
                }
                this.m_elements[j] = li;
            }
            this.m_string = null;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        Instruction[] elements2 = new Instruction[this.m_elements.length];
        for (int i = 0; i < this.m_elements.length; ++i) {
            elements2[i] = this.m_elements[i].cloneWithoutTypeInformation();
        }
        StreamInstruction i = new StreamInstruction(this.m_elementType, elements2);
        StreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        if (this.m_string != null) {
            StreamInstruction i = new StreamInstruction(this.m_string);
            StreamInstruction.propagateInfo(this, i);
            return i;
        }
        Instruction[] elements2 = (Instruction[])this.m_elements.clone();
        StreamInstruction i = new StreamInstruction(this.m_elementType, elements2);
        StreamInstruction.propagateInfo(this, i);
        return i;
    }

    public String generateEscapedStringValue() {
        return LiteralInstruction.escape(this.getStringContent());
    }

    protected FcgType makeConstant(FcgCodeGenHelper cgh, FcgInstructionList il, CodeGenerationTracker cgt, String key2) {
        FcgType retVal;
        Type elementType = this.m_elementType.resolveType(cgt.m_typeEnvironment);
        Instruction[] elements2 = this.m_elements;
        boolean start = false;
        int length2 = elements2.length;
        boolean allLiterals = true;
        for (int i = 0; i < length2; ++i) {
            if (elements2[0 + i] instanceof LiteralInstruction) continue;
            allLiterals = false;
            break;
        }
        if (allLiterals && elementType.equals(CharType.s_charType)) {
            FcgInstructionList il2 = cgh.startConstantGeneration();
            FcgClassReferenceType stringType = (FcgClassReferenceType)il2.loadLiteral(this.getStringContent());
            il2.invokeInstanceMethod(stringType, "toCharArray", (FcgType)FcgType.CHAR_ARRAY, 0);
            cgh.finishConstantGeneration(key2, FcgType.CHAR_ARRAY, il);
            retVal = FcgType.CHAR_ARRAY;
        } else {
            FcgType elementFcgType = elementType.getFCGType(cgh);
            FcgInstructionList il2 = cgh.startConstantGeneration();
            for (int i = 0; i < length2; ++i) {
                elements2[0 + i].generateCode(cgh, cgt, key2 + "_" + i, false, il2, ValueGenStyle.DEFAULT_NO_PUSH);
            }
            il2.loadLiteral(length2);
            retVal = il2.createArrayExpr(elementFcgType, true);
            cgh.finishConstantGeneration(key2, retVal, il);
        }
        return retVal;
    }

    public static StreamInstruction charStreamLiteral(String s) {
        return new StreamInstruction(s);
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        if (this.m_elements == null) {
            return true;
        }
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (this.m_elements[i] instanceof LiteralInstruction) continue;
            return false;
        }
        return true;
    }

    public static final FcgType insertCharStreamConstant(String s, FcgCodeGenHelper cgh, FcgInstructionList il) {
        String key2 = "char[]/" + s;
        if (!cgh.insertConstant(key2, FcgType.CHAR_ARRAY, il)) {
            FcgInstructionList il2 = cgh.startConstantGeneration();
            il2.loadLiteral(s);
            il2.convertExpr(FcgType.STRING, FcgType.CHAR_ARRAY);
            cgh.finishConstantGeneration(key2, FcgType.CHAR_ARRAY, il);
        }
        return FcgType.CHAR_ARRAY;
    }

    private static void genConstant(String s, FcgInstructionList il2) {
        il2.loadLiteral(s);
        FcgType[] argTypes = new FcgType[]{FcgType.CHARSEQUENCE};
        il2.invokeClassMethod(FcgCodeGenHelper.BASIS2LIBRARY, "constructCharsFromCharSequence", (FcgType)FcgXmlType.CHARS, argTypes);
    }

    public static final FcgType insertCharStreamConstant(String s, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        ConstantGenerator.StringConstantGenerator constantGen = ConstantGenerator.StringConstantGenerator.get(valueStyleRequest);
        if (constantGen != null) {
            FcgType fcgType = valueStyleRequest.getFcgType();
            String keyBaseString = fcgType.getTypeName();
            String key2 = keyBaseString + "/" + s;
            if (!cgh.insertConstant(key2, fcgType, il)) {
                FcgInstructionList il2 = cgh.startConstantGeneration();
                constantGen.generate(s, cgh, cgt, il2);
                cgh.finishConstantGeneration(key2, fcgType, il);
            }
            return fcgType;
        }
        switch (valueStyleRequest) {
            case CURSOR: {
                String key3 = "Cursor/" + s;
                if (!cgh.insertConstant(key3, FcgXmlType.CURSOR_TYPE, il)) {
                    FcgInstructionList il2 = cgh.startConstantGeneration();
                    StreamInstruction.genConstant(s, il2);
                    cgh.finishConstantGeneration(key3, FcgXmlType.CURSOR_TYPE, il);
                }
                return FcgXmlType.CHARS;
            }
            case CHARS: {
                String key4 = "Chars/" + s;
                if (!cgh.insertConstant(key4, FcgXmlType.CHARS, il)) {
                    FcgInstructionList il2 = cgh.startConstantGeneration();
                    StreamInstruction.genConstant(s, il2);
                    cgh.finishConstantGeneration(key4, FcgXmlType.CHARS, il);
                }
                return FcgXmlType.CHARS;
            }
            case STRING: 
            case CHARSEQUENCE: {
                String key5 = "String/" + s;
                if (!cgh.insertConstant(key5, FcgType.STRING, il)) {
                    FcgInstructionList il2 = cgh.startConstantGeneration();
                    il2.loadLiteral(s);
                    cgh.finishConstantGeneration(key5, FcgType.STRING, il);
                }
                return FcgType.STRING;
            }
        }
        return StreamInstruction.insertCharStreamConstant(s, cgh, il);
    }

    public static final void insertStreamConstant(Instruction[] elements2, Type elementType, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il) {
        StreamInstruction.insertStreamConstant(elements2, elementType, cgh, cgt, il, 0, elements2.length);
    }

    public static final FcgType insertStreamConstant(Instruction[] elements2, Type elementType, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, int start, int length2) {
        FcgType constantType;
        if (elementType.equals(CharType.s_charType)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < length2; ++i) {
                sb.append(((Character)((LiteralInstruction)elements2[start + i]).getValue()).charValue());
            }
            constantType = StreamInstruction.insertCharStreamConstant(sb.toString(), cgh, il);
        } else {
            FcgType fcgElemType;
            FcgType fcgArrayType;
            StringBuffer buf = new StringBuffer();
            buf.append(elementType.prettyPrint());
            for (int i = 0; i < length2; ++i) {
                buf.append("\n");
                buf.append(elements2[start + i].toString());
            }
            String key2 = buf.toString();
            if (!cgh.insertConstant(key2, fcgArrayType = cgh.getArrayType(fcgElemType = elementType.getFCGType(cgh)), il)) {
                FcgInstructionList il2 = cgh.startConstantGeneration();
                for (int i = 0; i < length2; ++i) {
                    Instruction n2 = elements2[start + i];
                    cgt.generateConventionally(n2, cgh, false, il2, ValueGenStyle.DEFAULT);
                }
                il2.loadLiteral(length2);
                il2.createArrayExpr(fcgElemType, true);
                constantType = cgh.finishConstantGeneration(key2, fcgArrayType, il);
            } else {
                constantType = fcgArrayType;
            }
        }
        return constantType;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        if (this.isString()) {
            FcgType type2 = StreamInstruction.insertCharStreamConstant(this.m_string, cgh, cgt, il, valueStyleRequest);
            return type2;
        }
        this.convertStringToArray();
        Type elementType = this.m_elementType.resolveType(cgt.m_typeEnvironment);
        StreamType streamType = (StreamType)cgt.resolveType(this);
        int[] runs = new int[this.m_elements.length];
        boolean hasNonImmediate = false;
        int currentRun = 0;
        int nonStream = 0;
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (!(this.m_elements[i] instanceof LiteralInstruction)) {
                hasNonImmediate = true;
                currentRun = i + 1;
            } else {
                int n2 = currentRun;
                runs[n2] = runs[n2] + 1;
            }
            if (!elementType.equals(cgt.resolveType(this.m_elements[i]))) continue;
            ++nonStream;
        }
        if (!hasNonImmediate) {
            FcgType constType = this.makeConstant(cgh, il, cgt, varNameSuggestion + "_const");
            return constType;
        }
        FcgType elementFcgType = elementType.getFCGType(cgh);
        FcgType streamFcgType = streamType.getFCGType(cgh);
        String varName = cgh.generateNewLocalVariableName(varNameSuggestion);
        FcgVariable stream2 = null;
        if (nonStream == this.m_elements.length && nonStream < 5) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                FcgType realFcgType = cgt.generateConventionally(this.m_elements[i], cgh, false, il, ValueGenStyle.DEFAULT);
                FcgType coercedFcgType = cgt.boxIfNeeded(this.m_elements[i], cgh, il, realFcgType);
                if (!this.m_elementType.isForkReleaseManaged(cgt)) continue;
                this.m_elementType.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_NO_PUSH);
            }
            il.loadLiteral(this.m_elements.length);
            il.createArrayExpr(elementFcgType, true);
            stream2 = il.defineVar(streamFcgType, varName, true);
        } else {
            stream2 = il.defineVar(streamFcgType, varName, false);
            streamType.generateCreateStream(varName, nonStream == this.m_elements.length ? nonStream : this.m_elements.length * 32, cgh, il);
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction n3 = this.m_elements[i];
                Type resultType = n3.getType(tenv, cgt.m_bindingEnvironment).resolveType(cgt.m_typeEnvironment);
                if (!resultType.equals(elementType)) {
                    if (resultType instanceof StreamType && ((StreamType)resultType).getElementType().equals(elementType)) {
                        cgt.generateAddToStream(this.m_elements[i], varName, streamType, cgh, il, false, valueStyleRequest);
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "type error StreamType=" + resultType + " eltType=" + elementType + " at " + this);
                }
                if (runs[i] > 2) {
                    FcgType fcgTypeElement = StreamInstruction.insertStreamConstant(this.m_elements, elementType, cgh, cgt, il, i, runs[i]);
                    streamType.generateAddMultipleElementsToStream(cgh, cgt, il, varName, elementType, fcgTypeElement);
                    i += runs[i] - 1;
                    continue;
                }
                FcgType type3 = cgt.generateConventionally(this.m_elements[i], cgh, false, il, ValueGenStyle.DEFAULT);
                Type elementTypeFil = this.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
                streamType.generateAddElementToStream(cgh, il, varName, elementTypeFil, type3, cgt);
            }
            streamType.generateCompactStream(varName, cgh, il);
        }
        il.loadVar(stream2);
        return streamFcgType;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        int i;
        if (this.isString()) {
            int stringLength = this.m_string.length();
            if (0 < stringLength) {
                FcgType fcgTypeElement = StreamInstruction.insertCharStreamConstant(this.m_string, cgh, il);
                type2.generateAddMultipleElementsToStream(cgh, cgt, il, streamName, type2.getElementType(), fcgTypeElement);
            }
            return;
        }
        this.convertStringToArray();
        Type elementType = this.m_elementType.resolveType(cgt.m_typeEnvironment);
        int[] runs = new int[this.m_elements.length];
        int currentRun = 0;
        for (i = 0; i < this.m_elements.length; ++i) {
            if (!(this.m_elements[i] instanceof LiteralInstruction)) {
                currentRun = i + 1;
                continue;
            }
            int n2 = currentRun;
            runs[n2] = runs[n2] + 1;
        }
        for (i = 0; i < this.m_elements.length; ++i) {
            Instruction n3 = this.m_elements[i];
            Type instType = cgt.resolveType(n3);
            if (!instType.equals(elementType)) {
                if (instType instanceof StreamType && ((StreamType)instType).getElementType().equals(elementType)) {
                    cgt.generateAddToStream(n3, streamName, type2, cgh, il, tailPosition && i == this.m_elements.length - 1, valueStyleRequest);
                    continue;
                }
                throw new RuntimeException("codegen type error at " + n3 + " in " + this);
            }
            if (runs[i] > 2) {
                if (runs[i] > 0) {
                    FcgType fcgTypeElement = StreamInstruction.insertStreamConstant(this.m_elements, elementType, cgh, cgt, il, i, runs[i]);
                    type2.generateAddMultipleElementsToStream(cgh, cgt, il, streamName, elementType, fcgTypeElement);
                }
                i += runs[i] - 1;
                continue;
            }
            FcgType fcgType = cgt.generateConventionally(n3, cgh, false, il, ValueGenStyle.DEFAULT);
            Type elementTypeFil = this.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
            type2.generateAddElementToStream(cgh, il, streamName, elementTypeFil, fcgType, cgt);
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        if (this.m_elements != null) {
            int c = this.m_elements.length;
            Instruction[] params = this.m_elements;
            for (int i = 0; i < c; ++i) {
                Instruction param = this.m_elements[i];
                params[i] = rh.reduceToBasicInstruction(state, param, benv);
            }
            this.m_elements = params;
        }
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        if (this.isString()) {
            pw.printToken("\"" + LiteralInstruction.escape(this.m_string) + "\"", indent);
            return;
        }
        pw.newline();
        pw.printFormOpen("stream", indent);
        pw.printToken(this.getElementType().prettyPrint(), indent + 1);
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].toString(pw, indent + 1);
        }
        pw.print(")");
    }

    public String getStringContent() {
        if (this.m_string != null) {
            return this.m_string;
        }
        if (this.isStatic(null) && this.getElementType().equals(CharType.s_charType)) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.m_elements.length; ++i) {
                if (!(this.m_elements[i] instanceof LiteralInstruction) || !(((LiteralInstruction)this.m_elements[i]).getValue() instanceof Character)) {
                    return null;
                }
                buf.append(((Character)((LiteralInstruction)this.m_elements[i]).getValue()).charValue());
            }
            this.m_string = buf.toString();
            this.m_elements = null;
            return this.m_string;
        }
        return null;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        IAppendableStream as;
        if (null != di) {
            di.enter(this, e, f2);
        }
        IStream ans = null;
        if (this.m_elements == null) {
            ans = new StringStream(this.m_string);
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (this.m_elementType.equals(CharType.s_charType)) {
            as = new CharArrayWriterStream();
        } else if (this.m_elementType instanceof TagType) {
            as = new TagStream();
        } else {
            ListStream list = new ListStream();
            e.pushIForkReleaseManagedForRelease(list);
            as = list;
        }
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].evaluate(as, e, f2, di);
        }
        ans = as;
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        if (this.m_elements == null) {
            as.append(new StringStream(this.m_string), CharType.s_charStreamType);
            Debugger.leave(di, this, e, f2, null);
            return;
        }
        if (this.m_elementType.equals(CharType.s_charType)) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(as, e, f2, di);
            }
        } else {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(as, e, f2, di);
            }
        }
        Debugger.leave(di, this, e, f2, null);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof StreamInstruction)) {
            return false;
        }
        StreamInstruction si = (StreamInstruction)arg0;
        if (si.m_string != null && this.m_string != null) {
            return this.m_string.equals(si.m_string);
        }
        if (si.m_elements != null && this.m_elements != null) {
            int i;
            if (si.m_elements.length != this.m_elements.length) {
                return false;
            }
            if (this.m_elementType != null && si.m_elementType != null && this.m_elementType != si.m_elementType) {
                return false;
            }
            for (i = 0; i < this.m_elements.length; ++i) {
                if (this.m_elements[i].hashCode() == si.m_elements[i].hashCode()) continue;
                return false;
            }
            for (i = 0; i < this.m_elements.length; ++i) {
                if (this.m_elements[i].equals(si.m_elements[i])) continue;
                return false;
            }
            return true;
        }
        if (!super.equals(arg0)) {
            return false;
        }
        return this.m_elementType.equals(si.m_elementType);
    }

    @Override
    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings, Instruction parent2, int index2, BindingEnvironment benv) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(specificBindings, collectedBindings, parent2, index2, benv);
    }

    @Override
    public void determineDataDependencies(Set bindingNames) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(bindingNames);
    }

    public void setElements(Instruction[] elements2) {
        this.m_elements = elements2;
        this.m_string = null;
    }

    @Override
    public void replaceTypeVariables(Map typeMap) {
        super.replaceTypeVariables(typeMap);
        this.m_elementType = this.m_elementType.replaceType(typeMap);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public Instruction replaceBindings(Map bindings) {
        if (this.m_string != null) {
            return this;
        }
        return super.replaceBindings(bindings);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        return super.assignNewNames(names, ing);
    }

    @Override
    public Instruction cloneReduced() {
        if (this.m_string != null) {
            StreamInstruction i = new StreamInstruction(this.m_string);
            StreamInstruction.propagateInfo(this, i);
            return i;
        }
        return super.cloneReduced();
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        if (rofh.readByte() == 1) {
            this.m_string = rofh.readString();
            this.m_elementType = CharType.s_charType;
        } else {
            this.m_elementType = rofh.readType();
            this.m_elements = new Instruction[rofh.readInt()];
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i] = rofh.readInstruction(benv);
            }
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        if (this.m_string != null) {
            wofh.writeByte(1);
            wofh.writeString(this.m_string);
        } else {
            wofh.writeByte(0);
            wofh.writeType(this.m_elementType);
            super.write(wofh);
        }
    }

    @Override
    public int byteCodeSize() {
        if (this.m_string != null) {
            return 4;
        }
        return 2 + 2 * this.getChildInstructionCount();
    }

    @Override
    public int accumulateByteCodeSize() {
        if (this.m_string == null) {
            return super.accumulateByteCodeSize();
        }
        return 4;
    }

    @Override
    public void clearTypeInformation() {
        if (this.m_string == null) {
            super.clearTypeInformation();
        } else {
            this.m_hasBeenTypechecked = false;
            this.m_bindingEnvironment = null;
        }
    }

    @Override
    public void standardizeTypes(Set knownTypeVars, TypeEnvironment tenv) {
        if (this.m_string != null) {
            this.m_elementType = this.m_elementType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars);
            Type cachedType = this.getCachedType();
            if (cachedType != null) {
                this.setCachedType(cachedType.resolveTypeAsMuchAsPossible(tenv, knownTypeVars));
            }
        } else {
            super.standardizeTypes(knownTypeVars, tenv);
        }
    }

    @Override
    public Instruction removeAliases(HashMap aliases) {
        if (this.m_string != null) {
            return this;
        }
        return super.removeAliases(aliases);
    }

    public void split(int grain) {
        if (this.m_string != null) {
            throw new XylemError("ERR_SYSTEM", "can't split String stream!");
        }
        if (grain <= 0) {
            throw new XylemError("ERR_SYSTEM", "can't split with zero grain!");
        }
        LinkedList<StreamInstruction> streams = new LinkedList<StreamInstruction>();
        LinkedList<Instruction> members = new LinkedList<Instruction>();
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (i > 0 && i % grain == 0) {
                StreamInstruction nsi = new StreamInstruction(this.getElementType(), members);
                streams.add(nsi);
                members = new LinkedList();
            }
            members.add(this.m_elements[i].cloneWithoutTypeInformation());
        }
        if (members.size() > 0) {
            StreamInstruction nsi = new StreamInstruction(this.getElementType(), members);
            streams.add(nsi);
        }
        Object[] sarray = streams.toArray();
        this.m_elements = new Instruction[sarray.length];
        for (int k = 0; k < sarray.length; ++k) {
            this.m_elements[k] = (Instruction)sarray[k];
        }
    }

    public void split() {
        if (this.m_elements == null) {
            throw new XylemError("ERR_SYSTEM", "StreamInstruction.m_elements: NULL");
        }
        this.split(this.m_elements.length / 2);
    }

    @Override
    protected int doesDescendentCountExceedThresholdHelper(int threshold) {
        if (this.isStoredAsString()) {
            return threshold;
        }
        return super.doesDescendentCountExceedThresholdHelper(threshold);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment tenv, BindingEnvironment benv) throws TypeCheckException {
        if (!this.isString()) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction n2 = this.m_elements[i];
                if (!(n2 instanceof IMatchDestructable)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", n2 + " not supported in match2 pattern"), this);
                }
                ((IMatchDestructable)((Object)n2)).typeCheckDestruction(tenv, benv);
            }
        }
        return this.m_elementType.getStreamType();
    }

    @Override
    public Instruction desugarDestruction(Instruction toMatch, ReductionHelper rh, IMatchDestructable.Generator trueCode, IMatchDestructable.Generator falseCode, BindingEnvironment benv) {
        if (this.isString()) {
            Object x = rh.generateReducedIdentifier("");
            Object y = rh.generateReducedIdentifier("");
            LetInstruction inner2 = new LetInstruction(y, new DeepEqualityInstruction(toMatch, new IdentifierInstruction(x)), new ChooseInstruction(new IdentifierInstruction(y), trueCode.generate(), falseCode.generate()));
            LetInstruction outer = new LetInstruction(x, this, inner2);
            return outer;
        }
        return null;
    }
}

