/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class StreamRepeatInstruction
extends BinaryPrimopInstruction
implements IStreamOptimizationInstruction {
    public StreamRepeatInstruction() {
    }

    public StreamRepeatInstruction(Instruction input, Instruction repeat) {
        super(input, repeat);
    }

    public Instruction getRepeatedEntry() {
        return this.getOperand1();
    }

    public Instruction getRepeatCount() {
        return this.getOperand2();
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(this.getOperand2().typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        return this.setCachedType(this.getOperand1().typeCheck(tenv, benv, functionStack).getStreamType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand1.getType(tenv, benv).getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        Type type2 = null != this.m_operand1 ? this.m_operand1.getPreTypecheckType(msig) : null;
        return type2 != null ? type2.getStreamType() : super.getPreTypecheckType(msig);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new StreamRepeatInstruction(op1, op2);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        ListStream ans = null;
        int repeat = (Integer)this.getOperand2().evaluate(e, f2, di, false);
        Object val = this.getOperand1().evaluate(e, f2, di, false);
        ListStream s = new ListStream();
        e.pushIForkReleaseManagedForRelease(s);
        for (int i = 0; i < repeat; ++i) {
            s.append(val, this.getOperand1().evaluateType(f2));
        }
        ans = s;
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        StreamType sType = (StreamType)cgt.resolveType(this);
        Type valType = this.getOperand1().getType(tenv, cgt.m_bindingEnvironment);
        if (valType instanceof StreamType) {
            throw new Error("argument 1 to stream-repeat must be atomic.");
        }
        String value2 = cgh.generateNewLocalVariableName();
        FcgType valueType = cgt.generateConventionally(this.getOperand1(), cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable valueVar = il.defineVar(valueType, value2, true);
        Type elementType = sType.getElementType();
        if (elementType.getFCGType(cgh) != valueType) {
            throw new Error("StreamRepeatInstruction, array types aren't the same.");
        }
        String repeatName = cgh.generateNewLocalVariableName();
        FcgType repeatType = cgt.generateConventionally(this.getOperand2(), cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable repeat = il.defineVar(repeatType, repeatName, true);
        String arrHandle = cgh.generateNewLocalVariableName();
        il.loadVar(repeat);
        FcgType arrType = il.createArrayExpr(valueType, false);
        FcgVariable arrHandleVar = il.defineVar(arrType, arrHandle, true);
        il.loadVar(arrHandleVar);
        il.loadLiteral(0);
        il.loadVar(repeat);
        il.loadLiteral(1);
        il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        il.loadVar(valueVar);
        il.fillStmt();
        il.loadVar(arrHandleVar);
        return arrType;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        throw new XylemError("ERR_SYSTEM", "not implemented yet");
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos == StreamOptimizationStyle.s_streamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public String innerToString() {
        return "stream-repeat";
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction i = this.cloneWithoutTypeInformation(this.getOperand1().cloneWithoutTypeInformation(), this.getOperand2().cloneWithoutTypeInformation());
        StreamRepeatInstruction.propagateInfo(this, i);
        return i;
    }
}

