/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SubstreamInstruction
extends Instruction
implements IStreamOptimizationInstruction {
    protected Instruction m_source;
    protected Instruction m_start;
    protected Instruction m_length;
    protected boolean m_zeroBased;

    public SubstreamInstruction() {
    }

    public SubstreamInstruction(Instruction source, Instruction start, Instruction length2, boolean zeroBased) {
        this.m_source = source;
        this.m_start = start;
        this.m_length = length2;
        this.m_zeroBased = zeroBased;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_length == null ? 2 : 3;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_length != null) {
            if (i == 0) {
                return this.m_length;
            }
            --i;
        }
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_start;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_length != null) {
            if (i == 0) {
                this.m_length = n2;
                return;
            }
            --i;
        }
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_start = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        SubstreamInstruction i = new SubstreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_start.cloneWithoutTypeInformation(), this.m_length == null ? null : this.m_length.cloneWithoutTypeInformation(), this.m_zeroBased);
        SubstreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        SubstreamInstruction i = new SubstreamInstruction(this.m_source, this.m_start, this.m_length == null ? null : this.m_length, this.m_zeroBased);
        SubstreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        if (this.m_length != null) {
            tenv.unify(this.m_length.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        }
        TypeVariable tvar = new TypeVariable();
        Type t1 = this.setCachedType(this.m_source.typeCheck(tenv, benv, functionStack));
        tenv.unify(t1, tvar.getStreamType(), this);
        tenv.unify(this.m_start.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        return t1;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_source.getType(tenv, benv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgVariable lengthVar;
        StreamType type2 = (StreamType)cgt.resolveType(this.m_source);
        FcgType sourceType = cgt.generateConventionally(this.m_source, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable source = il.defineConstVar(sourceType, cgh.generateNewLocalVariableName());
        FcgType startType = cgt.generateConventionally(this.m_start, cgh, false, il, ValueGenStyle.DEFAULT);
        if (!this.m_zeroBased) {
            il.loadLiteral(1);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        FcgVariable startVar = il.defineVar(startType, cgh.generateNewLocalVariableName(), true);
        String length2 = cgh.generateNewLocalVariableName();
        if (this.m_length == null) {
            il.loadVar(source);
            il.unaryOperationExpr(FcgUnaryOp.LENGTH);
            il.loadVar(startVar);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
            lengthVar = il.defineVar(FcgType.INT, length2, true);
        } else {
            FcgType lengthType = cgt.generateConventionally(this.m_length, cgh, false, il, ValueGenStyle.DEFAULT);
            lengthVar = il.defineVar(lengthType, length2, true);
        }
        FcgVariable result2 = type2.generateCopyStream(source, startVar, lengthVar, null, null, cgh, il, cgt);
        return il.loadVar(result2);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        this.m_start = rh.reduceToBasicInstruction(state, this.m_start, benv);
        if (this.m_length != null) {
            this.m_length = rh.reduceToBasicInstruction(state, this.m_length, benv);
        }
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        IForkReleaseManaged ans = null;
        IStream source = (IStream)this.m_source.evaluate(e, f2, di, false);
        int start = (Integer)this.m_start.evaluate(e, f2, di, false);
        int len = (Integer)this.m_length.evaluate(e, f2, di, false);
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<Object> i = source.iterator();
        int index2 = 0;
        while (i.hasNext()) {
            Object tmp = i.next();
            if (index2 < start - (this.m_zeroBased ? 0 : 1)) {
                ++index2;
                continue;
            }
            if (index2 < start + len) {
                list.add(tmp);
            }
            ++index2;
        }
        ans = e.pushIForkReleaseManagedForRelease(new ListStream(list));
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public String innerToString() {
        return this.m_zeroBased ? "substream" : "substream-1";
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        FcgType fcgTypeElement = cgt.generateConventionally(this.m_source, cgh, false, il, ValueGenStyle.DEFAULT);
        cgt.generateConventionally(this.m_start, cgh, false, il, ValueGenStyle.DEFAULT);
        if (!this.m_zeroBased) {
            il.loadLiteral(1);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        if (this.m_length != null) {
            cgt.generateConventionally(this.m_length, cgh, false, il, ValueGenStyle.DEFAULT);
        } else {
            FcgVariable start = il.defineVar(FcgType.INT, streamName + "_tempStart", true);
            FcgVariable source = il.defineVar(type2.getFCGType(cgh), streamName + "_temp", true);
            il.loadVar(source);
            il.loadVar(start);
            il.loadVar(source);
            il.unaryOperationExpr(FcgUnaryOp.LENGTH);
            il.loadVar(start);
            il.binaryOperationExpr(FcgBinOp.SUBTRACT);
        }
        type2.generateAddMultipleElementsToStream(cgh, cgt, il, streamName, type2.getElementType(), fcgTypeElement, false);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_start = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_length = rofh.readInstruction(benv);
        }
        this.m_zeroBased = rofh.readBoolean();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeInstruction(this.m_start);
        wofh.writeBoolean(this.m_length != null);
        if (this.m_length != null) {
            wofh.writeInstruction(this.m_length);
        }
        wofh.writeBoolean(this.m_zeroBased);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent);
        this.m_source.toString(pw, indent + 1);
        this.m_start.toString(pw, indent + 1);
        if (this.m_length != null) {
            this.m_length.toString(pw, indent + 1);
        }
        pw.printFormClose(indent);
    }
}

