/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.ClassType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import java.io.IOException;
import java.util.LinkedList;

public class SuperMethodInvocationInstruction
extends NaryPrimopInstruction {
    protected Type m_classType;
    protected String m_function;

    public SuperMethodInvocationInstruction() {
    }

    public SuperMethodInvocationInstruction(Type t, String function2, Instruction[] parameters) {
        super(parameters);
        this.m_classType = t;
        this.m_function = function2;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String n2) {
        this.m_function = n2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_classType;
        t = t.resolveType(tenv);
        if (t == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Invalid type: " + this.m_classType), this);
        }
        if (!(t instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_classType + " is not a class type"), this);
        }
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Method m = jot.resolveMethod(this.m_function, tenv);
        if (m == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] types2 = m.m_parameters;
        if (types2.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + jot.getName() + " takes " + m.m_parameters.length + " parameters"), this);
        }
        for (int j = 0; j < types2.length; ++j) {
            tenv.unify(types2[j].getBindingType(), this.m_parameters[j].typeCheck(tenv, benv, functionStack), this);
        }
        return this.setCachedType(m.getReturnType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_classType;
        t = t.resolveType(tenv);
        ClassType jot = (ClassType)((NamedType)t).resolveName(tenv);
        ClassType.Method m = jot.resolveMethod(this.m_function, tenv);
        return tenv.getModule().getFunction(m.getFunction()).getReturnType();
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        SuperMethodInvocationInstruction i = new SuperMethodInvocationInstruction(this.m_classType, this.m_function, parameters);
        SuperMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        SuperMethodInvocationInstruction i = new SuperMethodInvocationInstruction(this.m_classType, this.m_function, parameters);
        SuperMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "super-method-invoke";
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        SuperMethodInvocationInstruction mii = (SuperMethodInvocationInstruction)arg0;
        return mii.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_classType = rofh.readType();
        this.m_function = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_classType);
        wofh.writeString(this.m_function);
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_classType : null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_classType = n2;
        }
    }
}

