/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;

public class TagStreamInstruction
extends UnaryPrimopInstruction {
    protected String m_tag;

    public TagStreamInstruction(String tag, Instruction value2) {
        super(value2);
        this.m_tag = tag;
    }

    public TagStreamInstruction() {
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        return this.m_operand.generateCode(cg, cgt, varNameSuggestion, tailPosition, il, valueStyleRequest);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand.typeCheck(tenv, benv, functionStack);
        StreamType st = new TypeVariable().getStreamType();
        tenv.unify(t, st, this);
        return this.setCachedType(new TagType(this.m_tag, st.getElementType()).getStreamType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return new TagType(this.m_tag, ((StreamType)this.m_operand.getType(tenv, benv)).getElementType()).getStreamType();
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TagStreamInstruction i = new TagStreamInstruction(this.m_tag, this.m_operand.cloneWithoutTypeInformation());
        TagStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        TagStreamInstruction i = new TagStreamInstruction(this.m_tag, operand2);
        TagStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "tag-stream";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_tag;
    }

    @Override
    public boolean equals(Object arg0) {
        return super.equals(arg0) && ((TagStreamInstruction)arg0).m_tag.equals(this.m_tag);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = this.m_operand.evaluate(e, f2, di, false);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_tag = rofh.readString();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_tag);
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        return this.m_operand.isStatic(benv);
    }

    public String getTag() {
        return this.m_tag;
    }
}

