/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class TernaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand1;
    protected Instruction m_operand2;
    protected Instruction m_operand3;

    public TernaryPrimopInstruction() {
    }

    protected TernaryPrimopInstruction(Instruction op1, Instruction op2, Instruction op3) {
        this.m_operand1 = op1;
        this.m_operand2 = op2;
        this.m_operand3 = op3;
    }

    public final Instruction getOperand1() {
        return this.m_operand1;
    }

    public final Instruction getOperand2() {
        return this.m_operand2;
    }

    public final Instruction getOperand3() {
        return this.m_operand3;
    }

    @Override
    public final int getChildInstructionCount() {
        return 3;
    }

    @Override
    public final Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_operand1;
            }
            case 1: {
                return this.m_operand2;
            }
            case 2: {
                return this.m_operand3;
            }
        }
        return null;
    }

    @Override
    public final void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_operand1 = n2;
                break;
            }
            case 1: {
                this.m_operand2 = n2;
                break;
            }
            case 2: {
                this.m_operand3 = n2;
            }
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        Instruction operand1 = rh.reduceToBasicInstruction(state, this.m_operand1, benv);
        Instruction operand2 = rh.reduceToBasicInstruction(state, this.m_operand2, benv);
        Instruction operand3 = rh.reduceToBasicInstruction(state, this.m_operand3, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand1 = operand1;
        this.m_operand2 = operand2;
        this.m_operand3 = operand3;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1, Instruction var2, Instruction var3);

    @Override
    public Instruction cloneShallow() {
        Instruction i = this.cloneWithoutTypeInformation(this.m_operand1, this.m_operand2, this.m_operand3);
        TernaryPrimopInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_operand1 = rofh.readInstruction(benv);
        this.m_operand2 = rofh.readInstruction(benv);
        this.m_operand3 = rofh.readInstruction(benv);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_operand1);
        wofh.writeInstruction(this.m_operand2);
        wofh.writeInstruction(this.m_operand3);
    }

    @Override
    public Instruction cloneReduced() {
        if (Instruction.CLONEREDUCEDSHALLOW) {
            return this.cloneShallow();
        }
        return super.cloneReduced();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }
}

