/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IteratorInstruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TestStreamInstruction
extends IteratorInstruction
implements ISpecialForm {
    protected Instruction m_source;
    protected Instruction m_body;
    protected Instruction m_hint;
    protected Binding m_hintBinding;
    protected Binding m_elementBinding;
    protected Binding m_indexBinding;
    protected ICollectionType m_collectionType;

    public TestStreamInstruction(Instruction source, Instruction hint, Object elementVar, Object hintVar, Object indexVar, Instruction body) {
        this.m_source = source;
        this.m_hint = hint;
        this.m_hintBinding = new Binding(hintVar, this);
        this.m_body = body;
        this.m_elementBinding = new Binding(elementVar, this);
        if (indexVar != null) {
            this.m_indexBinding = new Binding(indexVar, (Type)IntType.s_intType, this);
        }
    }

    public TestStreamInstruction(Instruction source, Instruction hint, Object elementVar, Object hintVar, Object indexVar, Instruction body, ICollectionType collectionType) {
        this(source, hint, elementVar, hintVar, indexVar, body);
        this.m_collectionType = collectionType;
        this.m_elementBinding.setType(collectionType.getElementType());
    }

    public TestStreamInstruction() {
    }

    @Override
    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction x) {
        this.m_body = x;
    }

    public Binding getElementBinding() {
        return this.m_elementBinding;
    }

    public Instruction getHint() {
        return this.m_hint;
    }

    public void setHint(Instruction x) {
        this.m_hint = x;
    }

    public Binding getHintBinding() {
        return this.m_hintBinding;
    }

    @Override
    public Object getIndexVar() {
        return this.m_indexBinding == null ? null : this.m_indexBinding.getName();
    }

    public IBinding getIndexBinding() {
        return this.m_indexBinding;
    }

    public void setIndexVar(Object indexVar) {
        this.m_indexBinding = indexVar == null ? null : new Binding(indexVar, (Type)IntType.s_intType, this);
    }

    public Instruction getSource() {
        return this.m_source;
    }

    @Override
    public Instruction[] getSources() {
        return new Instruction[]{this.m_source};
    }

    public void setSource(Instruction x) {
        this.m_source = x;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_hint;
            }
            case 2: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public int getChildInstructionCount() {
        return 3;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_hint = n2;
                break;
            }
            case 2: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        IBinding toSkip = ((IdentifierInstruction)this.m_source).getBinding(cgt.m_bindingEnvironment);
        cgt.generateFreeBindings(this, cgh, il, toSkip, false, false, ValueGenStyle.DEFAULT);
        String hint = cgh.generateNewLocalVariableName(varNameSuggestion);
        FcgType initialHint = cgt.generateConventionally(this.m_hint, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable hintVar = il.defineVar(cgt.resolveType(this).getFCGType(cgh), hint, true);
        boolean usesIndex = this.m_indexBinding != null && cgt.isBindingUsed(this.m_indexBinding);
        FcgVariable index2 = null;
        if (usesIndex) {
            il.loadLiteral(0);
            index2 = il.defineVar(FcgType.INT, cgh.generateNewLocalVariableName(), true);
        }
        boolean onceFalseAlwaysFalseIdiom = false;
        boolean onceTrueAlwaysTrueIdiom = false;
        if (this.m_body instanceof ChooseInstruction) {
            Instruction test2;
            ChooseInstruction ci = (ChooseInstruction)this.m_body;
            if (LiteralInstruction.booleanFalseLiteral().equals(ci.getDefaultHandler()) && ci.m_cases.length == 1) {
                IdentifierInstruction ii;
                test2 = ci.m_cases[0].getTest();
                if (test2 instanceof IdentifierInstruction && (ii = (IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding) {
                    onceFalseAlwaysFalseIdiom = true;
                    il.loadVar(hintVar);
                    il.beginIf();
                }
            } else if (ci.m_cases.length == 1 && (test2 = ci.m_cases[0].getTest()) instanceof IdentifierInstruction && ((IdentifierInstruction)test2).getBinding(benv) == this.m_hintBinding) {
                Instruction handler = ci.m_cases[0].getHandler();
                if (LiteralInstruction.booleanTrueLiteral().equals(handler) || handler instanceof IdentifierInstruction && ((IdentifierInstruction)handler).getBinding(benv) == this.m_hintBinding) {
                    onceTrueAlwaysTrueIdiom = true;
                    il.loadVar(hintVar);
                    il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
                    il.beginIf();
                }
            }
        }
        FcgVariable currentElement = this.m_collectionType.generateLoopStart(cgh, il, this.m_source, this.m_collectionType.getElementType().getFCGType(cgh), cgt);
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        cgt2.registerExtantBinding(this.m_hintBinding, hint);
        cgt2.registerExtantBinding(this.m_elementBinding, currentElement.getName());
        if (usesIndex) {
            cgt2.registerExtantBinding(this.m_indexBinding, index2.getName());
        }
        if (onceFalseAlwaysFalseIdiom) {
            il.loadVar(hintVar);
            il.unaryOperationExpr(FcgUnaryOp.LOGICAL_NOT);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        } else if (onceTrueAlwaysTrueIdiom) {
            il.loadVar(hintVar);
            il.beginIf();
            il.breakFromLoop();
            il.endIf();
        }
        this.generateBodyWithFirstCaseShortcut(cgh, cgt2, varNameSuggestion, false, this.m_body, hintVar, index2, il);
        this.m_collectionType.generateLoopEnd(cgh, il, currentElement, cgt);
        if (onceFalseAlwaysFalseIdiom || onceTrueAlwaysTrueIdiom) {
            il.endIf();
        }
        return il.loadVar(hintVar);
    }

    public void generateBodyWithFirstCaseShortcut(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, Instruction originalBody, FcgVariable hint, FcgVariable index2, FcgInstructionList il) {
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        Instruction body = originalBody;
        if (body instanceof LetInstruction) {
            body = ((LetInstruction)body).skipLetCodegen(cgt, null);
        }
        if (body instanceof ChooseInstruction) {
            ChooseInstruction choose = (ChooseInstruction)body;
            if (choose.m_cases.length >= 1) {
                Instruction test2;
                Set bindings;
                if (choose.m_cases.length > 1) {
                    throw new XylemError("ERR_SYSTEM", "reduced choose should only have one case");
                }
                Instruction handler = choose.m_cases[0].getHandler();
                if (handler instanceof IdentifierInstruction && ((IdentifierInstruction)handler).getBinding(benv) == this.m_hintBinding && !(bindings = NavigationUtilities.resolveFreeBindingsForReducedExpression(test2 = choose.m_cases[0].getTest(), originalBody, benv)).contains(this.m_elementBinding)) {
                    cgt.generateConventionally(test2, cgh, false, il, ValueGenStyle.DEFAULT);
                    il.beginIf();
                    il.breakFromLoop();
                    il.beginElse();
                    if (choose.getDefaultHandler() != null) {
                        this.generateBodyWithFirstCaseShortcut(cgh, cgt, varNameSuggestion, tailPosition, choose.getDefaultHandler(), hint, index2, il);
                    }
                    il.endIf();
                    return;
                }
            }
        }
        body.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, ValueGenStyle.DEFAULT_WITH_PUSH);
        il.storeVar(hint);
        if (index2 != null) {
            il.incrementVarStmt(index2);
        }
    }

    @Override
    public Instruction cloneShallow() {
        if (this.m_elementBinding.getBindingType() instanceof TypeVariable) {
            TestStreamInstruction i = new TestStreamInstruction(this.m_source, this.m_hint, this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body);
            TestStreamInstruction.propagateInfo(this, i);
            return i;
        }
        TestStreamInstruction i = new TestStreamInstruction(this.m_source, this.m_hint, this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body, this.m_collectionType);
        TestStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        if (this.m_elementBinding.getBindingType() instanceof TypeVariable) {
            TestStreamInstruction i = new TestStreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_hint.cloneWithoutTypeInformation(), this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body.cloneWithoutTypeInformation());
            TestStreamInstruction.propagateInfo(this, i);
            return i;
        }
        TestStreamInstruction i = new TestStreamInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_hint.cloneWithoutTypeInformation(), this.m_elementBinding.getName(), this.m_hintBinding.getName(), this.getIndexVar(), this.m_body.cloneWithoutTypeInformation(), this.m_collectionType);
        TestStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        this.m_hint = rh.reduceToBasicInstruction(state, this.m_hint, benv);
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        rh2.upgradeBinding(this.m_elementBinding);
        rh2.upgradeBinding(this.m_hintBinding);
        benv.setVariableBinding(this.m_elementBinding);
        benv.setVariableBinding(this.m_hintBinding);
        if (this.m_indexBinding != null) {
            rh2.upgradeBinding(this.m_indexBinding);
            benv.setVariableBinding(this.m_indexBinding);
        }
        this.m_body = rh2.reduce(this.m_body, benv);
        this.m_collectionType = (ICollectionType)((Object)this.m_source.getType(rh.m_typeEnvironment, benv).resolveType(rh.m_typeEnvironment));
        this.m_elementBinding.setType(this.m_collectionType.getElementType());
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        benv2.setVariableBinding(this.m_elementBinding);
        this.m_hintBinding.setType(this.m_hint.typeCheck(tenv, benv, functionStack));
        this.m_hintBinding.setTypeEnvironment(tenv);
        benv2.setVariableBinding(this.m_hintBinding);
        if (this.m_indexBinding != null) {
            this.m_indexBinding.setTypeEnvironment(tenv);
            benv2.setVariableBinding(this.m_indexBinding);
        }
        if (this.m_elementBinding.getBindingType() instanceof TypeVariable) {
            this.m_collectionType = this.m_elementBinding.getBindingType().getStreamType();
        }
        tenv.unify((Type)((Object)this.m_collectionType), this.m_source.typeCheck(tenv, benv, functionStack), this);
        TypeVariable tvar = new TypeVariable();
        Type t = this.m_body.typeCheck(tenv, benv2, functionStack);
        tenv.unify(t, this.m_hintBinding.getBindingType(), this);
        return this.setCachedType(t);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object hint = null;
        IStream s = (IStream)this.m_source.evaluate(e, f2, di, false);
        hint = this.m_hint.evaluate(e, f2, di, false);
        Iterator<Object> i = s.iterator();
        int index2 = 0;
        while (i.hasNext()) {
            Object o = i.next();
            e.bindInCurrentFrame(this.m_elementBinding, o);
            e.bindInCurrentFrame(this.m_hintBinding, hint);
            if (this.m_indexBinding != null) {
                e.bindInCurrentFrame(this.m_indexBinding, index2);
                ++index2;
            }
            hint = this.m_body.evaluate(e, f2, di, false);
        }
        return Debugger.leave(di, this, e, f2, hint);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        String instructionName;
        pw.newline();
        String string2 = instructionName = this.m_indexBinding != null ? "test-stream-c" : "test-stream";
        if (this.m_elementBinding.getBindingType() instanceof TypeVariable) {
            pw.printFormOpen(instructionName, indent);
        } else {
            pw.printFormOpen(instructionName + "@" + ((Type)((Object)this.m_collectionType)).prettyPrint(), indent);
        }
        this.m_source.toString(pw, indent + 1);
        this.m_hint.toString(pw, indent + 1);
        pw.printIdentifier(this.m_elementBinding, indent + 1);
        pw.printIdentifier(this.m_hintBinding, indent + 1);
        if (this.m_indexBinding != null) {
            pw.printIdentifier(this.m_indexBinding, indent + 1);
        }
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        set2.remove(this.m_elementBinding);
        set2.remove(this.m_hintBinding);
        set2.remove(this.m_indexBinding);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        benv.setVariableBinding(this.m_elementBinding);
        benv.setVariableBinding(this.m_hintBinding);
        if (this.m_indexBinding != null) {
            benv.setVariableBinding(this.m_indexBinding);
        }
        this.m_hintBinding.setType(this.m_hint.getType(tenv, benv));
        if (this.m_collectionType == null) {
            Type srcType = this.m_source.getType(tenv, benv);
            if (!(srcType instanceof ICollectionType)) {
                throw new XylemError("ERR_SYSTEM", "? in " + this);
            }
            this.m_collectionType = (ICollectionType)((Object)srcType);
        }
        this.m_elementBinding.setType(this.m_collectionType.getElementType());
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        set2.remove(this.m_elementBinding);
        set2.remove(this.m_hintBinding);
        set2.remove(this.m_indexBinding);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object s = ing.getNewName();
        names.put(this.m_elementBinding.getName(), new IdentifierInstruction(s));
        Object elementVar = s;
        s = ing.getNewName();
        names.put(this.m_hintBinding.getName(), new IdentifierInstruction(s));
        Object hintVar = s;
        Object indexVar = null;
        if (this.m_indexBinding != null) {
            s = ing.getNewName();
            names.put(this.m_indexBinding.getName(), new IdentifierInstruction(s));
            indexVar = s;
        }
        if (this.m_elementBinding.getBindingType() instanceof TypeVariable) {
            return new TestStreamInstruction(this.m_source.assignNewNames(names, ing), this.m_hint.assignNewNames(names, ing), elementVar, hintVar, indexVar, this.m_body.assignNewNames(names, ing));
        }
        return new TestStreamInstruction(this.m_source.assignNewNames(names, ing), this.m_hint.assignNewNames(names, ing), elementVar, hintVar, indexVar, this.m_body.assignNewNames(names, ing), this.m_collectionType);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_hint = rofh.readInstruction(benv);
        this.m_elementBinding = new Binding(rofh.readBindingName(), this);
        this.m_hintBinding = new Binding(rofh.readBindingName(), this);
        boolean hasIndex = rofh.readBoolean();
        if (hasIndex) {
            this.m_indexBinding = new Binding(rofh.readBindingName(), (Type)IntType.s_intType, this);
        }
        this.m_body = rofh.readInstruction(benv);
        this.m_collectionType = (ICollectionType)((Object)rofh.readType());
        if (this.m_collectionType != null) {
            this.m_elementBinding.setType(this.m_collectionType.getElementType());
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeInstruction(this.m_hint);
        wofh.writeBindingName(this.m_elementBinding.getName());
        wofh.writeBindingName(this.m_hintBinding.getName());
        wofh.writeBoolean(this.m_indexBinding != null);
        if (this.m_indexBinding != null) {
            wofh.writeBindingName(this.m_indexBinding.getName());
        }
        wofh.writeInstruction(this.m_body);
        wofh.writeType((Type)((Object)this.m_collectionType));
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_collectionType == null ? 0 : 1;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? (Type)((Object)this.m_collectionType) : null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_collectionType = (ICollectionType)((Object)n2);
        }
    }

    public ICollectionType getCollectionType() {
        return this.m_collectionType;
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 2;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        Binding[] bindings;
        if (i == 2) {
            bindings = new Binding[this.m_indexBinding != null ? 3 : 2];
            bindings[0] = this.m_hintBinding;
            bindings[1] = this.m_elementBinding;
            if (this.m_indexBinding != null) {
                bindings[2] = this.m_indexBinding;
            }
        } else {
            bindings = null;
        }
        return bindings;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }
}

