/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import java.io.IOException;
import java.util.LinkedList;

public class TryCatchInstruction
extends Instruction
implements ISpecialForm,
IStreamOptimizationInstruction {
    protected Instruction m_body;
    protected Instruction m_handler;
    protected String m_exceptionClass;

    public TryCatchInstruction() {
    }

    public TryCatchInstruction(String exceptionClass, Instruction body) {
        this(exceptionClass, body, null);
    }

    public TryCatchInstruction(String exceptionClass, Instruction body, Instruction defaultHandler) {
        this.m_exceptionClass = exceptionClass;
        this.m_body = body;
        this.m_handler = defaultHandler;
    }

    public Instruction getHandler() {
        return this.m_handler;
    }

    public void setHandler(Instruction n2) {
        this.m_handler = n2;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    public String getExceptionClass() {
        return this.m_exceptionClass;
    }

    public void setExceptionClass(String exceptionClass) {
        this.m_exceptionClass = exceptionClass;
    }

    @Override
    public int getChildInstructionCount() {
        if (this.m_handler == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_body;
            }
            case 1: {
                return this.m_handler;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_body = n2;
                break;
            }
            case 1: {
                this.m_handler = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TryCatchInstruction i = new TryCatchInstruction(this.m_exceptionClass, this.m_body.cloneWithoutTypeInformation(), this.m_handler == null ? null : this.m_handler.cloneWithoutTypeInformation());
        TryCatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        TryCatchInstruction i = new TryCatchInstruction(this.m_exceptionClass, this.m_body, this.m_handler);
        TryCatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_body.typeCheck(tenv, benv, functionStack);
        if (this.m_handler != null) {
            this.m_handler.typeCheck(tenv, benv, functionStack);
        }
        return this.setCachedType(this.m_body.getCachedType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType type2 = valueStyleRequest == ValueGenStyle.DEFAULT || valueStyleRequest == ValueGenStyle.DEFAULT_NO_PUSH || valueStyleRequest == ValueGenStyle.DEFAULT_WITH_PUSH ? cgt.resolveType(this).getFCGType(cgh) : valueStyleRequest.getFcgType();
        FcgVariable out = il.defineVar(type2, cgh.generateNewLocalVariableName(varNameSuggestion), false);
        il.beginTryBlock();
        FcgType retType = this.m_body.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
        if (retType == FcgType.VOID) {
            il.loadLiteral(1);
        } else if (retType != type2) {
            il.convertExpr(retType, type2);
        }
        il.storeVar(out);
        FcgVariable e = il.beginCatchBlock(cgh.getClassReferenceType(this.m_exceptionClass), "e");
        if (this.m_handler != null) {
            FcgType retType2 = this.m_handler.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
            if (retType2 == FcgType.VOID) {
                il.loadLiteral(1);
            } else if (retType2 != type2) {
                il.convertExpr(retType2, type2);
            }
            il.storeVar(out);
        } else {
            il.loadVar(e);
            il.createObjectExpr((FcgType)cgh.getClassReferenceType("java.lang.RuntimeException"), new FcgType[]{cgh.getClassReferenceType(Throwable.class.getName())});
            il.throwObject();
        }
        il.endTryBlock();
        il.loadVar(out);
        return type2;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        il.beginTryBlock();
        ((IStreamOptimizationInstruction)((Object)this.m_body)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
        FcgVariable e = il.beginCatchBlock(cgh.getClassReferenceType(this.m_exceptionClass), "e");
        if (this.m_handler != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_handler)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
        } else {
            il.loadVar(e);
            il.createObjectExpr((FcgType)cgh.getClassReferenceType("java.lang.RuntimeException"), new FcgType[]{cgh.getClassReferenceType(Throwable.class.getName())});
            il.throwObject();
        }
        il.endTryBlock();
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            if (!this.m_body.supportsCodeGenerationOptimization(cgos, tenv, benv)) {
                return false;
            }
            return this.m_handler == null || this.m_handler.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_body = rh.reduce(this.m_body, benv);
        if (this.m_handler != null) {
            this.m_handler = rh.reduce(this.m_handler, benv);
        }
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printlnFormOpen("try", indent);
        pw.printToken(this.m_exceptionClass, indent + 1);
        this.m_body.toString(pw, indent + 1);
        if (this.m_handler != null) {
            this.m_handler.toString(pw, indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        try {
            ans = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        catch (Exception ex) {
            if (this.m_handler == null) {
                throw new RuntimeException(ex);
            }
            Class exceptionClass = null;
            try {
                exceptionClass = ObjectFactory.findProviderClass(this.m_exceptionClass, Module.class.getClassLoader(), true);
            }
            catch (ClassNotFoundException e1) {
                // empty catch block
            }
            if (exceptionClass != null && exceptionClass.isAssignableFrom(ex.getClass())) {
                ans = this.m_handler.evaluate(e, f2, di, tailPosition);
            }
            throw new RuntimeException(ex);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeString(this.m_exceptionClass);
        wofh.writeInstruction(this.m_body);
        wofh.writeBoolean(this.m_handler != null);
        if (this.m_handler != null) {
            wofh.writeInstruction(this.m_handler);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_exceptionClass = rofh.readString();
        this.m_body = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_handler = rofh.readInstruction(benv);
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        return NO_BINDINGS;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public String innerToString() {
        return "try";
    }
}

