/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TupleMatchInstruction
extends Instruction
implements ISpecialForm {
    private static final Logger s_logger = LoggerUtil.getLogger(TupleMatchInstruction.class);
    private static final String s_className = TupleMatchInstruction.class.getName();
    protected Instruction m_toMatch;
    protected Instruction m_body;
    protected Binding[] m_bindings;

    public TupleMatchInstruction() {
    }

    public TupleMatchInstruction(Instruction toMatch, Object[] vars, Instruction body) {
        this.m_toMatch = toMatch;
        this.m_bindings = Binding.getBindings(vars);
        this.m_body = body;
    }

    public TupleMatchInstruction(Instruction toMatch, int size, int i) {
        this.m_bindings = new Binding[size];
        String base2 = OptimizerUtilities.generateIntermediateIdentifier() + "_";
        for (int k = 0; k < size; ++k) {
            this.m_bindings[k] = new Binding(base2 + k);
        }
        this.m_body = new IdentifierInstruction(this.m_bindings[i].getName());
        this.m_toMatch = toMatch;
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Object[] getVariableNames() {
        return Binding.getNames(this.m_bindings);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public Binding[] getBindings() {
        return this.m_bindings;
    }

    @Override
    public int getChildInstructionCount() {
        return 2;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_toMatch;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_toMatch = n2;
                break;
            }
            case 1: {
                this.m_body = n2;
            }
        }
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException("tuple-match is syntactic sugar and must be removed prior to codegen");
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        TupleMatchInstruction tmi = new TupleMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), Binding.getNames(this.m_bindings), this.m_body.cloneWithoutTypeInformation());
        TupleMatchInstruction.propagateInfo(this, tmi);
        return tmi;
    }

    @Override
    public Instruction cloneShallow() {
        TupleMatchInstruction i = new TupleMatchInstruction(this.m_toMatch, Binding.getNames(this.m_bindings), this.m_body);
        TupleMatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_toMatch = rh.reduceToBasicInstruction(state, this.m_toMatch, benv);
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        for (int i = 0; i < this.m_bindings.length; ++i) {
            rh2.upgradeBinding(this.m_bindings[i]);
            benv.setVariableBinding(this.m_bindings[i]);
        }
        this.m_body = rh2.reduce(this.m_body, benv);
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] types2 = new Type[this.m_bindings.length];
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        for (int i = 0; i < types2.length; ++i) {
            this.m_bindings[i].setTypeEnvironment(tenv);
            types2[i] = this.m_bindings[i].getBindingType();
            benv2.setVariableBinding(this.m_bindings[i]);
        }
        tenv.unify(new TupleType(types2), this.m_toMatch.typeCheck(tenv, benv, functionStack), this);
        return this.setCachedType(this.m_body.typeCheck(tenv, benv2, functionStack));
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        Type t = null;
        try {
            this.m_toMatch.typeCheckReduced(tenv, benv, functionStack);
            t = this.m_toMatch.getType(tenv, benv);
            Type[] types2 = new Type[this.m_bindings.length];
            for (int i = 0; i < types2.length; ++i) {
                types2[i] = this.m_bindings[i].getBindingType();
                this.m_bindings[i].setType(types2[i]);
                benv.setVariableBinding(this.m_bindings[i]);
            }
            tenv.unify(new TupleType(types2), t, this);
            this.m_body.typeCheckReduced(tenv, benv, functionStack);
        }
        catch (TypeCheckException e) {
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"type check exception in tuple-match"});
            s_logger.logp(Level.SEVERE, s_className, "typeCheckReduced", message, e);
            throw new XylemError(message);
        }
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_body.getType(tenv, benv);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        e.pushForkScope();
        Object out = null;
        try {
            Tuple toMatch = (Tuple)this.m_toMatch.evaluate(e, f2, di, false);
            Object[] values2 = toMatch.getValues();
            int nLength = this.m_bindings.length;
            for (int k = 0; k < nLength; ++k) {
                Object value2 = values2[k];
                value2 = XCIConstruction.evalForkIfNeeded(value2, e);
                e.bindInCurrentFrame(this.m_bindings[k], value2);
            }
            out = this.m_body.evaluate(e, f2, di, tailPosition);
        }
        catch (FunctionCallInstruction.TailCallEvent tc) {
            try {
                throw tc;
            }
            catch (Throwable throwable) {
                e.popForkScope(out);
                throw throwable;
            }
        }
        e.popForkScope(out);
        return Debugger.leave(di, this, e, f2, out);
    }

    @Override
    public String innerToString() {
        return "tuple-match";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen(this.innerToString(), indent, this.getTypeForTypeAnnotationPrettyPrint());
        if (this.m_toMatch == null) {
            pw.print(" !null!");
        } else {
            this.m_toMatch.toString(pw, indent + 1);
        }
        pw.print(" (");
        for (int i = 0; i < this.m_bindings.length; ++i) {
            pw.printIdentifier(this.m_bindings[i], indent + 2);
        }
        pw.printFormClose(indent);
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_toMatch);
        wofh.writeTypeSpecificBindingSet(this.m_bindings);
        wofh.writeInstruction(this.m_body);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_toMatch = rofh.readInstruction(benv);
        this.m_bindings = rofh.readTypeSpecificBindingSet();
        this.m_body = rofh.readInstruction(benv);
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 1;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (i != 1) {
            return null;
        }
        return this.m_bindings;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object[] vars = new Object[this.m_bindings.length];
        for (int j = 0; j < this.m_bindings.length; ++j) {
            Object s = vars[j] = ing.getNewName();
            names.put(this.m_bindings[j].getName(), new IdentifierInstruction(s));
        }
        return new TupleMatchInstruction(this.m_toMatch.assignNewNames(names, ing), vars, this.m_body.assignNewNames(names, ing));
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_bindings.length;
    }

    @Override
    public Type getTypeParameter(int i) {
        return this.m_bindings[i].getBindingType();
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        this.m_bindings[i].setType(n2);
    }
}

