/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TypeMatchInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction,
ISpecialForm {
    protected Match[] m_matches;
    protected Instruction m_toMatch;
    protected Instruction m_default;

    public TypeMatchInstruction() {
    }

    public TypeMatchInstruction(Instruction toMatch, Match[] matches2, Instruction defaultClause) {
        this.m_toMatch = toMatch;
        this.m_matches = matches2;
        this.m_default = defaultClause;
    }

    @Override
    public int getChildInstructionCount() {
        return (this.m_default == null ? 1 : 2) + this.m_matches.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_default != null) {
            if (i == 0) {
                return this.m_default;
            }
            --i;
        }
        switch (i) {
            case 0: {
                return this.m_toMatch;
            }
        }
        return this.m_matches[i - 1].m_handler;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_default != null) {
            if (i == 0) {
                this.m_default = n2;
                return;
            }
            --i;
        }
        switch (i) {
            case 0: {
                this.m_toMatch = n2;
                break;
            }
            default: {
                this.m_matches[i - 1].m_handler = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneWithoutTypeInformation();
        }
        TypeMatchInstruction i = new TypeMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), matches2, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation());
        TypeMatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneShallow();
        }
        TypeMatchInstruction i = new TypeMatchInstruction(this.m_toMatch, matches2, this.m_default);
        TypeMatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type outputType = null;
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            Type t = m.doTypeCheck(tenv, benv, functionStack);
            if (outputType == null) {
                outputType = t;
                continue;
            }
            tenv.unify(t, outputType, this);
        }
        if (outputType == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "tuple-match requires at least one case"), this);
        }
        if (this.m_default != null) {
            tenv.unify(outputType, this.m_default.typeCheck(tenv, benv, functionStack), this);
        }
        this.m_toMatch.typeCheck(tenv, benv, functionStack);
        return this.setCachedType(outputType);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            m.doTypeCheckReduced(tenv, benv);
        }
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_default != null ? this.m_default.getType(tenv, benv) : this.m_matches[0].getHandler().getType(tenv, benv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        Match m = this.getEffectiveMatch(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
        if (m != null) {
            cgt = cgt.cloneBranch();
            cgt.registerBinding((IBinding)m.m_binding, this.m_toMatch);
            return m.m_handler.generateCode(cgh, cgt, null, tailPosition, il, valueStyleRequest);
        }
        if (this.m_default != null) {
            return this.m_default.generateCode(cgh, cgt.cloneBranch(), null, tailPosition, il, valueStyleRequest);
        }
        throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        Match m = this.getEffectiveMatch(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
        if (m != null) {
            cgt = cgt.cloneBranch();
            cgt.registerBinding((IBinding)m.m_binding, this.m_toMatch);
            return ((IStreamInADTOptimizationInstruction)((Object)m.m_handler)).generateCode(cgh, il, streamName, memberInADT, cgt, objectless, tailPosition);
        }
        if (this.m_default != null) {
            return ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(cgh, il, streamName, memberInADT, cgt.cloneBranch(), objectless, tailPosition);
        }
        throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        Match m = this.getEffectiveMatch(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
        if (m != null) {
            cgt = cgt.cloneBranch();
            cgt.registerBinding((IBinding)m.m_binding, this.m_toMatch);
            ((IStreamOptimizationInstruction)((Object)m.m_handler)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt, tailPosition, valueStyleRequest);
        } else if (this.m_default != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_default)).generateCodeWithStreamOptimization(cgh, il, streamName, type2, cgt.cloneBranch(), tailPosition, valueStyleRequest);
        } else {
            throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh0, Instruction[] state, BindingEnvironment benv) {
        Type t = this.m_toMatch.getCachedType();
        Instruction toMatch = rh0.reduceToBasicInstruction(state, this.m_toMatch, benv);
        if (t == null) {
            throw new RuntimeException();
        }
        if (t.resolveType(rh0.m_typeEnvironment) == null) {
            this.m_toMatch = toMatch;
            for (Match m : this.m_matches) {
                ReductionHelper rh = (ReductionHelper)rh0.clone();
                rh.upgradeBinding(m.m_binding);
                benv.setVariableBinding(m.m_binding);
                m.m_handler = rh.reduce(m.m_handler, benv);
            }
            ReductionHelper rh = (ReductionHelper)rh0.clone();
            if (this.m_default != null) {
                this.m_default = rh.reduce(this.m_default, benv);
            }
            this.m_bindingEnvironment = null;
            state[0] = this;
        } else {
            Match m = this.getEffectiveMatch(rh0.m_typeEnvironment, benv);
            if (m != null) {
                ReductionHelper rh = (ReductionHelper)rh0.clone();
                rh.registerConvertedBinding(m.m_binding, ((IdentifierInstruction)toMatch).getBinding(benv));
                state[0] = rh.reduceToBasicInstruction(state, m.getHandler(), benv);
            } else {
                ReductionHelper rh = (ReductionHelper)rh0.clone();
                state[0] = rh.reduceToBasicInstruction(state, this.m_default, benv);
            }
        }
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        Match m = this.getEffectiveMatch(tenv, benv);
        if (m != null) {
            return m.m_handler.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        if (this.m_default != null) {
            return this.m_default.supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        throw new XylemError("ERR_SYSTEM", "type-match has no matching case");
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof TypeMatchInstruction)) {
            return false;
        }
        return super.equals(arg0);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        for (int i = 0; i < this.m_matches.length; ++i) {
            if (((IStreamInADTOptimizationInstruction)((Object)this.m_matches[i].m_handler)).canGenerateObjectless(tenv)) continue;
            return false;
        }
        return this.m_default == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).canGenerateObjectless(tenv);
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Match[] getMatches() {
        return this.m_matches;
    }

    public Instruction getDefault() {
        return this.m_default;
    }

    public void setDefault(Instruction d) {
        this.m_default = d;
    }

    public Match getEffectiveMatch(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_toMatch.getCachedType();
        if (t == null) {
            t = this.m_toMatch.getType(tenv, benv);
        }
        t = t.resolveType(tenv);
        for (int j = 0; j < this.m_matches.length; ++j) {
            Match m = this.m_matches[j];
            if (!m.m_binding.getBindingType().resolveType(tenv).equals(t)) continue;
            return m;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Match m;
        Object ans;
        block7: {
            if (null != di) {
                di.enter(this, e, f2);
            }
            e.pushForkScope();
            ans = null;
            try {
                m = this.getEffectiveMatch(f2.getTypeEnvironment(), this.getBindingEnvironment() == null ? f2.getBindingEnvironment() : this.getBindingEnvironment());
                if (m != null) break block7;
                if (this.m_default == null) {
                    throw new RuntimeException();
                }
                ans = this.m_default.evaluate(e, f2, di, tailPosition);
                Object object2 = Debugger.leave(di, this, e, f2, ans);
                e.popForkScope(ans);
                return object2;
            }
            catch (Throwable throwable) {
                e.popForkScope(ans);
                throw throwable;
            }
        }
        Object toMatch = this.m_toMatch.evaluate(e, f2, di, false);
        e.bindInCurrentFrame(m.m_binding, toMatch);
        Object result2 = null;
        result2 = m.getHandler().evaluate(e, f2, di, tailPosition);
        ans = result2;
        e.popForkScope(ans);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("type-match", indent);
        this.m_toMatch.toString(pw, indent + 1);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match c = this.m_matches[i];
            c.toString(pw, indent + 1);
        }
        if (this.m_default != null) {
            pw.printFormOpen("otherwise", indent + 1);
            this.m_default.toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            set2.remove(m.m_binding);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            set2.remove(m.m_binding);
        }
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = matches2[i] = this.m_matches[i].cloneShallow();
            Object s = ing.getNewName();
            names.put(m.m_binding.getName(), new IdentifierInstruction(s));
            m.m_binding.setName(s);
            m.m_handler = m.m_handler.assignNewNames(names, ing);
        }
        return new TypeMatchInstruction(this.m_toMatch.assignNewNames(names, ing), matches2, this.m_default == null ? null : this.m_default.assignNewNames(names, ing));
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_toMatch);
        wofh.writeBoolean(this.m_default != null);
        if (this.m_default != null) {
            wofh.writeInstruction(this.m_default);
        }
        int c = this.m_matches.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeType(this.m_matches[i].m_binding.getBindingType());
            wofh.writeBindingName(this.m_matches[i].m_binding.getName());
            wofh.writeInstruction(this.m_matches[i].m_handler);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_toMatch = rofh.readInstruction(benv);
        boolean b = rofh.readBoolean();
        if (b) {
            this.m_default = rofh.readInstruction(benv);
        }
        int c = rofh.readInt();
        this.m_matches = new Match[c];
        for (int i = 0; i < c; ++i) {
            this.m_matches[i] = new Match(rofh.readType(), rofh.readBindingName(), rofh.readInstruction(benv));
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (this.m_default != null) {
            --i;
        }
        switch (i) {
            case -1: {
                return NO_BINDINGS;
            }
            case 0: {
                return null;
            }
        }
        if (this.m_matches == null) {
            return null;
        }
        return new Binding[]{this.m_matches[i - 1].m_binding};
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    public static class Match {
        Instruction m_handler;
        protected Binding m_binding;

        public String toString() {
            return "(case (" + this.m_binding.getBindingType() + ' ' + this.m_binding.getName() + ") " + this.m_handler + ')';
        }

        public Instruction getHandler() {
            return this.m_handler;
        }

        public void setHandler(Instruction h) {
            this.m_handler = h;
        }

        public Binding getBinding() {
            return this.m_binding;
        }

        public Match(Type type2, Object var, Instruction handler) {
            this.m_handler = handler;
            this.m_binding = new Binding(var, type2, (ISpecialForm)null);
        }

        Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            this.m_binding.setTypeEnvironment(tenv);
            BindingEnvironment benv2 = new BindingEnvironment(benv, this.m_binding);
            return this.m_handler.typeCheck(tenv, benv2, functionStack);
        }

        void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv) {
            benv.setVariableBinding(this.m_binding);
        }

        Match cloneWithoutTypeInformation() {
            Match i = new Match(this.m_binding.getBindingType(), this.m_binding.getName(), this.m_handler.cloneWithoutTypeInformation());
            return i;
        }

        Match cloneShallow() {
            return new Match(this.m_binding.getBindingType(), this.m_binding.getName(), this.m_handler);
        }

        void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen("case", indent);
            pw.printFormOpen(this.m_binding.getBindingType().prettyPrint(), indent + 1);
            pw.printIdentifier(this.m_binding, indent + 2);
            pw.printFormClose(indent + 1);
            this.m_handler.toString(pw, indent + 1);
            pw.printFormClose(indent);
        }
    }
}

