/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class UnaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand;

    public UnaryPrimopInstruction() {
    }

    protected UnaryPrimopInstruction(Instruction op1) {
        this.m_operand = op1;
    }

    public final Instruction getOperand() {
        return this.m_operand;
    }

    @Override
    public final int getChildInstructionCount() {
        return 1;
    }

    @Override
    public final Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_operand;
            }
        }
        return null;
    }

    @Override
    public final void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_operand = n2;
            }
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        Instruction operand2 = rh.reduceToBasicInstruction(state, this.m_operand, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand = operand2;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1);

    @Override
    public Instruction cloneShallow() {
        Instruction i = this.cloneWithoutTypeInformation(this.m_operand);
        UnaryPrimopInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_operand = rofh.readInstruction(benv);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_operand);
    }

    public void setOperand(Instruction x) {
        this.m_operand = x;
    }

    @Override
    public Instruction cloneReduced() {
        if (Instruction.CLONEREDUCEDSHALLOW) {
            return this.cloneShallow();
        }
        return super.cloneReduced();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }
}

