/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import java.io.IOException;
import java.util.LinkedList;

public class UnionInjectInstruction
extends UnaryPrimopInstruction {
    protected Type m_unionType;
    protected int m_index;
    protected int m_unionSize;

    public UnionInjectInstruction(Type unionType, int index2, int unionSize, Instruction value2) {
        super(value2);
        this.m_unionType = unionType;
        this.m_index = index2;
        this.m_unionSize = unionSize;
    }

    public UnionInjectInstruction() {
    }

    public int getIndex() {
        return this.m_index;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException("UnionInjectInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] vars = new Type[this.m_unionSize];
        for (int i = 0; i < this.m_unionSize; ++i) {
            vars[i] = i == this.m_index ? this.m_operand.typeCheck(tenv, benv, functionStack) : new TypeVariable();
        }
        UnionType ut = new UnionType(vars);
        tenv.unify(ut, this.m_unionType, this);
        return this.setCachedType(this.m_unionType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_unionType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_unionType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        UnionInjectInstruction i = new UnionInjectInstruction(this.m_unionType, this.m_index, this.m_unionSize, this.m_operand.cloneWithoutTypeInformation());
        UnionInjectInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        UnionInjectInstruction i = new UnionInjectInstruction(this.m_unionType, this.m_index, this.m_unionSize, operand2);
        UnionInjectInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "union-inject";
    }

    @Override
    protected Type getTypeForTypeAnnotationPrettyPrint() {
        Type t = this.getCachedType();
        if (t == null) {
            t = this.m_unionType;
        }
        return t;
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return "" + this.m_unionType.prettyPrint() + " " + this.m_index + " " + this.m_unionSize;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = this.m_operand.evaluate(e, f2, di, false);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_unionType = rofh.readType();
        this.m_index = rofh.readInt();
        this.m_unionSize = rofh.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeType(this.m_unionType);
        wofh.writeInt(this.m_index);
        wofh.writeInt(this.m_unionSize);
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        return this.m_operand.isStatic(benv);
    }

    @Override
    public Type getTypeParameter(int i) {
        return this.m_unionType;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_unionType = n2;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }
}

