/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalBasedOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class UnionMatchInstruction
extends Instruction
implements ISpecialForm {
    protected Binding[] m_bindings;
    protected Instruction[] m_handlers;
    protected Instruction m_toMatch;

    public UnionMatchInstruction() {
    }

    public UnionMatchInstruction(Instruction toMatch, Binding[] bindings, Instruction[] handlers) {
        this.m_toMatch = toMatch;
        this.m_bindings = bindings;
        this.m_handlers = handlers;
        if (this.m_bindings.length == 0 || this.m_handlers.length == 0 || this.m_bindings.length != this.m_handlers.length) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_handlers.length + 1;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_toMatch;
            }
        }
        return this.m_handlers[i - 1];
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_toMatch = n2;
                break;
            }
            default: {
                this.m_handlers[i - 1] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] copy2 = new Instruction[this.m_handlers.length];
        for (int i = 0; i < copy2.length; ++i) {
            copy2[i] = this.m_handlers[i].cloneWithoutTypeInformation();
        }
        UnionMatchInstruction i = new UnionMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), Binding.cloneBindings(this.m_bindings), copy2);
        UnionMatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] copy2 = new Instruction[this.m_handlers.length];
        System.arraycopy(this.m_handlers, 0, copy2, 0, copy2.length);
        UnionMatchInstruction i = new UnionMatchInstruction(this.m_toMatch, Binding.cloneBindings(this.m_bindings), copy2);
        UnionMatchInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] types2 = new Type[this.m_handlers.length];
        Type outputType = null;
        for (int i = 0; i < this.m_handlers.length; ++i) {
            BindingEnvironment benv2 = new BindingEnvironment(benv, this.m_bindings[i]);
            Type t = this.m_handlers[i].typeCheck(tenv, benv2, functionStack);
            if (outputType == null) {
                outputType = t;
            } else {
                tenv.unify(outputType, t, this.m_handlers[i]);
            }
            types2[i] = this.m_bindings[i].getBindingType();
        }
        tenv.unify(new UnionType(types2), this.m_toMatch.typeCheck(tenv, benv, functionStack), this);
        return this.setCachedType(outputType);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            benv.setVariableBinding(this.m_bindings[i]);
            this.m_handlers[i].typeCheckReduced(tenv, benv, functionStack);
        }
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_handlers[0].getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_handlers[0].getPreTypecheckType(msig);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException("UnionMatchInstruction should be removed by PolimorphicADTDesugarer.");
    }

    @Override
    public void generateReducedForm(ReductionHelper rh0, Instruction[] state, BindingEnvironment benv) {
        Instruction toMatch;
        this.m_toMatch = toMatch = rh0.reduceToBasicInstruction(state, this.m_toMatch, benv);
        int c = this.m_handlers.length;
        for (int i = 0; i < c; ++i) {
            Instruction m = this.m_handlers[i];
            ReductionHelper rh = (ReductionHelper)rh0.clone();
            rh.upgradeBinding(this.m_bindings[i]);
            benv.setVariableBinding(this.m_bindings[i]);
            this.m_handlers[i] = rh.reduce(m, benv);
        }
        this.m_bindingEnvironment = null;
        state[0] = this;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].supportsCodeGenerationOptimization(cgos, tenv, benv)) continue;
                return false;
            }
            return false;
        }
        if (cgos instanceof StreamInADTOptimizationStyle || cgos instanceof ConventionalBasedOptimizationStyle) {
            for (int i = 0; i < this.m_handlers.length; ++i) {
                if (this.m_handlers[i].supportsCodeGenerationOptimization(cgos, tenv, benv)) continue;
                return false;
            }
            return false;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof UnionMatchInstruction)) {
            return false;
        }
        return super.equals(arg0);
    }

    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            if (((IStreamInADTOptimizationInstruction)((Object)this.m_handlers[i])).canGenerateObjectless(tenv)) continue;
            return false;
        }
        return false;
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("union-match", indent);
        this.m_toMatch.toString(pw, indent + 1);
        for (int i = 0; i < this.m_handlers.length; ++i) {
            pw.printFormOpen("case", indent + 1);
            pw.printFormOpen(this.m_bindings[i].getBindingType().prettyPrint(), indent + 2);
            pw.printIdentifier(this.m_bindings[i], indent + 3);
            pw.printFormClose(indent + 2);
            this.m_handlers[i].toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        pw.printFormClose(indent);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            set2.remove(this.m_bindings[i]);
        }
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Instruction[] matches2 = new Instruction[this.m_handlers.length];
        Binding[] bindings = new Binding[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            matches2[i] = this.m_handlers[i].cloneShallow();
            Object s = ing.getNewName();
            names.put(this.m_bindings[i].getName(), new IdentifierInstruction(s));
            bindings[i].setName(s);
            bindings[i].setType(this.m_bindings[i].getBindingType());
            matches2[i].assignNewNames(names, ing);
        }
        return new UnionMatchInstruction(this.m_toMatch.assignNewNames(names, ing), bindings, matches2);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_toMatch);
        int c = this.m_bindings.length;
        wofh.writeTypeSpecificBindingSet(this.m_bindings);
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.m_handlers[i]);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_toMatch = rofh.readInstruction(benv);
        this.m_bindings = rofh.readTypeSpecificBindingSet();
        int c = this.m_bindings.length;
        this.m_handlers = new Instruction[c];
        for (int i = 0; i < c; ++i) {
            this.m_handlers[i] = rofh.readInstruction(benv);
        }
        if (this.m_bindings.length == 0 || this.m_handlers.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        switch (i) {
            case -1: {
                return NO_BINDINGS;
            }
            case 0: {
                return null;
            }
        }
        if (this.m_bindings == null) {
            return null;
        }
        return new Binding[]{this.m_bindings[i - 1]};
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return this.getChildInstructionBindings(i) != null;
    }
}

