/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;

public class UntagStreamInstruction
extends UnaryPrimopInstruction {
    protected String m_tag;
    protected Type m_elementType;

    public UntagStreamInstruction(String tag, Instruction value2) {
        super(value2);
        this.m_tag = tag;
    }

    public UntagStreamInstruction() {
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        return this.m_operand.generateCode(cg, cgt, varNameSuggestion, tailPosition, il, valueStyleRequest);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_elementType = new TypeVariable();
        TagType tt = new TagType(this.m_tag, this.m_elementType);
        tenv.unify(this.m_operand.typeCheck(tenv, benv, functionStack), tt.getStreamType(), this);
        return this.setCachedType(this.m_elementType.getStreamType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_elementType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_elementType.getStreamType();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        super.generateReducedForm(rh, state, benv);
        this.setupType(rh.m_typeEnvironment, benv);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        super.typeCheckReduced(tenv, benv, functionStack);
        this.setupType(tenv, benv);
    }

    protected void setupType(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_operand.getType(tenv, benv);
        if (t instanceof StreamType && ((StreamType)t).getElementType() instanceof TagType) {
            this.m_elementType = ((TagType)((StreamType)t).getElementType()).getElementType();
        } else if (this.m_elementType == null) {
            this.m_elementType = new TypeVariable();
        }
        try {
            tenv.unify(new TagType(this.m_tag, this.m_elementType).getStreamType(), this.m_operand.getType(tenv, benv), this);
        }
        catch (TypeCheckException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        UntagStreamInstruction i = new UntagStreamInstruction(this.m_tag, this.m_operand.cloneWithoutTypeInformation());
        UntagStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        UntagStreamInstruction i = new UntagStreamInstruction(this.m_tag, operand2);
        UntagStreamInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "untag-stream";
    }

    @Override
    protected String toStringInnerNonChildParam() {
        return this.m_tag;
    }

    @Override
    public boolean equals(Object arg0) {
        return super.equals(arg0) && ((UntagStreamInstruction)arg0).m_tag.equals(this.m_tag);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = this.m_operand.evaluate(e, f2, di, false);
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_tag = rofh.readString();
        this.m_elementType = rofh.readType();
        if (this.m_elementType == null) {
            throw new RuntimeException();
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_tag);
        wofh.writeType(this.m_elementType);
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        return this.m_operand.isStatic(benv);
    }

    @Override
    public Type getTypeParameter(int i) {
        if (i == 0) {
            return this.m_elementType;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_elementType = n2;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_elementType == null ? 0 : 1;
    }
}

