/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import java.util.Iterator;

public class AbstractDataObject
implements IForkReleaseManaged {
    protected Object[] m_values;
    protected AbstractDataType.Constructor m_constructor;
    protected boolean m_mustForkAndRelease = false;
    private boolean m_containsCursors = false;
    private boolean m_requiresRelease = false;

    AbstractDataObject() {
    }

    public AbstractDataObject(AbstractDataType.Constructor c, Object[] values2, boolean fork) {
        this.init(c, values2, fork);
    }

    public AbstractDataObject(AbstractDataType.Constructor c, Object[] values2) {
        this(c, values2, false);
    }

    protected void init(AbstractDataType.Constructor c, Object[] values2) {
        this.init(c, values2, false);
    }

    protected void init(AbstractDataType.Constructor c, Object[] values2, boolean shouldFork) {
        this.m_constructor = c;
        this.m_values = values2;
        boolean didFork = false;
        boolean containsCursors = false;
        for (int i = values2.length - 1; i >= 0; --i) {
            Releasable fork;
            Object v = values2[i];
            if (v instanceof Cursor) {
                containsCursors = true;
                if (!shouldFork) continue;
                fork = ((Cursor)v).fork(false);
                didFork = true;
                if (!this.m_requiresRelease) {
                    this.m_requiresRelease = fork.requiresRelease();
                }
                values2[i] = fork;
                continue;
            }
            if (!(v instanceof IForkReleaseManaged)) continue;
            containsCursors = true;
            if (!shouldFork) continue;
            fork = (IForkReleaseManaged)((IForkReleaseManaged)v).evaluateInstanceFork();
            didFork = true;
            if (!this.m_requiresRelease) {
                this.m_requiresRelease = fork.requiresRelease();
            }
            values2[i] = fork;
        }
        this.m_containsCursors = containsCursors;
        this.m_mustForkAndRelease = didFork;
    }

    public AbstractDataType.Constructor getConstructor() {
        return this.m_constructor;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('(');
        sb.append(this.m_constructor.getName());
        for (int i = 0; i < this.m_values.length; ++i) {
            sb.append(' ');
            String n2 = this.m_constructor.m_parameters[i].getName().toString();
            Object v = this.m_values[i];
            if (v instanceof String || v instanceof StringStream) {
                v = "\"" + v + "\"";
            } else if (v instanceof IStream) {
                IStream ls = (IStream)v;
                StringBuffer vb = new StringBuffer("(stream");
                Iterator<Object> it = ls.iterator();
                while (it.hasNext()) {
                    vb.append(' ');
                    vb.append(it.next());
                }
                vb.append(')');
                v = vb.toString();
            }
            if (n2.startsWith("attribute:")) {
                sb.append(v);
                continue;
            }
            sb.append(v);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractDataObject)) {
            return false;
        }
        AbstractDataObject ado = (AbstractDataObject)obj;
        if (ado.m_constructor != this.m_constructor || ado.m_values.length != this.m_values.length) {
            return false;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_values[i] == null && ado.m_values[i] == null) {
                return true;
            }
            if (this.m_values[i].equals(ado.m_values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.m_requiresRelease && this.m_mustForkAndRelease) {
            this.m_mustForkAndRelease = false;
            for (int i = this.m_values.length - 1; i >= 0; --i) {
                Object x = this.m_values[i];
                if (x instanceof Releasable) {
                    ((Releasable)x).release();
                }
                assert (this.nullValue(this.m_values, i));
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_requiresRelease;
    }

    private final boolean nullValue(Object[] array, int index2) {
        array[index2] = null;
        return true;
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.m_containsCursors) {
            Object[] newvalues = (Object[])this.m_values.clone();
            return new AbstractDataObject(this.m_constructor, newvalues, true);
        }
        return this;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }
}

