/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StreamUtilities;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.CharArrayWriter;
import java.util.Iterator;

public class CharArrayWriterStream
implements IAppendableStream,
IConvertible {
    protected CharArrayWriter m_caw = new CharArrayWriter();

    @Override
    public Iterator<Object> iterator() {
        final String string2 = this.m_caw.toString();
        return new Iterator<Object>(){
            int m_i = 0;
            int m_c = string2.length();

            @Override
            public boolean hasNext() {
                return this.m_i < this.m_c;
            }

            @Override
            public Object next() {
                return new Character(string2.charAt(this.m_i++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.m_caw.toString();
    }

    @Override
    public char[] toCharArray() {
        return this.m_caw.toCharArray();
    }

    @Override
    public Object convert(IntegerSettings is2, Type t) {
        if (t.equals(JavaObjectType.s_javaStringType)) {
            return this.m_caw.toString();
        }
        if (t.equals(CharType.s_charType.getStreamType())) {
            return this.toCharArray();
        }
        throw new XylemError("ERR_SYSTEM", "Cannot convert StringStream to " + t);
    }

    @Override
    public int size() {
        return this.m_caw.size();
    }

    @Override
    public Object get(int i) {
        return new Character(this.m_caw.toCharArray()[i]);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)obj);
    }

    public int hashCode() {
        return StreamUtilities.hashCode(this);
    }

    @Override
    public void append(Object o, Type bindingType) {
        if (o instanceof IStream) {
            char[] ca = ((IStream)o).toCharArray();
            this.m_caw.write(ca, 0, ca.length);
        } else if (o instanceof String) {
            char[] ca = ((String)o).toCharArray();
            this.m_caw.write(ca, 0, ca.length);
        } else if (o instanceof Character) {
            this.m_caw.write(((Character)o).charValue());
        } else {
            throw new IllegalArgumentException();
        }
    }
}

