/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import java.net.URL;

public class Closure
implements IContext,
IForkReleaseManaged {
    public Object[] m_closureValues;
    public IBinding[] m_closureBindings;
    public Function m_function;
    public Instruction m_expression;
    public IBinding[] m_params;
    public URL m_definitionURL;
    public int m_definitionLineNumber;
    public boolean m_mustForkAndRelease = false;
    public boolean m_requiresRelease = false;
    public int m_stackFrameSize;

    public Closure() {
    }

    public Closure(IBinding[] closureBindings, Object[] closureValues, Function f2, Instruction i, IBinding[] p, URL url, int lineno, int stackFrameSize) {
        this.m_closureBindings = closureBindings;
        this.setClosureValues(closureValues);
        this.m_function = f2;
        this.m_expression = i;
        this.m_params = p;
        this.m_definitionURL = url;
        this.m_definitionLineNumber = lineno;
        this.m_stackFrameSize = stackFrameSize;
    }

    public void setClosureValues(Object[] closureValues) {
        this.m_closureValues = closureValues;
        if (this.m_closureValues != null) {
            for (int cv = this.m_closureValues.length - 1; cv >= 0 && !this.m_mustForkAndRelease; --cv) {
                Object v = this.m_closureValues[cv];
                if (v instanceof Cursor) {
                    this.m_mustForkAndRelease = true;
                    if (this.m_requiresRelease) continue;
                    this.m_requiresRelease = ((Cursor)v).requiresRelease();
                    continue;
                }
                if (!(v instanceof IForkReleaseManaged)) continue;
                this.m_mustForkAndRelease |= ((IForkReleaseManaged)v).mustForkAndRelease();
                if (this.m_requiresRelease) continue;
                this.m_requiresRelease = ((IForkReleaseManaged)v).requiresRelease();
            }
        }
    }

    @Override
    public String getName() {
        return "<closure " + this.hashCode() + ">";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public URL getDefinitionURL() {
        return this.m_definitionURL;
    }

    @Override
    public int getDefinitionLineNumber() {
        return this.m_definitionLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Environment e, Object[] paramValues, IDebuggerInterceptor di) {
        e.pushForkScope();
        Object ret = null;
        try {
            IBinding[] b = this.getParams();
            e.establishStackFrame(this.getStackFrameSize(), this.getName());
            assert (b.length == paramValues.length);
            for (int i = 0; i < b.length; ++i) {
                e.bindInEstablishedFrame(b[i], paramValues[i]);
            }
            e.pushStackFrame(this.getName());
            Debugger.enterContext(di, this);
            assert (this.m_closureBindings.length == this.m_closureValues.length);
            int nClosueBindings = this.m_closureBindings.length;
            for (int i = 0; i < nClosueBindings; ++i) {
                Object value2 = this.m_closureValues[i];
                IBinding binding = this.m_closureBindings[i];
                e.bindInCurrentFrame(binding, value2);
            }
            ret = this.m_expression.evaluate(e, this.m_function, di, false);
            Debugger.leaveContext(di, this, ret);
            e.popStackFrame(this.getName());
            e.popForkScope(ret);
        }
        catch (Throwable throwable) {
            e.popForkScope(ret);
            throw throwable;
        }
        return ret;
    }

    public Object evaluate(Environment e, IDebuggerInterceptor di) {
        return null;
    }

    public Object evaluate(Environment e, Function f2, Instruction[] arguments, IDebuggerInterceptor di) {
        return this.evaluate(null, e, f2, arguments, di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(IAppendableStream as, Environment e, Function f2, Instruction[] arguments, IDebuggerInterceptor di) {
        e.pushForkScope();
        Object ret = null;
        try {
            IBinding[] b = this.getParams();
            e.establishStackFrame(this.getStackFrameSize(), this.getName());
            for (int i = 0; i < b.length; ++i) {
                Object o = arguments[i].evaluate(e, f2, di, false);
                e.bindInEstablishedFrame(b[i], o);
            }
            e.pushStackFrame(this.getName());
            Debugger.enterContext(di, this);
            assert (this.m_closureBindings.length == this.m_closureValues.length);
            int nClosueBindings = this.m_closureBindings.length;
            for (int i = 0; i < nClosueBindings; ++i) {
                Object value2 = this.m_closureValues[i];
                IBinding binding = this.m_closureBindings[i];
                e.bindInCurrentFrame(binding, value2);
            }
            if (as != null) {
                this.m_expression.evaluate(as, e, this.m_function, di);
            } else {
                ret = this.m_expression.evaluate(e, this.m_function, di, false);
            }
            Debugger.leaveContext(di, this, ret);
            e.popStackFrame(this.getName());
            e.popForkScope(ret);
        }
        catch (Throwable throwable) {
            e.popForkScope(ret);
            throw throwable;
        }
        return ret;
    }

    @Override
    public void release() {
        if (this.m_requiresRelease && this.m_mustForkAndRelease) {
            for (int i = this.m_closureValues.length - 1; i >= 0; --i) {
                Object x = this.m_closureValues[i];
                if (!(x instanceof Releasable)) continue;
                ((Releasable)x).release();
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_requiresRelease;
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.m_mustForkAndRelease) {
            Object[] newvalues = (Object[])this.m_closureValues.clone();
            for (int i = newvalues.length - 1; i >= 0; --i) {
                Object x = newvalues[i];
                if (x instanceof IForkReleaseManaged) {
                    newvalues[i] = ((IForkReleaseManaged)x).evaluateInstanceFork();
                    continue;
                }
                if (!(x instanceof Cursor)) continue;
                Cursor xci2 = (Cursor)x;
                newvalues[i] = xci2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
            }
            return new Closure(this.m_closureBindings, newvalues, this.m_function, this.m_expression, this.m_params, this.m_definitionURL, this.m_definitionLineNumber, this.m_stackFrameSize);
        }
        return this;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }

    public IBinding[] getParams() {
        return this.m_params;
    }

    public void setParams(IBinding[] params) {
        this.m_params = params;
    }

    public int getStackFrameSize() {
        return this.m_stackFrameSize;
    }

    public void setStackFrameSize(int stackFrameSize) {
        this.m_stackFrameSize = stackFrameSize;
    }
}

