/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebuggerQuitException;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;

public class DebugTracer
extends Debugger {
    public DebugTracer(Module m) {
        super(m);
        this.m_verbosityLevel = 0;
    }

    @Override
    public void enter(String str, Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        System.out.println("<!--" + str + "\n-->\n<Evaluate_" + ++this.enterLeaveId + ">\n");
        this.enter1(instr, environment, function2);
    }

    @Override
    public void quietEnter(Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        this.enter1(instr, environment, function2);
    }

    @Override
    public void leave(String str, Environment environment, Function function2, Object value2) {
        System.out.println("</Evaluate_" + this.enterLeaveId-- + "><!--" + value2 + "-->\n");
        this.leave1(environment, function2, value2);
    }

    @Override
    public void quietLeave(Instruction instr, Environment environment, Function function2, Object value2) {
        System.out.println("<Evaluate_" + (this.enterLeaveId + 1) + "/><!--" + value2 + "-->\n");
        this.leave1(environment, function2, value2);
    }

    @Override
    public void enterContext(IContext context2) throws DebuggerQuitException {
        StringBuffer name2 = new StringBuffer("");
        if (context2 != null) {
            if (context2 instanceof Function) {
                Function f2 = (Function)context2;
                name2.append("(");
                String funcName = f2.getName();
                name2.append(funcName);
                Binding[] parms = f2.getParameters();
                for (int i = 0; i < parms.length; ++i) {
                    name2.append(" ");
                    name2.append(parms[i].getName());
                }
                name2.append(")");
            } else {
                name2.append(context2.getName());
            }
        }
        System.out.println("<!--" + name2.toString() + "-->\n<context>");
        this.enterContext1(context2);
    }

    @Override
    public void leaveContext(IContext context2, Object value2) {
        System.out.println("</context><!--" + value2 + "-->\n");
        this.leaveContext1(context2, value2);
    }

    private final boolean atStoppingPoint() {
        return false;
    }

    @Override
    protected final void commandLine(int stepOverFlag) throws DebuggerQuitException {
    }
}

