/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.IContext;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.XylemC;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LoopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebugTracer;
import com.ibm.xltxe.rnm1.xylem.interpreter.DebuggerQuitException;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.EvaluateTerminateException;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Debugger
implements IDebuggerInterceptor {
    protected int m_verbosityLevel = 1;
    private String m_mostRecentConsoleMsg = "";
    private boolean m_sawNewLine = true;
    private ArrayList m_instructionBreakPoints = new ArrayList();
    private boolean m_waitingForBreakpoint = false;
    private ArrayList m_stack = new ArrayList();
    private ArrayList m_contextStack = new ArrayList();
    private Set m_functionBreakPoints = new HashSet();
    private boolean m_breakOnTerminate = true;
    private StackEntry m_target = null;
    private IContext m_contextTarget = null;
    Module m_module = null;
    protected int enterLeaveId = -1;
    InputStreamReader m_charReader = new InputStreamReader(System.in);
    BufferedReader m_reader = new BufferedReader(this.m_charReader);

    public static IDebuggerInterceptor factory(Module m) {
        Debugger dbg = null;
        String debuggerClass = System.getProperty(IDebuggerInterceptor.class.getName());
        if (debuggerClass == null || debuggerClass.equals(Debugger.class.getName())) {
            dbg = HiddenOptions.wasSpecified("filtracer") ? new DebugTracer(m) : new Debugger(m);
        } else {
            try {
                Class<?> clazz = Class.forName(debuggerClass);
                Constructor<?> ctor = clazz.getConstructor(Module.class);
                return (IDebuggerInterceptor)ctor.newInstance(m);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Debug interceptor class not found: " + debuggerClass);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Debug interceptor class doesn't have the right constructor: " + debuggerClass);
            }
            catch (InvocationTargetException e) {
                System.err.println("Debug interceptor class instantiation failedr: " + debuggerClass);
            }
            catch (IllegalAccessException e) {
                System.err.println("Debug interceptor class instantiation failedr: " + debuggerClass);
            }
            catch (InstantiationException e) {
                System.err.println("Debug interceptor class instantiation failedr: " + debuggerClass);
            }
        }
        return dbg;
    }

    public Debugger(Module m) {
        this.m_module = m;
    }

    @Override
    public int getVerbosityLevel() {
        return this.m_verbosityLevel;
    }

    private final StackEntry top() {
        if (this.m_stack.isEmpty()) {
            return null;
        }
        return (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
    }

    private final Environment topEnvironment() {
        StackEntry top = this.top();
        return null == top ? null : top.m_envir;
    }

    private final String topEnvironmentString() {
        Environment envir = this.topEnvironment();
        return null == envir ? "--- No Environment ---" : envir.toString();
    }

    private final boolean shouldBreak(Instruction instr) {
        String currentFunctionName = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
        for (int i = 0; i < this.m_instructionBreakPoints.size(); ++i) {
            InstructionBreakPoint bp = (InstructionBreakPoint)this.m_instructionBreakPoints.get(i);
            if (!bp.m_instruction.equals(instr.getClass()) || !bp.m_functionName.equals(currentFunctionName)) continue;
            if (bp.m_lineno == 0) {
                return true;
            }
            if (bp.m_lineno != instr.getSourceLineNumber()) continue;
            return true;
        }
        return false;
    }

    public static final Object leave(IDebuggerInterceptor di, Instruction instr, Environment environment, Function function2, Object value2) {
        if (null == di) {
            return value2;
        }
        di.leave(instr, environment, function2, value2);
        return value2;
    }

    public static final Object quietLeave(IDebuggerInterceptor di, Instruction instr, Environment environment, Function function2, Object value2) {
        if (null == di) {
            return value2;
        }
        di.quietLeave(instr, environment, function2, value2);
        return value2;
    }

    public static final Object leave(IDebuggerInterceptor di, String str, Environment environment, Function function2, Object value2) {
        if (null == di) {
            return value2;
        }
        di.leave(str, environment, function2, value2);
        return value2;
    }

    public static final EvaluateTerminateException terminate(IDebuggerInterceptor di, Instruction instr, Environment environment, Function function2, String message) {
        EvaluateTerminateException exception = new EvaluateTerminateException(message);
        if (null != di) {
            di.terminate(instr, environment, function2, message);
        }
        throw exception;
    }

    public static final void enterContext(IDebuggerInterceptor di, IContext context2) {
        if (null == di) {
            return;
        }
        di.enterContext(context2);
    }

    public static final Object leaveContext(IDebuggerInterceptor di, IContext context2, Object value2) {
        if (null == di) {
            return value2;
        }
        di.leaveContext(context2, value2);
        return value2;
    }

    protected void enter1(Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        this.m_stack.add(new StackEntry(instr, environment, function2));
        if (this.atStoppingPoint()) {
            this.commandLine(2);
        } else if (this.shouldBreak(instr)) {
            if (this.m_verbosityLevel < 2) {
                System.out.println("Found breakpoint");
            }
            this.m_waitingForBreakpoint = false;
            this.commandLine(2);
        }
    }

    @Override
    public void enter(String str, Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println(++this.enterLeaveId + " Enter " + str);
        } else {
            this.m_mostRecentConsoleMsg = "Enter " + str;
        }
        this.enter1(instr, environment, function2);
    }

    @Override
    public void quietEnter(Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        if (this.m_verbosityLevel != 0) {
            this.m_mostRecentConsoleMsg = "Enter " + instr;
        }
        this.enter1(instr, environment, function2);
    }

    @Override
    public void enter(Instruction instr, Environment environment, Function function2) throws DebuggerQuitException {
        this.enter(instr.toString(), instr, environment, function2);
    }

    protected void leave1(Environment environment, Function function2, Object value2) {
        StackEntry oldSE;
        StackEntry stackEntry = oldSE = this.m_stack.size() > 0 ? (StackEntry)this.m_stack.remove(this.m_stack.size() - 1) : null;
        if (oldSE == this.m_target) {
            this.m_target = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    @Override
    public void leave(String str, Environment environment, Function function2, Object value2) {
        if (this.m_verbosityLevel == 0) {
            System.out.println(this.enterLeaveId-- + " Leave " + str + " --- value: " + value2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave " + str + " --- value: " + value2;
        }
        this.leave1(environment, function2, value2);
    }

    @Override
    public void quietLeave(Instruction instr, Environment environment, Function function2, Object value2) {
        if (this.m_verbosityLevel == 0) {
            System.out.println(this.enterLeaveId + 1 + " Enter/Leave " + instr + " --- value: " + value2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave " + instr + " --- value: " + value2;
        }
        this.leave1(environment, function2, value2);
    }

    @Override
    public void leave(Instruction instr, Environment environment, Function function2, Object value2) {
        this.leave(instr.toString(), environment, function2, value2);
    }

    @Override
    public void terminate(Instruction instr, Environment environment, Function function2, String message) {
        System.out.println("Terminate " + instr + " --- message: " + message);
        if (this.atStoppingPoint() || this.m_breakOnTerminate) {
            this.commandLine(0);
        }
    }

    @Override
    public void enterContext(IContext context2) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Enter Context " + context2.getName());
        } else {
            this.m_mostRecentConsoleMsg = "Enter Context " + context2.getName();
        }
        this.enterContext1(context2);
    }

    protected void enterContext1(IContext context2) throws DebuggerQuitException {
        this.m_contextStack.add(context2);
        if (this.atStoppingPoint() || this.m_functionBreakPoints.contains(context2.getName())) {
            this.m_target = null;
            this.m_contextTarget = null;
            this.m_waitingForBreakpoint = false;
            this.commandLine(1);
        }
    }

    @Override
    public void leaveContext(IContext context2, Object value2) {
        String name2;
        String string2 = name2 = context2 != null ? context2.getName() : "";
        if (this.m_verbosityLevel == 0) {
            System.out.println("Leave Context " + name2 + " --- value: " + value2);
        } else {
            this.m_mostRecentConsoleMsg = "Leave Context " + name2 + " --- value: " + value2;
        }
        this.leaveContext1(context2, value2);
    }

    protected void leaveContext1(IContext context2, Object value2) {
        IContext oldContext = (IContext)this.m_contextStack.remove(this.m_contextStack.size() - 1);
        if (oldContext == this.m_contextTarget) {
            this.m_contextTarget = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    private final boolean atStoppingPoint() {
        return null == this.m_target && null == this.m_contextTarget && !this.m_waitingForBreakpoint;
    }

    private void clearLine() throws IOException {
        this.m_reader.readLine();
    }

    protected void commandLine(int stepOverFlag) throws DebuggerQuitException {
        try {
            block11: while (true) {
                int cmd;
                if (this.m_sawNewLine && this.m_mostRecentConsoleMsg.length() > 0) {
                    System.out.println(this.m_mostRecentConsoleMsg);
                    this.m_mostRecentConsoleMsg = "";
                    this.m_sawNewLine = false;
                }
                if (105 == (cmd = this.m_charReader.read())) {
                    return;
                }
                if (111 == cmd) {
                    switch (stepOverFlag) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.m_contextTarget = (IContext)this.m_contextStack.get(this.m_contextStack.size() - 1);
                            break;
                        }
                        case 2: {
                            this.m_target = (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
                            break;
                        }
                        default: {
                            throw new XylemError("ERR_SYSTEM", "Bad stepOverFlag value (" + stepOverFlag + ")");
                        }
                    }
                    return;
                }
                if (101 == cmd) {
                    try {
                        System.out.println(this.topEnvironmentString());
                    }
                    catch (Exception e) {
                        System.err.println("Unexpected Exception: " + e);
                        e.printStackTrace();
                    }
                    continue;
                }
                if (115 == cmd) {
                    int lvl = 1;
                    int i = this.m_contextStack.size() - 1;
                    while (true) {
                        if (i < 0) continue block11;
                        IContext context2 = (IContext)this.m_contextStack.get(i);
                        StringBuffer buf = new StringBuffer();
                        buf.append(lvl + ":" + context2.getName());
                        if (context2.getDefinitionURL() != null) {
                            buf.append(" at " + new File(context2.getDefinitionURL().getFile()).getCanonicalPath() + " line " + context2.getDefinitionLineNumber());
                        }
                        System.out.println(buf.toString());
                        --i;
                        ++lvl;
                    }
                }
                if (102 == cmd) {
                    System.out.print("Name of function to break on? > ");
                    this.clearLine();
                    String functionName = this.m_reader.readLine();
                    if (this.m_functionBreakPoints.contains(functionName)) {
                        this.m_functionBreakPoints.remove(functionName);
                        System.out.println("Removing function breakpoint for " + functionName);
                        continue;
                    }
                    if (!this.lookupFunction(functionName, this.m_module)) {
                        System.err.println("Can't find function \"" + functionName + "\".");
                        continue;
                    }
                    this.m_functionBreakPoints.add(functionName);
                    System.out.println("Adding function breakpoint for " + functionName);
                    continue;
                }
                if (99 == cmd) {
                    this.m_target = null;
                    this.m_contextTarget = null;
                    this.m_waitingForBreakpoint = true;
                    return;
                }
                if (116 == cmd) {
                    this.m_breakOnTerminate = !this.m_breakOnTerminate;
                    continue;
                }
                if (98 == cmd) {
                    this.clearLine();
                    InstructionBreakPoint newBP = InstructionBreakPoint.getFromInput(true, this.m_module, this.m_reader);
                    if (null == newBP) continue;
                    this.m_instructionBreakPoints.add(newBP);
                    continue;
                }
                if (104 == cmd) {
                    String currentFunctionName = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
                    Instruction currentInstruction = ((StackEntry)this.m_stack.get((int)(this.m_stack.size() - 1))).m_instr;
                    Class<?> currentInstructionClass = currentInstruction.getClass();
                    int currentLineno = currentInstruction.getSourceLineNumber();
                    this.m_instructionBreakPoints.add(new InstructionBreakPoint(currentFunctionName, currentInstructionClass, currentLineno));
                    continue;
                }
                if (66 == cmd) {
                    int i = 0;
                    while (true) {
                        if (i >= this.m_instructionBreakPoints.size()) continue block11;
                        System.out.println("Break at " + (InstructionBreakPoint)this.m_instructionBreakPoints.get(i));
                        ++i;
                    }
                }
                if (118 == cmd) {
                    System.out.print("Debugger verbosity set to ");
                    if (0 == this.m_verbosityLevel) {
                        this.m_verbosityLevel = 1;
                        System.out.println("normal");
                        continue;
                    }
                    this.m_verbosityLevel = 0;
                    System.out.println("verbose");
                    continue;
                }
                if (113 == cmd) {
                    throw new DebuggerQuitException();
                }
                if (63 == cmd) {
                    System.out.println("FIL Debugger commands:");
                    System.out.println("  f - set function breakpoint");
                    System.out.println("  c - continue FIL program execution");
                    System.out.println("  t - break on terminate");
                    System.out.println("  b - set instruction breakpoint");
                    System.out.println("  B - list instruction breakpoints");
                    System.out.println("  h - set instruction breakpoint here");
                    System.out.println("  v - toggle debugger verbosity level");
                    System.out.println("  q - quit");
                    System.out.println("  ? - show available commands");
                    continue;
                }
                if (10 == cmd || 13 == cmd) {
                    this.m_sawNewLine = true;
                    continue;
                }
                System.err.println("Command '" + (char)cmd + "' not understood, try again.");
            }
        }
        catch (DebuggerQuitException e) {
            throw e;
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            System.err.println("Unexpected Exception");
        }
    }

    private boolean lookupFunction(String functionName, Module module) {
        if (module.getFunction(functionName) != null) {
            return true;
        }
        Iterator<Module> modules = module.getModules().iterator();
        while (modules.hasNext()) {
            if (modules.next().getFunction(functionName) == null) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        LinkedList<URL> m_signatureSearchPath = new LinkedList<URL>();
        try {
            SessionContext session = new SessionContext();
            m_signatureSearchPath.addFirst(new File(".").toURL());
            ModuleSignatureStore m_mss = new ModuleSignatureStore(m_signatureSearchPath);
            URL url = new File(args[0]).toURL();
            m_signatureSearchPath.addFirst(url);
            Module m = XylemC.XYLEMC.compile(url, null, m_signatureSearchPath, m_mss);
            m_signatureSearchPath.removeFirst();
            Debugger d = new Debugger(m);
            BasicDynamicContext dynamicContext = new BasicDynamicContext(session);
            Environment e = new Environment(dynamicContext);
            Function f2 = m.getFunction("main");
            d.enterContext(f2);
            Object ans = f2.getBody().evaluate(e, f2, d, false);
            d.leaveContext(f2, ans);
            e.release(null);
            System.out.println("End of program execution.");
        }
        catch (DebuggerQuitException e) {
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static class InstructionBreakPoint {
        private static Map m_instrMap = new HashMap();
        private int m_lineno = 0;
        private String m_functionName;
        private Class m_instruction;

        public InstructionBreakPoint(String functionName, Class instruction2, int lineno) {
            this.m_functionName = functionName;
            this.m_instruction = instruction2;
            this.m_lineno = lineno;
        }

        public String toString() {
            return this.m_instruction.getName() + " in " + this.m_functionName + (this.m_lineno != 0 ? " at line " + this.m_lineno : "");
        }

        private static void initInstrMap() {
            if (!m_instrMap.isEmpty()) {
                return;
            }
            m_instrMap.put("loop", LoopInstruction.class);
            m_instrMap.put("choose", ChooseInstruction.class);
            m_instrMap.put("apply", ApplyInstruction.class);
            m_instrMap.put("lambda", LambdaInstruction.class);
        }

        public static final InstructionBreakPoint getFromInput(boolean functionNotClosure, Module module, BufferedReader reader) {
            InstructionBreakPoint.initInstrMap();
            try {
                String functionName = null;
                FunctionSignature sig = null;
                if (functionNotClosure) {
                    while (null == sig) {
                        System.out.println("What's the enclosing function? ('cancel' to not add breakpoint) ");
                        functionName = reader.readLine();
                        if (functionName.equals("cancel")) {
                            return null;
                        }
                        sig = module.getFunctionSignature(functionName);
                        if (null != sig) continue;
                        System.err.println("Can't find function \"" + functionName + "\".");
                    }
                } else {
                    while (null == functionName) {
                        System.out.println("What's the enclosing closure number? ('cancel' to not add breakpoint) ");
                        functionName = reader.readLine();
                        if (functionName.equals("cancel")) {
                            return null;
                        }
                        functionName = "<closure " + functionName + ">";
                    }
                }
                String instrName = null;
                Class<?> instrClass = null;
                while (null == instrClass) {
                    System.out.println("What's the instruction? ('cancel' to not add breakpoint) ");
                    instrName = reader.readLine();
                    if (instrName.equals("cancel")) {
                        return null;
                    }
                    instrClass = (Class<?>)m_instrMap.get(instrName);
                    if (null == instrClass) {
                        try {
                            instrClass = Class.forName("com.ibm.xltxe.rnm1.xylem.instructions." + instrName);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (null == instrClass) {
                        try {
                            instrClass = Class.forName(instrName);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (null != instrClass) continue;
                    System.err.println("I don't know about instr \"" + instrName + "\".");
                }
                return new InstructionBreakPoint(functionName, instrClass, 0);
            }
            catch (IOException e) {
                System.out.println("Unexpected IOException: " + e);
                return null;
            }
        }
    }

    public class StackEntry {
        Instruction m_instr;
        Environment m_envir;
        Function m_func;

        public StackEntry(Instruction instr, Environment environment, Function function2) {
            this.m_instr = instr;
            this.m_envir = environment;
            this.m_func = function2;
        }

        public boolean equals(Object other2) {
            if (!(other2 instanceof StackEntry)) {
                return false;
            }
            return this.m_instr == ((StackEntry)other2).m_instr;
        }
    }
}

