/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;
import com.ibm.xml.xci.dp.util.misc.IntStack;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ForkStack {
    private int cursorCount = 0;
    static final int INITIALSTACKSIZE = 32;
    static final int GROWSTACKAMOUNT = 128;
    private Releasable[] forkedCursorsForRelease = new Releasable[32];
    private IntStack forkedCursorScopes = new IntStack(128);
    static int DEBUG_FORKSCOPE_COUNT = 0;
    static NullReleasable nullReleasable = new NullReleasable();

    public final void pushForkScope() {
        this.forkedCursorScopes.push(this.cursorCount);
    }

    public final void popForkScope(Releasable escapingObject) {
        boolean found1 = false;
        int localCursorCountEnd = this.forkedCursorScopes.pop();
        for (int index2 = this.cursorCount - 1; index2 >= localCursorCountEnd; --index2) {
            Releasable fork = this.forkedCursorsForRelease[index2];
            if (found1 || fork != escapingObject) {
                fork.release();
                continue;
            }
            found1 = true;
        }
        this.cursorCount = localCursorCountEnd;
        if (found1) {
            this.pushForkForRelease(escapingObject);
        }
    }

    public final void popForkScope(Object escapingObject) {
        boolean found1 = false;
        int localCursorCountEnd = this.forkedCursorScopes.pop();
        for (int index2 = this.cursorCount - 1; index2 >= localCursorCountEnd; --index2) {
            Releasable fork = this.forkedCursorsForRelease[index2];
            if (fork != escapingObject) {
                fork.release();
                continue;
            }
            found1 = true;
        }
        this.cursorCount = localCursorCountEnd;
        if (found1) {
            this.pushForkForRelease((Releasable)escapingObject);
        }
    }

    public final void popForkScope() {
        int localCursorCountEnd = this.forkedCursorScopes.pop();
        for (int index2 = this.cursorCount - 1; index2 >= localCursorCountEnd; --index2) {
            Releasable fork = this.forkedCursorsForRelease[index2];
            fork.release();
        }
        this.cursorCount = localCursorCountEnd;
    }

    public boolean popTopForkIfMatch(Releasable popThis) {
        Releasable fork;
        int index2 = this.cursorCount - 1;
        if (index2 >= 0 && popThis == (fork = this.forkedCursorsForRelease[index2])) {
            --this.cursorCount;
            return true;
        }
        return false;
    }

    private void grow() {
        int elementCount = this.forkedCursorsForRelease.length;
        Releasable[] newData = new Releasable[elementCount * 2];
        System.arraycopy(this.forkedCursorsForRelease, 0, newData, 0, elementCount);
        this.forkedCursorsForRelease = newData;
    }

    private final void push(Releasable releasable) {
        if (releasable.requiresRelease()) {
            if (this.cursorCount == this.forkedCursorsForRelease.length) {
                this.grow();
            }
            this.forkedCursorsForRelease[this.cursorCount++] = releasable;
        }
    }

    private final Releasable pushForkForRelease(Releasable fork) {
        if (fork != null) {
            this.push(fork);
        }
        return fork;
    }

    public final Cursor pushForkForRelease(Cursor fork) {
        if (fork != null) {
            this.push(fork);
        }
        return fork;
    }

    public final IForkReleaseManaged pushIForkReleaseManagedForRelease(IForkReleaseManaged fork) {
        if (fork != null) {
            this.push(fork);
        }
        return fork;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        if (!this.forkedCursorScopes.isEmpty()) {
            int sizeOfCursorScopeStack;
            int numberOfScopes = this.forkedCursorScopes.size();
            int topOfCursorScopeFrame = sizeOfCursorScopeStack = this.cursorCount;
            for (int i = numberOfScopes - 1; i >= 0; --i) {
                pw.println("=== fork scopes #" + i + " ===");
                int bottomOfCursorScopeFrame = this.forkedCursorScopes.get(i);
                topOfCursorScopeFrame = this.printScope(pw, topOfCursorScopeFrame, bottomOfCursorScopeFrame, this.forkedCursorsForRelease, "Cursors");
            }
        } else {
            pw.println("=== fork scopes is empty ===");
        }
        pw.flush();
        return buf.toString();
    }

    private int printScope(PrintWriter pw, int topOfScopeFrame, int bottomOfScopeFrame, Releasable[] forkedForRelease, String typeString) {
        int sizeOfScope = topOfScopeFrame - bottomOfScopeFrame;
        if (sizeOfScope < 0) {
            sizeOfScope = 0;
        }
        if (sizeOfScope == 0) {
            pw.println("  (" + typeString + " empty)");
        } else {
            while (topOfScopeFrame > bottomOfScopeFrame) {
                Releasable fork;
                if ((fork = forkedForRelease[--topOfScopeFrame]) != null) {
                    pw.println("  " + typeString + " pos #" + topOfScopeFrame + " " + fork.getClass().getSimpleName() + " - " + fork.toString());
                    continue;
                }
                pw.println("  " + typeString + " pos #" + topOfScopeFrame + " (nulled entry)");
            }
            topOfScopeFrame = bottomOfScopeFrame;
        }
        return topOfScopeFrame;
    }

    public void removeForkForRelease(Cursor toBeRemoved, boolean searchJustCurrentScope) {
        if (this.forkedCursorScopes.isEmpty()) {
            return;
        }
        int bottomOfScopeFrame = searchJustCurrentScope ? this.forkedCursorScopes.peek() : 0;
        int topOfScopeFrame = this.cursorCount;
        --topOfScopeFrame;
        while (topOfScopeFrame >= bottomOfScopeFrame) {
            Releasable fork = this.forkedCursorsForRelease[topOfScopeFrame];
            if (toBeRemoved == fork) {
                this.forkedCursorsForRelease[topOfScopeFrame] = nullReleasable;
                return;
            }
            --topOfScopeFrame;
        }
    }

    public boolean isFound(Cursor objectToBeFound, boolean searchJustCurrentScope) {
        return this.isFound(objectToBeFound, searchJustCurrentScope, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    public boolean isFound(IForkReleaseManaged objectToBeFound, boolean searchJustCurrentScope) {
        return this.isFound(objectToBeFound, searchJustCurrentScope, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    public boolean isFound(Object objectToBeFound, boolean searchJustCurrentScope) {
        return this.isFound(objectToBeFound, searchJustCurrentScope, this.forkedCursorsForRelease, this.forkedCursorScopes) || this.isFound(objectToBeFound, searchJustCurrentScope, this.forkedCursorsForRelease, this.forkedCursorScopes);
    }

    private boolean isFound(Object objectToBeFound, boolean searchJustCurrentScope, Releasable[] forkedForRelease, IntStack forkedScopes) {
        if (forkedScopes.isEmpty()) {
            return false;
        }
        int bottomOfScopeFrame = searchJustCurrentScope ? forkedScopes.peek() : 0;
        int topOfScopeFrame = this.cursorCount;
        --topOfScopeFrame;
        while (topOfScopeFrame >= bottomOfScopeFrame) {
            Releasable fork = forkedForRelease[topOfScopeFrame];
            if (objectToBeFound == fork) {
                return true;
            }
            --topOfScopeFrame;
        }
        return false;
    }

    public void removeIForkReleaseManagedForRelease(IForkReleaseManaged toBeRemoved, boolean searchJustCurrentScope) {
        if (this.forkedCursorScopes.isEmpty()) {
            return;
        }
        int bottomOfScopeFrame = searchJustCurrentScope ? this.forkedCursorScopes.peek() : 0;
        int topOfScopeFrame = this.cursorCount;
        --topOfScopeFrame;
        while (topOfScopeFrame >= bottomOfScopeFrame) {
            Releasable fork = this.forkedCursorsForRelease[topOfScopeFrame];
            if (toBeRemoved == fork) {
                this.forkedCursorsForRelease[topOfScopeFrame] = nullReleasable;
                return;
            }
            --topOfScopeFrame;
        }
        assert (false) : "IForkReleaseManaged to be removed not found!";
    }

    static class NullReleasable
    implements Releasable {
        NullReleasable() {
        }

        @Override
        public void release() {
        }

        @Override
        public boolean requiresRelease() {
            return false;
        }
    }
}

