/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.dataflow.ForkInformation;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.dp.util.misc.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FramedStack {
    private static final long serialVersionUID = 177098682861761697L;
    private static final Logger s_logger = LoggerUtil.getLogger(FramedStack.class);
    private static final String s_className = FramedStack.class.getName();
    private static final UnboundValue UNBOUNDVALUE = new UnboundValue();
    private static final UnboundIBinding UNBOUNDBINDING = new UnboundIBinding();
    private static final boolean LOG = false;
    private Object[] values;
    private IBinding[] ibindings;
    private int startCurrentStackFrame;
    private Stack<Integer> stackFrameStarts = new Stack();
    private int totalSizeOfStack;
    private Stack<Integer> framesSizes = new Stack();
    private static int INCREMENTSIZE = 65536;

    public FramedStack(int capacity) {
        this.values = new Object[capacity];
        this.ibindings = new IBinding[capacity];
        this.framesSizes.push(0);
        this.stackFrameStarts.push(0);
        this.startCurrentStackFrame = 0;
    }

    public final void establishStackFrame(int size) {
        this.totalSizeOfStack += size;
        this.framesSizes.push(size);
        if (this.totalSizeOfStack > this.values.length) {
            int incrementSize = size > INCREMENTSIZE ? size + INCREMENTSIZE : INCREMENTSIZE;
            Object[] newValues = new Object[this.values.length + incrementSize];
            IBinding[] newIbindings = new IBinding[this.ibindings.length + incrementSize];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            System.arraycopy(this.ibindings, 0, newIbindings, 0, this.ibindings.length);
            this.values = newValues;
            this.ibindings = newIbindings;
        }
        assert (this.garbageCurrentFrame(this.totalSizeOfStack - size, size));
    }

    public final void establishStackFrame(int size, String funcName) {
        this.totalSizeOfStack += size;
        this.framesSizes.push(size);
        assert (this.garbageCurrentFrame(this.totalSizeOfStack - size, size));
    }

    public final void pushStackFrame() {
        this.stackFrameStarts.push(this.startCurrentStackFrame);
        this.startCurrentStackFrame = this.totalSizeOfStack - this.framesSizes.peek();
    }

    public final void pushStackFrame(String funcName) {
        this.stackFrameStarts.push(this.startCurrentStackFrame);
        this.startCurrentStackFrame = this.totalSizeOfStack - this.framesSizes.peek();
    }

    public final void popStackFrame() {
        assert (this.garbageCurrentFrame(this.startCurrentStackFrame, this.framesSizes.peek()));
        this.startCurrentStackFrame = this.stackFrameStarts.pop();
        int lastFrameSize = this.framesSizes.pop();
        this.totalSizeOfStack -= lastFrameSize;
    }

    public final void popStackFrame(String funcName) {
        assert (this.garbageCurrentFrame(this.startCurrentStackFrame, this.framesSizes.peek()));
        this.startCurrentStackFrame = this.stackFrameStarts.pop();
        int lastFrameSize = this.framesSizes.pop();
        this.totalSizeOfStack -= lastFrameSize;
    }

    public final void bindInCurrentFrame(IBinding b, Object value2) {
        assert (this.isGoodStackPos(b));
        int stackPos = this.startCurrentStackFrame + b.getStackFramePos();
        this.values[stackPos] = value2;
        this.ibindings[stackPos] = b;
    }

    public final void bindInEstablishedFrame(IBinding b, Object value2) {
        assert (this.isGoodStackPos(b));
        int stackPos = this.totalSizeOfStack - this.framesSizes.peek() + b.getStackFramePos();
        this.values[stackPos] = value2;
        this.ibindings[stackPos] = b;
    }

    private boolean isGoodStackPos(IBinding b) {
        if (b.getStackFramePos() < 0) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Bad binding: " + b});
            RuntimeException e = new RuntimeException(message);
            s_logger.logp(Level.SEVERE, s_className, "isGoodStackPos", message, e);
            throw e;
        }
        return true;
    }

    public final Object lookupIBinding(IBinding b) {
        int stackPos = this.startCurrentStackFrame + b.getStackFramePos();
        return this.ibindings[stackPos];
    }

    public final Object lookupBoundValue(IBinding b) {
        int stackPos = this.startCurrentStackFrame + b.getStackFramePos();
        Object value2 = this.values[stackPos];
        assert (!(value2 instanceof UnboundValue));
        return value2;
    }

    public final IBinding lookupIBinding(int pos) {
        int stackPos = this.startCurrentStackFrame + pos;
        IBinding b = this.ibindings[stackPos];
        assert (!(b instanceof UnboundIBinding));
        return b;
    }

    public final Object lookupBoundValue(int pos) {
        int stackPos = this.startCurrentStackFrame + pos;
        return this.values[stackPos];
    }

    private boolean garbageCurrentFrame(int startFrame, int stackFrameSize) {
        for (int i = 0; i < stackFrameSize; ++i) {
            this.values[startFrame + i] = UNBOUNDVALUE;
            this.ibindings[startFrame + i] = UNBOUNDBINDING;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendStackDump(buffer);
        return buffer.toString();
    }

    private void appendStackDump(StringBuffer buffer) {
        buffer.append("--- current stack freme ");
        buffer.append(this.framesSizes.size() - 1);
        buffer.append(" ---\n");
        int stackFrameSize = this.framesSizes.peek();
        for (int i = 0; i < stackFrameSize; ++i) {
            buffer.append("Value: ");
            buffer.append(this.values[this.startCurrentStackFrame + i]);
            buffer.append("  IBinding: ");
            buffer.append(this.ibindings[this.startCurrentStackFrame + i]);
            buffer.append(";\n");
        }
    }

    private static final void diag(String val) {
    }

    private static class UnboundIBinding
    implements IBinding {
        private UnboundIBinding() {
        }

        public String toString() {
            return "(No Binding)";
        }

        @Override
        public Type getBindingType() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public Type getBindingType(TypeEnvironment tenv, BindingEnvironment benv) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public LetInstruction getLet() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public Object getName() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public ISpecialForm getOrigin() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int getStackFramePos() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setName(Object name2) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setStackFramePos(int pos) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int compareTo(Object o) {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public int getVariableUse() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void incrementVariableUse() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void clearVariableUse() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void passingIterator() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public ForkInformation getForkInformation() {
            throw new RuntimeException("called unbound variable binding!!");
        }

        @Override
        public void setForkInformation(ForkInformation forkInformation) {
            throw new RuntimeException("called unbound variable binding!!");
        }
    }

    private static class UnboundValue {
        private UnboundValue() {
        }

        public String toString() {
            return "(Not Bound)";
        }
    }
}

