/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;

public class InterpreterUtilities {
    private boolean debugging = false;
    public static final boolean tailCallEliminationEnabled = true;

    public void setDebuggerflag(boolean flag) {
        this.debugging = flag;
    }

    public boolean getDebuggerflag() {
        return this.debugging;
    }

    public static Method getMethod(Class classType, String name2, Class[] argTypes) {
        Method result2 = null;
        try {
            result2 = classType.getMethod(name2, argTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (result2 == null) {
            Method[] methods = classType.getMethods();
            for (int i = 0; i < methods.length && result2 == null; ++i) {
                Class<?>[] paramTypes;
                Method method = methods[i];
                if (!method.getName().equals(name2) || (paramTypes = method.getParameterTypes()).length != argTypes.length) continue;
                boolean match = true;
                for (int j = 0; j < paramTypes.length && match; ++j) {
                    if (paramTypes[j].isAssignableFrom(argTypes[j])) continue;
                    match = false;
                }
                if (!match) continue;
                result2 = method;
            }
        }
        if (result2 == null) {
            throw new XylemError("ERR_SYSTEM", "Method not found: class = " + classType + " method = " + name2 + " args = " + Arrays.asList(argTypes));
        }
        return result2;
    }

    public static Constructor getConstructor(Class classType, Class[] argTypes) {
        Constructor<Object> result2 = null;
        try {
            result2 = classType.getConstructor(argTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (result2 == null) {
            Constructor<?>[] methods = classType.getDeclaredConstructors();
            for (int i = 0; i < methods.length && result2 == null; ++i) {
                Constructor<?> method = methods[i];
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != argTypes.length) continue;
                boolean match = true;
                for (int j = 0; j < paramTypes.length && match; ++j) {
                    if (paramTypes[j].isAssignableFrom(argTypes[j])) continue;
                    match = false;
                }
                if (!match) continue;
                result2 = method;
            }
        }
        if (result2 == null) {
            throw new XylemError("ERR_SYSTEM", "Constructor not found: class = " + classType + " args = " + argTypes);
        }
        return result2;
    }
}

