/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.LazyObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import java.util.Iterator;

public abstract class LazyListStream
extends ListStream
implements LazyObject {
    protected ITypeStore m_typeStore;

    public LazyListStream(ITypeStore typeStore) {
        this.m_typeStore = typeStore;
        this.m_list = null;
    }

    protected abstract void materialize();

    @Override
    public void append(Object o, Type bindingType) {
        this.materialize();
        super.append(o, bindingType);
    }

    @Override
    public boolean equals(Object obj) {
        this.materialize();
        return super.equals(obj);
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.isMaterialized()) {
            return super.evaluateInstanceFork();
        }
        return this.evaluateLazyInstanceFork();
    }

    protected abstract Object evaluateLazyInstanceFork();

    @Override
    public void release() {
        if (this.isMaterialized()) {
            super.release();
        } else {
            this.evaluateLazyInstanceRelease();
        }
    }

    protected abstract void evaluateLazyInstanceRelease();

    @Override
    public Object get(int i) {
        this.materialize();
        return super.get(i);
    }

    @Override
    public Iterator iterator() {
        this.materialize();
        return super.iterator();
    }

    @Override
    public boolean mustForkAndRelease() {
        if (this.isMaterialized()) {
            return super.mustForkAndRelease();
        }
        return true;
    }

    @Override
    public int size() {
        if (this.isMaterialized()) {
            return this.m_list.size();
        }
        return this.lazySize();
    }

    protected abstract int lazySize();

    @Override
    public char[] toCharArray() {
        this.materialize();
        return super.toCharArray();
    }

    @Override
    public String toString() {
        this.materialize();
        return super.toString();
    }

    @Override
    public boolean isMaterialized() {
        return this.m_list != null;
    }
}

