/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LazyStream
implements IAppendableStream {
    protected List m_list = new ArrayList();
    protected Closure m_c;
    protected IDebuggerInterceptor m_di;
    protected Environment m_e;
    protected boolean m_complete = false;
    protected Object[] m_hints;

    public LazyStream(Closure c, Environment e, IDebuggerInterceptor di, Object[] hints) {
        this.m_c = c;
        this.m_di = di;
        this.m_e = e;
        this.m_hints = hints;
    }

    protected void evaluateMore(int newIndex) {
        while (!this.m_complete && newIndex >= this.m_list.size()) {
            Object x = this.m_c.evaluate(this.m_e, this.m_hints, this.m_di);
            Object[] values2 = x instanceof Tuple ? ((Tuple)x).m_values : ((AbstractDataObject)x).m_values;
            IStream stream2 = (IStream)values2[0];
            Iterator<Object> i = stream2.iterator();
            while (i.hasNext()) {
                this.m_list.add(i.next());
            }
            System.arraycopy(values2, 2, this.m_hints, 0, this.m_hints.length);
            if (!((Boolean)values2[1]).booleanValue()) continue;
            this.m_complete = true;
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            protected int m_index = 0;

            @Override
            public boolean hasNext() {
                LazyStream.this.evaluateMore(this.m_index);
                return this.m_index < LazyStream.this.m_list.size();
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LazyStream.this.m_list.get(this.m_index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void append(Object o, Type bindingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "[lazy stream]";
    }

    @Override
    public char[] toCharArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public Object get(int i) {
        this.evaluateMore(i);
        return this.m_list.get(i);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }
}

